#! /usr/bin/tcl

#
# Copyright (c) 1994 Open Software Foundation, Inc.
# 
# Permission is hereby granted to use, copy, modify and freely distribute
# the software in this file and its documentation for any purpose without
# fee, provided that the above copyright notice appears in all copies, and
# that both the copyright notice and this permission notice appear in
# supporting documentation.  Further, provided that the name of Open
# Software Foundation, Inc. ("OSF") not be used in advertising or
# publicity pertaining to distribution of the software without prior
# written permission from OSF.  OSF makes no representations about the
# suitability of this software for any purpose.  It is provided "AS IS"
# without express or implied warranty.
#

source ~nata/api/src/otPerfTest_bsh.tcl

set cmd(01) {}
set cmd(02) {-f}
set cmd(03) {-f -r}
set cmd(04) {-x '[stat open]'}
set cmd(05) {-x '[stat open] && [prior 1]'}
set cmd(06) {-x '[stat open] && [rby jeffc]'}
set cmd(07) {-s comp=vm -m}
set cmd(08) {-x '[stat open] && [rdate >12/12/92]'}
set cmd(09) {-x '([stat open] && [prior 1]) || ([rby jeffc] && [rdate >12/12/92])'}
set cmd(10) {-x '[stat closed] || [desc awk]'}
set cmd(11) {-x '[stat closed] && [desc awk]'}
set cmd(12) {-x '[stat closed] && [cdate >12/12/92]'}
set cmd(13) {-x '[stat closed] && [cdate >12/12/92] && [cby jeffc]'}
set cmd(14) {-x '[stat closed] && [fixedin 1.2]'}
set cmd(15) {-n 99 -f}
set cmd(16) {-n 2 -f}
set cmd(17) {-n 51 -f}
set cmd(18) {-n 99,199,299,365 -f}
set cmd(19) {-n 99,199,299,365}
set cmd(20) {-n 2,102,202,302 -f}
set cmd(21) {-n 51,151,251,351 -f}
set cmd(22) {-k awk}
set cmd(23) {-k awk -x '[stat open]'}
set cmd(24) {-k awk -x '[stat open]' -o prior}
set cmd(25) {-k awk -f}
set cmd(26) {-s stat=open,prior=1}
set cmd(27) {-k awk -s stat=open}
set cmd(28) {-k awk -s stat=open -o prior}
set cmd(29) {-x '[stat closed] && [cdate >12/12/92]' -f}
set cmd(30) {-x '[stat open] && [prior 1]' -f}
set cmd(31) {-s 'stat=closed,cdate=">12/12/92"' -f}
set cmd(32) {-s stat=open,prior=1 -f}



# To invoke perfTest:
# 		perfTest <projectName> <repeatFactor>
# Defaults:
# 	projectName  bigproj
#	repeatFactor  10
#       checkPoint    15

set chkpoint [expr { ([lindex $argv 3] == "") ? 15 : [lindex $argv 3] } ]
set repeat [expr { ([lindex $argv 2] == "") ? 10 : [lindex $argv 2] } ]
set proj [expr { ([lindex $argv 1] == "") ? "bigproj" : [lindex $argv 1] } ]

# check that project exist
if { ![file isdirectory /project/ot/$proj] } {
    puts stdout "*** Project directory (/project/ot/$proj) does not exist ***"
    exit
}

perfTest $proj $repeat $chkpoint
