
// Objectify -- turn C++ classes into Tcl objects.
//
// Wayne Christopher, faustus@cs.berkeley.edu
// Version 0.1, May 1, 1993
//
// Copyright (c) 1993 Wayne Christopher.  Permission is granted
// to copy, modify and distribute, provided this notice is
// preserved.  No warranty is provided or implied, etc, etc.

// This routine calls the appropriate configure routine, but has to flag
// those options that are eaten up.  The eaten vector is 0 if the flag
// hasdn't been used yet and 1 if it has.  This routine will set the
// appropriate flag if the arg is used.

extern "C" {
#define class _____class
#include "tcl.h"
#include "tk.h"
/*#include "tkConfig.h"*/
#undef class
}

extern "C" void free(char* val);

extern "C" int Obj_ConfigureWidget(Tcl_Interp *interp, Tk_ConfigSpec *specs,
			       int argc, char **argv, char* widgRec, int flags);

extern "C" int Obj_ConfigureInfo(Tcl_Interp *interp, Tk_ConfigSpec *specs,
			     char* widgRec, char* argvName, int flags);

// Which is 1 for creation, 0 for configure.

int
Objectify_Configure(Tcl_Interp* interp, Tk_Window tkwin, Tk_ConfigSpec* specs,
		    int ac, char** av, char* object, int flags, int* eaten,
		    int which)
{
    // We have to muck around here a bit since the result will get overwritten
    // by Configure*.
    int reslen = (interp->result ? strlen(interp->result) : 0);
    char* save_result = (reslen ? new char[reslen + 1] : NULL);
    if (save_result)
	strcpy(save_result, interp->result);
    Tcl_ResetResult(interp);
    
    int res = TCL_OK;
    
    if (!ac && !which) {
	if (tkwin) {
	    res = Tk_ConfigureInfo(interp, tkwin, specs, object, NULL, 0);
	} else {
	    res = Obj_ConfigureInfo(interp, specs, object, NULL, 0);
	}
    } else {
	int nac = 0;
	char** nav = new char* [ac + 1];
	
	for (int i = 0; i < ac; i += 2) {
	    char* opt = av[i];
	    int optlen = strlen(opt);
	    if (eaten[i / 2]) continue;
	    for (int j = 0; specs[j].type != TK_CONFIG_END; j++)
		if (specs[j].argvName &&
		    !strncmp(specs[j].argvName, opt, optlen))
		    break;
	    if (specs[j].type != TK_CONFIG_END) {
		nav[nac++] = av[i];
		nav[nac++] = av[i + 1];
		eaten[i / 2] = 1;
	    }
	}
	if (nac || which) {
	    if (!nav[nac - 1]) nac--;
	    nav[nac] = NULL;
	    
	    if (which && (nac == 1)) {
		Tcl_SetResult(interp, "wrong number of args for creation", 0);
		res = TCL_ERROR;
		
	    } else if (tkwin) {
		if (nac == 1)
		    res = Tk_ConfigureInfo(interp, tkwin, specs, object,
					   nav[0], 0);
		else
		    res = Tk_ConfigureWidget(interp, tkwin, specs, nac, nav,
					     object, flags);
		
	    } else {
		if (nac == 1)
		    res = Obj_ConfigureInfo(interp, specs, object, nav[0], 0);
		else
		    res = Obj_ConfigureWidget(interp, specs, nac, nav,
					      object, flags);
	    }
	}
	delete nav;
    }
    
    // We don't care about the ordering.
    if (save_result) {
	if (res == TCL_OK) {
	    Tcl_AppendResult(interp, " ", 0);
	    Tcl_AppendResult(interp, save_result, 0);
	}
	delete save_result;
    }
    
    return (res);
}

int
Objectify_Get(Tcl_Interp* interp, Tk_Window tkwin, Tk_ConfigSpec* specs,
	      char* name,  char* object, int* got)
{
    int res = TCL_OK;
    
    int namelen = strlen(name);
    for (int j = 0; specs[j].type != TK_CONFIG_END; j++)
	if (specs[j].argvName && !strncmp(specs[j].argvName, name, namelen))
	    break;
    if (specs[j].type == TK_CONFIG_END)
	return (TCL_OK);
    
    if (tkwin) {
	if (Tk_ConfigureInfo(interp, tkwin, specs, object, name, 0) != TCL_OK)
	    return (TCL_ERROR);
    } else {
	if (Obj_ConfigureInfo(interp, specs, object, name, 0) != TCL_OK)
	    return (TCL_ERROR);
    }
    int ac;
    char** av;
    if (Tcl_SplitList(interp, interp->result, &ac, &av) != TCL_OK)
	return (TCL_ERROR);
    Tcl_ResetResult(interp);
    Tcl_AppendResult(interp, av[4], 0);
    free((char *) av);
    *got = 1;
    return (TCL_OK);
}
