#
# mxsetup.bindings --
#	UI to the keystroke bindings in mxedit.
#

# mxSetupShowBindings --
#	Pop up a new window to display key bindings.
#	Note that we seem to get them back in reverse order
#	to which they were defined, so mxBindings should
#	define boring ones first.

proc mxSetupTest {} {
    global mxedit
    catch {destroy .mxB}
    source /project/tcl/src/mxedit/lib/mxsetup.bindings
    after 1 {
	mxSetupEditBindings
	mxFeedback mxSetupTest
    }
}
bind $mxedit <Control-Return> mxSetupTest

proc mxSetupEditBindings { args } {
    global mxedit
    global backgroundColor

    toplevel .mxB -background $backgroundColor
    wm title .mxB "Mxedit Key Binding Setup"

    # Control buttons
    buttonFrame .mxB .buttons
    packedButton .mxB.buttons .quit "Dismiss" {destroy .mxB}
    packedButton .mxB.buttons .save "Save" {mxSetupSaveBindings}
    packedButton .mxB.buttons .help "Help" {mxSetupHelp}
    packedButton .mxB.buttons .accept "Accept" {mxSetupAcceptBinding} right

    # Editting fields
    frame .mxB.fields -background $backgroundColor
    pack append .mxB .mxB.fields {top expand fill}
    labeledEntry .mxB.fields .binding "Keystroke:" 20 {top fillx}
    labeledEntry .mxB.fields .command "Command:" 20 {top fillx}

    # Browsing listboxes
    labeledListbox .mxB .binding "Binding" 20x20 {left fill expand}
    labeledListbox .mxB .command "Command" 40x20 {left fill expand}
    mxDualList .mxB.binding .mxB.command

    bind .mxB.binding.list <1> "mxBindingSelect .mxB.fields.binding.entry %W %y"
    bind .mxB.command.list <1> "mxBindingSelect .mxB.fields.command.entry %W %y"

    mxSetupShowBindings
}

proc mxSetupShowBindings {} {
    global mxedit
    foreach binding [bind $mxedit] {
	.mxB.binding.list insert end $binding
	.mxB.command.list insert end [bind $mxedit $binding]
    }
}

proc mxClearShowBindings {} {
    .mxB.binding.list delete 0 end
    .mxB.command.list delete 0 end
}

# mxSetupHelp --

proc mxSetupHelp {} {
    global paleBackground
    catch {
	toplevel .mxBhelp -background $paleBackground
	packedButton .mxBhelp .quit "Dismiss" {destroy .mxBhelp} top
	message .mxBhelp.msg -bg $paleBackground
	pack append .mxBhelp .mxBhelp.msg {top expand fill}
	.mxBhelp.msg configure -text "Mxedit Binding Setup
"
    }
}

# mxSetupAcceptBinding --
#	Add the currently editted entry to the master list
#
proc mxSetupAcceptBinding {} {
    global mxedit
    set binding [.mxB.fields.binding.entry get]
    set command [.mxB.fields.command.entry get]
    bind $mxedit $binding $command

    mxClearShowBindings
    mxSetupShowBindings
}

# mxSetupSaveBindings --
#	Write out the current binding definitions
#
proc mxSetupSaveBindings {} {
    global mxedit
    set bindings [bind $mxedit]
    set outfile [open ~/.mxedit.bindings.new "w"]
    puts $outfile "# .mxedit.bindings automatically generated"
    puts $outfile "# [exec date]"
    puts $outfile ""
    puts $outfile "proc mxUserBindings {} {"
    puts $outfile "    global mxedit"

    foreach binding $bindings {
	puts $outfile [format {    bind $mxedit %s {%s}} $binding [bind $mxedit $binding]]
    }
    puts $outfile "}"
}


# mxDualList --
#	Tie two list boxes together for the purposes of scrolling
#
proc mxDualList { l1 l2 } {
    destroy $l1.scroll
    $l1.list configure -yscroll "$l2.scroll set"
    $l2.scroll configure -command "mxDualYview"
    bind $l1.list <2> "mxDualScan $l1 $l2 mark %x %y"
    bind $l2.list <2> "mxDualScan $l1 $l2 mark %x %y"
    bind $l1.list <B2-Motion> "mxDualScan $l1 $l2 dragto %x %y"
    bind $l2.list <B2-Motion> "mxDualScan $l1 $l2 dragto %x %y"

    bind $l1 <1> "mxSetupBindingSelect %W %y"
}

proc mxBindingSelect { entry list y } {
    set value [$list get [$list nearest $y]]
    $entry delete 0 end
    $entry insert 0 $value
}
proc mxDualSelect { l1 l2 how y } {
    $l1.list select $how [$l1 nearest $y]
    $l2.list select $how [$l2 nearest $y]
}
proc mxDualScan { l1 l2 how x y } {
    $l1.list scan $how 0 $y
    $l2.list scan $how $x $y
}
proc mxDualYview { l1 l2 $args } {
    eval {$l1.list yview} $args
    eval {$l2.list yview} $args
}
