proc moogDoDir {dHost dPort dPath dName} {

  global i mark
  global dirType dirName dirPath dirHost dirPort

  set I $i
  incr i

  toplevel .$I

  wm maxsize .$I 500 800
  wm geometry .$I 500x300
  wm title .$I "Moog 0.2 - $dName"

  label .$I.messageLabel \
    -text "URL: gopher://$dHost:$dPort/$dPath"

  frame .$I.dirView \
    -borderwidth {3}\
    -relief {sunken}

  scrollbar .$I.dirView.scroller \
    -command ".$I.dirView.listing yview"\
    -relief {sunken}

  listbox .$I.dirView.listing \
    -geometry {10x2}\
    -yscroll ".$I.dirView.scroller set"\
    -relief {raised}

  pack append .$I.dirView \
    .$I.dirView.listing {left frame center expand fill} \
    .$I.dirView.scroller {left frame center fill} 

  frame .$I.controlFrame \
    -borderwidth {3}

  button .$I.controlFrame.fetchButton \
    -text {Fetch}\
    -command "moogFetchCB $I"

  button .$I.controlFrame.gotoButton \
    -text {Goto}\
    -command "moogGotoCB"

  button .$I.controlFrame.infoButton \
    -text {Info} \
    -command "moogInfoCB dir $I"

  button .$I.controlFrame.markButton \
    -text {Mark} \
    -command "moogMarkCB $I"

  button .$I.controlFrame.closeButton \
    -text {Close}\
    -command "destroy .$I"

  pack append .$I.controlFrame \
    .$I.controlFrame.fetchButton {left frame center expand fillx} \
    .$I.controlFrame.gotoButton {left frame center expand fillx} \
    .$I.controlFrame.infoButton {left frame center expand fillx} \
    .$I.controlFrame.markButton {left frame center expand fillx} \
    .$I.controlFrame.closeButton {left frame center expand fillx} 

  pack append .$I \
    .$I.messageLabel {top frame center fillx} \
    .$I.dirView {top frame center expand fill} \
    .$I.controlFrame {top frame center fillx} 

  bind .$I.dirView.listing <Double-1> "moogFetchCB $I"

  set plid [open "|plunder $dHost $dPort \"$dPath\"" r]

  while {![eof $plid]} {
    set len [gets $plid bit]
    set twobit [string trim $bit]

    set rr [regexp "^(.)(\[^\t\]+)\t(\[^\t\]*)\t(\[^\t\]+)\t(\[^\t\]+).*$" \
      $twobit {} type title path host port]

    if {$rr == "0"} break
 
    lappend dirType($I) $type
    lappend dirName($I) $title
    lappend dirPath($I) $path
    lappend dirHost($I) $host
    lappend dirPort($I) $port

    .$I.dirView.listing insert end "$mark($type)  $title"
  }
  close $plid
}

