proc moogBookReloadAll {markFile} {
  global bookType bookName bookPath bookHost bookPort
  global mark 

  set nomarks [llength $bookType]

  .bookMarks.listing delete 0 $nomarks

  set bookType {}
  set bookName {}
  set bookPath {}
  set bookHost {}
  set bookPort {}

  set FDbooks [open "$markFile" r]

  while {![eof $FDbooks]} {
    gets $FDbooks bit
    if {![regexp "^(\[^=\]+)=(.*)$" $bit {} attrib value]} {
      continue
    }

    case $attrib in {
      "Type"    { lappend bookType "$value"; set temptype $value}
      "Name"    { lappend bookName "$value"; \
    .bookMarks.listing insert end "$mark($temptype)  $value"}
      "Path"    { lappend bookPath "$value" }
      "Host"    { lappend bookHost "$value" }
      "Port"    { lappend bookPort "$value" }
      default   { }
    }
  }
  close $FDbooks
}

