# ~/.tk/edittkrc.tcl - user customisation file for edit.tk
#   demonstration of additional bindings to work with emacs-style
#   ~/.textbindings.tcl file
######################################################################

######################################################################
# additional Emacs-style keyboard bindings, supplementing the ones in
# .textbindings.tcl.  These have to be here because they are
# application-specific; they refer to procedures defined in edit.tk.

# do-nothing bindings:
bind Text <Control-x> {%W mark set insert insert}
bind Text <Control-u> {%W mark set insert insert} ;# naah!
bind Text <Escape> {%W mark set insert insert}
#
bind Text <Control-x><Control-s> {cmd_save}
bind Text <Control-x><Control-w> {cmd_saveas}
bind Text <Control-x><Control-f> {cmd_load}
bind Text <Control-x><Control-v> {cmd_load}
bind Text <Control-x><Control-c> {cmd_quit}
bind Text <Control-s> {cmd_find}
bind Text <Control-percent> {cmd_find}
bind Text <Control-u><Control-k> { ;# too simplistic - just an example.
  %W delete insert {insert lineend}
  %W delete insert
  %W delete insert {insert lineend}
  %W delete insert
  %W delete insert {insert lineend}
  %W delete insert
  %W delete insert {insert lineend}
  %W delete insert
}

######################################################################
# define the User menu:

if [winfo exists .menu.user] {
  destroy .menu.user
}

menubutton .menu.user -text {User} -menu .menu.user.m

menu .menu.user.m
.menu.user.m add command -label {Insert Date} -command {
  .main.t insert insert \
  [exec date | awk "\{print \$2\" \"\$3\", \"\$6\}"]
}
.menu.user.m add command -label {Insert Signature} -command {
  .main.t insert insert [exec cat $env(HOME)/.signature]
  .main.t insert insert "\n"
}
.menu.user.m add separator
.menu.user.m add command -label {Process Man Source} -command {
  tke_pipe {nroff -Tdumb -man}
}
pack append .menu .menu.user right
