# Copyright (c) 1993 by Sanjay Ghemawat
#############################################################################
# Dialog Interaction Mechanism
#
# Commands
#
# dialog_run <leader> <window> <focus> <var>
#	requires <window> is a toplevel.
#		 <focus> is a descendant of <window>.
#		 <leader> is either {}, or a window.
#	effects  Run dialog in <window> until global variable <var>
#		 is modified. <focus> has the initial keyboard focus.
#		 If <leader> is {}, the dialog is centered on the
#		 screen. Otherwise, the dialog is centered on <leader>.

proc dialog_run {leader window focus var} {
    global $var

    # Center window over leader
    if {$leader == {}} {
	set x [expr ([winfo screenwidth $window]-[winfo reqwidth $window])/2]
	set y [expr ([winfo screenheight $window]-[winfo reqheight $window])/2]
    } else {
	set x [expr [winfo rootx $leader]+[winfo width $leader]/2]
	set y [expr [winfo rooty $leader]+[winfo height $leader]/2]
	set x [expr $x-[winfo reqwidth $window]/2]
	set y [expr $y-[winfo reqheight $window]/2]
    }

    wm geometry $window +$x+$y
    wm transient $window $leader
    wm deiconify $window

    # Is this update strictly necessary?
    update

    catch {grab set $window}
    set oldfocus [focus]
    focus $focus
    tkwait variable $var
    focus $oldfocus
    grab release $window
    wm withdraw $window
    update
}
