# Copyright (c) 1993 by Sanjay Ghemawat
#############################################################################
# Printing dialog
#
# Commands
#
#	print_calendar <leader> <date>
#
#	Interact with user to print calendar contents.

# Hidden global variables
#
#	pr_init			Created pr dialog window?
#	pr_done			Is pr interaction finished
#	pr_count		Specification of how many days to print
#	pr_type			Either "save", "print", or "preview"
#	pr_save			Argument for "save"
#	pr_print		Argument for "print"
#	pr_preview		Argument for "preview"

set pr_init 0
set pr_done 0

proc print_calendar {leader date} {
    pr_make
    pr_interact $leader $date
}

proc pr_make {} {
    global pr_init pr_done pr_count pr_type pr_save pr_print pr_preview
    if {$pr_init} {return}

    set pr_init  1
    set pr_count month
    set pr_type  print

    set pr_save    cal.ps
    set pr_print   ""
    set pr_preview "ghostview -"

    global env
    catch {set pr_print $env(PRINTER)}

    set f .pr_dialog

    toplevel $f -class Dialog -geometry ""
    wm title $f Print
    wm protocol $f WM_DELETE_WINDOW {set pr_done 0}

    frame $f.top -relief raised -bd 1
    frame $f.mid -relief raised -bd 1
    frame $f.bot -relief raised -bd 1
    frame $f.bot.default -relief sunken -bd 1

    frame $f.top.l -relief flat -bd 0
    frame $f.top.r -relief flat -bd 0

    radiobutton $f.top.l.one -text "One Day"\
	-anchor w\
	-relief flat\
	-variable pr_count\
	-value 1
    radiobutton $f.top.l.two -text "Two Days"\
	-anchor w\
	-relief flat\
	-variable pr_count\
	-value 2
    radiobutton $f.top.l.four -text "Four Days"\
	-anchor w\
	-relief flat\
	-variable pr_count\
	-value 4

    radiobutton $f.top.r.eight -text "Eight Days"\
	-anchor w\
	-relief flat\
	-variable pr_count\
	-value 8
    radiobutton $f.top.r.ten -text "Ten Days"\
	-anchor w\
	-relief flat\
	-variable pr_count\
	-value 10
    radiobutton $f.top.r.month -text "Month"\
	-anchor w\
	-relief flat\
	-variable pr_count\
	-value month

    frame $f.mid.save		-relief flat -bd 0
    frame $f.mid.preview	-relief flat -bd 0
    frame $f.mid.print		-relief flat -bd 0

    radiobutton $f.mid.save.button -text "Save To"\
	-anchor w\
	-width 9\
	-relief flat\
	-variable pr_type\
	-command pr_update_entries\
	-value save
    radiobutton $f.mid.preview.button -text Previewer\
	-anchor w\
	-width 9\
	-relief flat\
	-variable pr_type\
	-command pr_update_entries\
	-value preview
    radiobutton $f.mid.print.button -text Printer\
	-anchor w\
	-width 9\
	-relief flat\
	-variable pr_type\
	-command pr_update_entries\
	-value print

    entry $f.mid.entry\
	-relief sunken\
	-bd 1\
	-width 15

    button $f.bot.default.yes -text Okay -command {set pr_done 1}
    button $f.bot.no -text Cancel -command {set pr_done 0}

    pack $f.top.l.one	-side top -fill x -padx 5m
    pack $f.top.l.two	-side top -fill x -padx 5m
    pack $f.top.l.four	-side top -fill x -padx 5m
    pack $f.top.r.eight	-side top -fill x -padx 5m
    pack $f.top.r.ten	-side top -fill x -padx 5m
    pack $f.top.r.month	-side top -fill x -padx 5m

    pack $f.top.l	-side left
    pack $f.top.r	-side right

    pack $f.mid.save.button	-side left -padx 5m
    pack $f.mid.preview.button	-side left -padx 5m
    pack $f.mid.print.button	-side left -padx 5m

    pack $f.mid.save	-side top -expand 1 -fill x
    pack $f.mid.preview	-side top -expand 1 -fill x
    pack $f.mid.print	-side top -expand 1 -fill x

    pack $f.bot.default.yes -side left -padx 2m -pady 2m
    pack $f.bot.no -side left -expand 1 -padx 4m -pady 4m
    pack $f.bot.default -side left -expand 1

    pack $f.top -side top -expand 1 -fill both
    pack $f.mid -side top -fill both
    pack $f.bot -side bottom -fill both

    pr_update_entries

    bind $f.mid.entry	<Control-c> {set pr_done 0}
    bind $f.mid.entry	<Return>    {set pr_done 1}

    wm withdraw $f
    update
}

proc pr_update_entries {} {
    global pr_type

    set f .pr_dialog
    pack forget $f.mid.entry

    $f.mid.entry configure -textvariable pr_$pr_type
    pack $f.mid.entry -in $f.mid.$pr_type -side right -expand 1 -fill x
}

proc pr_interact {leader date} {
    global pr_done
    set f .pr_dialog

    # Run dialog
    set pr_done -1
    dialog_run $leader $f $f.mid.entry pr_done
    if !$pr_done {return}

    # Actually print (make sure outfile gets closed on error)
    set out [pr_outfile]
    if [catch {
	set outfile [open $out w]
	puts $outfile [pr_output $date]
	close $outfile
    } msg] {
	catch {close $outfile}
	error "Could not print to \"$out\"\n\n$msg"
    }

    catch {close $outfile}
}

# effects - Return output file name
proc pr_outfile {} {
    global pr_type pr_save pr_preview pr_print

    switch -exact -- $pr_type {
	save {
	    set str $pr_save
	}
	preview {
	    set str "|$pr_preview"
	}
	print {
	    if {$pr_print == ""} {
		set str "|lpr"
	    } else {
		set str "|lpr -P$pr_print"
	    }
	}
	default {
	    error "Unknown printing mode $pr_type"
	}
    }

    return $str
}

# effects - Return postscript string
proc pr_output {date} {
    # Read header
    global libdir
    set header [open $libdir/header.ps r]
    if [catch {set head [read $header]} result] {
	catch {close $header}
	error $result
    }
    close $header

    global pr_count
    switch -exact -- $pr_count {
	1	{set str [psdays $date 1 1 0]}
	2	{set str [psdays $date 2 2 1]}
	4	{set str [psdays $date 4 2 0]}
	8	{set str [psdays $date 8 4 1]}
	10	{set str [psdays $date 10 5 1]}
	month	{set str [psmonth $date]}
	default {error "do not know how to print $pr_count days"}
    }

    return "$head\n%%Page: 1 1\n$str\n%%Trailer"
}
