# 
# ftocColor.tcl
#
# Color and Monochrome feedback for the ftoc display..
#
# Copyright (c) 1993 Xerox Corporation.
# Use and copying of this software and preparation of derivative works based
# upon this software are permitted. Any distribution of this software or
# derivative works must comply with all applicable United States export
# control laws. This software is made available AS IS, and Xerox Corporation
# makes no warranty about the software, its performance or its conformity to
# any specification.

proc Ftoc_ColorConfigure { text } {
    global exmh
    if {[tk colormodel .] == "monochrome"} {
	$text tag configure deleted \
	    -bgstipple @$exmh(library)/linethru.bitmap \
	    -foreground black -background black
	$text tag configure moved \
	    -bgstipple gray25 -foreground black -background black
	$text tag configure range -background white \
	    -relief raised -borderwidth 2
	$text tag configure mrange \
	    -bgstipple gray25 -background black -background black \
	    -relief raised -borderwidth 2
	$text tag configure drange \
	    -bgstipple @$exmh(library)/linethru.bitmap \
	    -foreground black -background black \
	    -relief raised -borderwidth 2
	$text tag configure unseen -underline true
	$text tag configure current \
	    -bgstipple {} -foreground white -background black
    } else {
	set current [Ftoc_Color c_current red]
	set unseen [Ftoc_Color c_unseen blue]
	set moved [Ftoc_Color c_moved yellow]
	set deleted [Ftoc_Color c_deleted grey75]
	set bg [lindex [$text configure -background] 4]
	$text tag configure deleted -background $deleted
	$text tag configure moved -background $moved
	$text tag configure range -background $bg -relief raised -borderwidth 2
	$text tag configure mrange -background $moved -relief raised -borderwidth 2
	$text tag configure drange -background $deleted -relief raised -borderwidth 2
	$text tag configure unseen -foreground $unseen
	$text tag configure current -foreground $current
    }
}

