# buttons.tcl
#
# Action buttons for EXMH.  These are divided into three sets:
# Main - global things like Help and Quit
# Folder - operations on folders like Pack, or Inc.
# Message - operations on the current message.
#
# Copyright (c) 1993 Xerox Corporation.
# Use and copying of this software and preparation of derivative works based
# upon this software are permitted. Any distribution of this software or
# derivative works must comply with all applicable United States export
# control laws. This software is made available AS IS, and Xerox Corporation
# makes no warranty about the software, its performance or its conformity to
# any specification.

proc Buttons_Main { frame } {
    # Note that the unused space in $frame is used
    # by Exmh_MainLabel to hold the version string
    global buttons
    set buttons(mainF) $frame
    Widget_AddBut $frame quit "Quit"		{ Exmh_Done }
    Widget_AddBut $frame pref "Preferences"	{ Preferences_Dialog }
    Widget_AddBut $frame bind "Bind"		{ Sedit_Pref }
    set l [expr {([tk colormodel .] == "color") ? "Color" : "B&W"}]
    Widget_AddBut $frame key  $l		{ Help_KeyDisplay }    
    Widget_AddBut $frame help "Help"		{ Help }    
}

proc Buttons_Folder { frame } {
    # Create the buttons for operations on items in MH folders
    # Note that the unsed space in $frame is used by
    # Folder_Label to display the name of the current folder.
    global buttons inc
    set buttons(folderF) $frame
    # Menu for extra stuff
    set menub [Widget_AddMenuB $frame more "More..." {right padx 1}]
    Widget_AddMenuItem $menub "Rescan folder"	{ busy Scan_FolderForce ; Msg_ShowSomething}
    Widget_AddMenuItem $menub "Pack folder"	{ busy Folder_Pack ; Msg_ShowSomething }
    Widget_AddMenuItem $menub "Sort folder"	{ busy Folder_Sort ; Msg_ShowSomething }
    Widget_AddMenuItem $menub "Find all folders" { busy Flist_Refresh }
    Widget_AddMenuItem $menub "Delete folder"	{ Folder_Delete }
    set buttons(folderMenuB) $menub

    Widget_AddBut $frame commit	"Commit" 	{ Folder_Commit }
    if {$inc(style) != "none"} {
	Widget_AddBut $frame inc	"Inc"		{ Inc }
    }
    Widget_AddBut $frame flist	"Flist"		{ Flist_FindUnseen }
    Widget_AddBut $frame find	"Find" 		{ Find_Setup }
    Widget_AddBut $frame new	"New" 		{ Folder_New }
    Widget_AddBut $frame pick	"Pick" 		{ Pick }
}

proc Buttons_Message { frame } {
    global buttons
    set buttons(msgF) $frame

    # Menu for extra stuff
    set menub [Widget_AddMenuB $frame more "More..." {right padx 1}]
    Widget_AddMenuItem $menub "Print"	{ Print }
    Widget_AddMenuItem $menub "Unmark"	{ Ftoc_Unmark } 
    Widget_AddMenuItem $menub "Clip"	{ Msg_Clip }
    Widget_AddMenuItem $menub "First Unseen" { Msg_ShowUnseen }
    Widget_AddMenuItem $menub "Burst Digest" { Msg_BurstDigest }
    set buttons(msgMenuB) $menub

    # Buttons for common stuff
    Widget_AddBut $frame move "Move"	{ Msg_Move } 
    Widget_AddBut $frame dele "Delete"	{ Msg_Remove } 
    Widget_AddBut $frame next "Next"	{ Ftoc_Next show } 
    Widget_AddBut $frame prev "Prev" 	{ Ftoc_Prev show } 
    Widget_AddBut $frame comp "Send"	  { Msg_Compose Mh_CompSetup } 
    Widget_AddBut $frame repl "reply"	  { Msg_Reply   Mh_ReplySetup } 
    Widget_AddBut $frame repl2 "ReplyAll" { Msg_Reply   Mh_ReplyAllSetup } 
    Widget_AddBut $frame forw "Forward"	  { Msg_Forward Mh_ForwSetup } 

    # The group assignments associate buttons with three states:
    # current: there is a current message
    # range: there is a range of messages selected
    # nodraft: we are *not* in the drafts folder

    # In addition, to support a special case, there is
    # comp: a group with a single item, the Send (or comp) button.

    Buttons_GroupMenu $menub current {Print Unmark Clip}
    Buttons_GroupMenu $menub range   {Print Unmark}

    Buttons_Group $frame current	{move dele repl repl2 forw}
    Buttons_Group $frame range		{move dele}
    Buttons_Group $frame comp		comp
    Buttons_Group $frame nodraft	{repl repl2 forw}

}

