# Implements a text widget for browsing and editing

# For arbitrary symbol generation

global symname symnum
set symname "sym"
set symnum 0

# Returns a new symbol upon each call
proc gensym {} {
  global symname symnum
  incr symnum
  return $symname$symnum
}


# Some entry & label creation procedures.

# Creates an entry & label and sets focus to the entry. ESC-TAB toggles between
# entry and t, which can be any other widget.
# t, label, and entry should be absolute widget names.
proc create_f_entry {t label entry} {
	catch {label $label -relief raised}
	catch {entry $entry}
	pack $label -side left
	pack $entry -side left -expand yes -fill x
	focus $entry

	bind $entry <Escape> "focus $t"
	bind $t <Escape> "focus $entry"
}

# Destroys label and entry created by create_f_entry.
proc destroy_f_entry {t label entry} {
	destroy $label ; destroy $entry
	bind $t <Escape> ";"
}

# Time to display labels
set flash_time 3000

# Displays a label for $flash_time seconds. Label lives in $parent.
# Args gets passed to the label as configuration options.
proc flash_label {parent args} {
	global flash_time
	if {($parent == ".")} {set newlabel ".m[gensym]"
	} else {set newlabel "$parent.m[gensym]"}
	eval label $newlabel $args
	pack $newlabel -side left
	after $flash_time "destroy $newlabel"
}

# An abbreviation to show in labels in lieu of their normal contents.
set label_abbrev "-"

# Toggles a label between its normal contents and $label_abbrev
proc label_expand_toggle {label variable} {
	global label_abbrev
	if {($variable == [lindex [$label configure -textvariable] 4])} {
		$label configure -textvariable "" -text $label_abbrev
	} else {$label configure -textvariable $variable
}}

# Binds MB1 to toggle between label's normal display and an abbreviated one.
proc label_expand_bind {label variable} {
	$label configure -textvariable $variable -relief flat
	bind $label <ButtonRelease-1> "label_expand_toggle %W $variable"
}


# Procedures for filling the text widget.

# Reads file a line at a time, and updates t per line.
proc read_file_graduated {t file} {
	# Enable user to interrupt with a C-g.
	set binding [bind $t <Control-g>]
	global graduated_interrupt;	set graduated_interrupt 0
	bind $t <Control-g> {set graduated_interrupt 1}

	set index [$t index insert]
	$t mark set new_stuff $index
	set v [lindex [$t configure -height] 4] ; incr v -1
	while {![eof $file]} {
		$t insert new_stuff [gets $file]
		$t insert new_stuff \n
		update ; update idletasks
		if $graduated_interrupt {beep ;	break}

		if {[$t compare insert < new_stuff]} { continue}

		scan [$t index new_stuff] "%d.%d" r1 dummy
		scan [$t index @0,0] "%d.%d" r2 dummy
		if {([expr $r1 - $v] == $r2)} {	$t yview "@0,0 +1 lines"
	}}
	$t mark unset new_stuff
	$t mark set insert $index
	bind $t <Control-g> $binding
}

# fills text widget t with contents from $file, which must be opened for
# reading. Does not clear text widget.
proc read_file_handler {t file {graduated 0}} {
	if $graduated {	read_file_graduated $t $file
	} else {set index [$t index insert]
		$t insert $index [read $file]
		$t mark set insert $index
}}

# Opens up $path/$name or just $name if it is a command pipeline, and
# fills text widget t with its contents. w/o clearing text widget first.
proc load_and_insert_file {t f path name} {
	set index [$t index insert]
	cd $path
	set graduated 0
	if {([string match \|* $name])} {
		if {[string match *\& $name]} {
			set name [string range $name 0 [expr [string length $name] - 2]]
			set graduated 1}
		set file [open $name r]
	} elseif {[catch {set file [open $path/$name r]}]} {
		flash_label $f -text "New file: $path/$name"
		return
	}
	beth_busy $t read_file_handler $t "$file" $graduated
	close $file
}

# Like load_and_insert_file but clears text widget first.
proc load_file {t f path name} {
	$t delete 1.0 end
	load_and_insert_file $t $f $path $name
}


# Create the frame widget (if it doesn't already exist)
if {(![info exists frame])} {
	set frame .frame
	catch {frame $frame -relief raised}
	catch {entry $frame.e -relief sunken -bd 2}
	$frame.e insert end [winfo name .]
	$frame.e configure -state disabled -width 5
	bind $frame.e <B1-Motion> {$frame.e select from 0 ; $frame.e select to end}
	bind $frame.e <Any-ButtonPress-1> {$frame.e select from 0 ; $frame.e select to end}
	pack $frame.e -side left
	pack $frame -side bottom -fill x
}

# Create the quit button (if user wants)
if {(![info exists dont_make_quit])} {
	catch {button $frame.q -text "Quit" -command "quit_beth"}
	pack $frame.q -side right -expand yes -fill x
}

# Create the text widget (if it doesn't already exist) and scrollbar.
if {(![info exists text])} {
	set text .text
	catch {text $text -relief sunken -bd 2 -yscrollcommand ".s set" -setgrid true}
	focus default $text
	focus $text
	catch {scrollbar .s -relief raised -command "$text yview"}
	# All Text bindings are disabled; they are re-enabled in other files.
	bind Text <Control-Key> {;}
	bind Text <Control-d> {;}
	bind Text <Control-v> {;}
	bind Text <Meta-Key>  {;}
	bind Text <Control-Meta-Key> {;}
	pack .s -side left -fill y
	pack $text -side top -expand yes -fill both
}
