# Beth example configuration file
# Illustrates some useful configs. To use this, copy it to ~/.beth

# Prevents this file from being configed twice. (This shouldn't happen, but
# due to the myriads of directory names and symlinks, anything's possible)
if {![info exists beth_configed]} {set beth_configed 1


# Beth uses some tags for things like search...here are some configs to
# play with them.

# Several tags are used in the text widget to mark text, but no visible changes
# are provided with those tags...these are best determined by the user.

# This tag graces any text that is currently being examined by search.
$text tag configure search -background gold

# This tag graces any text that was examined by the current search.
$text tag configure was_search -background gold4

# This tag graces any text that was replaced by the current search/replace.
$text tag configure was_replaced -background gold4

# This tag graces any open paren/bracket/brace whenever its closing partner
# is entered, according to balancebind.tcl
$text tag configure balance -background magenta

# This tag graces any text that has been collapsed.
$text tag configure collapsed -foreground wheat -relief raised

# $frame.fpl contains the file path, which is set to the current directory.
# The following command 'toggles' the label, so the file path is hidden, you
# can reveal it again by clicking mousebutton 1 on it. This saves space
# in the $frame widget.
catch {label_expand_toggle $frame.fpl fsBox(path)}


# When should balancebind.tcl be loaded? The following command loads it
# for every Beth instance.
eval $add_balancebind


# Which file prompter should be used?
# Defaults to Beth's own, to use Sven Delmas's FSBox code, remove the leading
# #'s from the following lines, and give the appropriate pathnamne for FSBox.
#if $edit_flag {
# 	set path $fsBox(path);	set name $fsBox(name)
# 	source FSBox.tcl
# 	set fsBox(path) $path;	set fsBox(name) $name
# 	set file_prompter FSBox
#}
}
