# Bindings for file I/O (Calls the XF file selector widget provided)

if {([info procs FSBox] == "")} {puts "You will also have to load the file selection widget"}


# Get the path/file via a file prompting widget.
proc file_prompt {msg f} {
	global fsBox
	set path $fsBox(path);	set name $fsBox(name)
	set grab_status [grab status .] 
	FSBox $msg $name
	if {($grab_status != "none")} {take_control $f}
	if {($fsBox(name) == "")} {
		set fsBox(path) $path;	set fsBox(name) $name
		return 0}
	set fsBox(name) [string trimright $fsBox(name) "*/"]
	return 1
}

# Messages
set confirm_save_msg " has been modified. Do you want to save it first?"
set save_msg "Select a file to save"
set read_msg "Select a file to read"
set mutual_edit_conflict_msg " is being editied by another interpreter. What should I do?"


# Variable to determine if file needs saving. (also set in editbind.tcl)
set modified 0

# Confirm if user wants to save the file.
proc save_confirm {default t f} {
	global modified confirm_save_msg fsBox
	set message "$fsBox(name) $confirm_save_msg"
	if {($modified == 1)} {
		set choice [dialog $message \
				$default "Save" "Don't Save" "Cancel"]
		if {($choice == 0)} {save_file $t $f}
		if {($choice == 2)} {return 0} else {return 1}
}}

# Time we last accessed this file. (generally shortly after startup time)
after 1000 {catch {set atime [file mtime $fsBox(path)/$fsBox(name)]}}

proc save_file {t f} {
	global fsBox save_msg
	if {($fsBox(name) == "")} {
		save_file_prompt $t $f
		if {($fsBox(name) == "")} {return}}
	if {([$t get {end -1 chars}] != "\n")} {$t insert end "\n"}
	set file [open "$fsBox(path)/$fsBox(name)" w]
	puts $file [$t get 1.0 end] nonewline
	close $file
	global modified atime;	set modified 0
	if {([catch {set atime [file mtime $fsBox(path)/$fsBox(name)]}])} {
		puts "how the hell can the file not exist if I just saved it?"}
	global title_comment
	reset_my_title "Edit: $fsBox(name) $title_comment" "E $fsBox(name) $title_comment"
	check_for_duplicate_interps $t $f $fsBox(path)
}

proc save_file_prompt {t f} {
	global save_msg
	if {([file_prompt $save_msg $f] == 0)} {return}
	save_file $t $f
}

proc revert_file {t f} {
	global fsBox read_msg
	if {([save_confirm 1 $t $f] == 0)} {return}
	if {($fsBox(name) == "")} {
		read_file $t $f
		if {($fsBox(name) == "")} {return}}
	set file [open "$fsBox(path)/$fsBox(name)" r]
	$t delete 1.0 end
	$t insert insert [read $file]
	close $file
	global modified	atime;	set modified 0
	if {([catch {set atime [file mtime $fsBox(path)/$fsBox(name)]}])} {
		puts "how the hell can the file not exist if I just read it?"}
	global title_comment
	reset_my_title "Edit: $fsBox(name) $title_comment" "E $fsBox(name) $title_comment"
	check_for_duplicate_interps $t $f $fsBox(path)
	$t yview 1.0 ; $t mark set insert 1.0
	focus $t
}

proc read_file {t f} {
	global read_msg
	if {([save_confirm 0 $t $f] == 0)} {return}
	if {([file_prompt $read_msg $f] == 0)} {return}
	revert_file $t $f
}

proc insert_file {t f} {
	global fsBox read_msg
	set path $fsBox(path);	set name $fsBox(name)
	if {([file_prompt $read_msg $f] == 0)} {return}
	set file [open "$fsBox(path)/$fsBox(name)" r]
	set chars [read $file]
	close $file
	global modified ; 	set modified 1
	set fsBox(path) $path;	set fsBox(name) $name
	$t insert insert $chars

	# Figure out how to undo insert
	set ustart [gensym];	set uend [gensym]
	$t mark set $uend insert
	$t mark set $ustart "insert -[string length $chars] chars"
	register_undoable_cmd $t [list $t delete $ustart $uend] "Insert $fsBox(name)" "$ustart $uend"
}

proc visit_file {f} {
	global fsBox read_msg visit_cmd
	set path $fsBox(path);	set name $fsBox(name)
	if {([file_prompt $read_msg $f] == 0)} {return}
	set int [beth_fork "$visit_cmd $fsBox(path)/$fsBox(name)"]
	set fsBox(path) $path;	set fsBox(name) $name
	if {([grab status .] != "none")} {
		relinquish_control $f 
		send $int take_control $f
}}

# Set modified if file has been modified since we last read/saved it.
proc check_mtime {} {
	global atime modified fsBox
	if {[catch {set atime}]} {return}
	if {[catch {file mtime $fsBox(path)/$fsBox(name)}]} {set modified 1 ; return}
	if {([file mtime $fsBox(path)/$fsBox(name)] > $atime)} {set modified 1
}}


# Mutual file exclusion.

# Ensures no other interp is editing the same file I am editing.
proc check_for_duplicate_interps {t f path} {
	global all_interps all_titles me
	set my_title [wm title .]
	set l [llength $all_interps]
	for {set i 0} {$i < $l} {incr i} {
		if {($my_title == [lindex $all_titles $i])} {
			set him [lindex $all_interps $i]
			# Maybe he can only browse. Fine.
			if {($me == $him)} {break}
			if {(![send $him "set edit_flag"])} {break}

			# Maybe he's looking in a different directory.
			if {($path != [send $him "set fsBox(path)"])} {break}
			resolve_mutual_edit_conflict $him "$path/[lindex $my_title 1]" $t $f
}}}

proc resolve_mutual_edit_conflict {him file t f} {
	global mutual_edit_conflict_msg
	set message "$file $mutual_edit_conflict_msg"
	set choice [dialog $message \
		0 "Quit" "Read another file" "Kill other interpreter" "Nothing"]

	if {($choice == 0)} {after 1000 quit_beth
	} elseif {($choice == 1)} {read_file $t $f
	} elseif {($choice == 2)} {catch {send $him {quit_beth
}}}}

# Confirm file saving on quit (a redefinition of quit_beth)
proc quit_beth {} {
	global quit_hook text frame
	if {([save_confirm 0 $text $frame] == 0)} {return}
	if {[info exists quit_hook]} {eval $quit_hook}
	destroy .
}


# File bindings. f is a frame widget to put messages in.
proc filebind {f} {
	bind Text <Meta-R> "revert_file %W $f"
	bind Text <Meta-S> "save_file_prompt %W $f"
	bind Text <Meta-Control-i> "insert_file %W $f"
	bind Text <Meta-r> "read_file %W $f"
	bind Text <Meta-s> "save_file %W $f"
	bind Text <Meta-Control-v> "visit_file $f"
	bind . <Any-Enter> "check_mtime"
}

filebind $frame

# Create file path label
catch {destroy $frame.fpl}
label $frame.fpl -relief flat -anchor e
label_expand_bind $frame.fpl fsBox(path)

# Create file name label
catch {destroy $frame.fnl}
label $frame.fnl -relief flat
label_expand_bind $frame.fnl fsBox(name)

pack append $frame $frame.fpl {left} $frame.fnl {left}

# Ensure we're not editing file another beth interp is editing.
if {([info exists path])} {
	after 5000 "check_for_duplicate_interps $text $frame $path"}
