'\"
'\" Copyright (c) 1993 The Regents of the University of California.
'\" Copyright (c) 1994-1996 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" SCCS: @(#) file.n 1.13 96/04/11 17:03:13
'\" 
.so man.macros
.TH file n 7.5 Tcl "Tcl Built-In Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
file \- Manipulate file names and attributes
.SH SYNOPSIS
\fBfile \fIoption\fR \fIname\fR ?\fIarg arg ...\fR?
.BE

.SH DESCRIPTION
.PP
.VS
This command provides several operations on a file's name or attributes.
\fIName\fR is the name of a file;
if it starts with a tilde, then tilde substitution is done before
executing the command (see the manual entry for \fBfilename\fR 
for details).
.VE
\fIOption\fR indicates what to do with the file name.  Any unique
abbreviation for \fIoption\fR is acceptable.  The valid options are:
.TP
\fBfile atime \fIname\fR
Returns a decimal string giving the time at which file \fIname\fR
was last accessed.  The time is measured in the standard POSIX
fashion as seconds from a fixed starting time (often January 1, 1970).
If the file doesn't exist or its access time cannot be queried then an
error is generated.
.TP
\fBfile dirname \fIname\fR
.VS
Returns a name comprised of all of the path components in \fIname\fR
excluding the last element.  If \fIname\fR is a relative file name and
only contains one path element, then returns ``\fB.\fR'' (or ``\fB:\fR''
on the Macintosh).  If \fIname\fR refers to a root directory, then the
root directory is returned.  For example,
.RS
.CS
\fBfile dirname c:/\fR
.CE
returns \fBc:/\fR. 
.PP
Note that tilde substitution will only be
performed if it is necessary to complete the command.  For example,
.CS
\fBfile dirname ~/src/foo.c\fR
.CE
returns \fB~/src\fR, whereas
.CS
\fBfile dirname ~\fR
.CE
returns \fB/home\fR (or something similar).
.RE
.VE
.TP
\fBfile executable \fIname\fR
Returns \fB1\fR if file \fIname\fR is executable by
the current user, \fB0\fR otherwise.
Under UNIX this command uses the real user and group identifiers,
not the effective ones.
.TP
\fBfile exists \fIname\fR
Returns \fB1\fR if file \fIname\fR exists and the current user has
search privileges for the directories leading to it, \fB0\fR otherwise.
.TP
\fBfile extension \fIname\fR
Returns all of the characters in \fIname\fR after and including the
last dot in the last element of \fIname\fR.  If there is no dot in
the last element of \fIname\fR then returns
the empty string.
.TP
\fBfile isdirectory \fIname\fR
Returns \fB1\fR if file \fIname\fR is a directory,
\fB0\fR otherwise.
.TP
\fBfile isfile \fIname\fR
Returns \fB1\fR if file \fIname\fR is a regular file,
\fB0\fR otherwise.
.VS br
.TP
\fBfile join \fIname\fR ?\fIname ...\fR?
Takes one or more file names and combines them, using the correct
path separator for the current platform.  If a particular \fIname\fR is
relative, then it will be joined to the previous file name argument.
Otherwise, any earlier arguments will be discarded, and joining will
proceed from the current argument.  For example,
.RS
.CS
\fBfile join a b /foo bar\fR
.CE
returns \fB/foo/bar\fR.
.PP
Note that any of the names can contain separators, and that the result
is always canonical for the current platform: \fB/\fR for Unix and
Windows, and \fB:\fR for Macintosh.
.RE
.VE
.TP
\fBfile lstat \fIname varName\fR
Same as \fBstat\fR option (see below) except uses the \fIlstat\fR
kernel call instead of \fIstat\fR.  This means that if \fIname\fR
refers to a symbolic link the information returned in \fIvarName\fR
is for the link rather than the file it refers to.  On systems that
don't support symbolic links this option behaves exactly the same
as the \fBstat\fR option.
.TP
\fBfile mtime \fIname\fR
Returns a decimal string giving the time at which file \fIname\fR
was last modified.  The time is measured in the standard POSIX
fashion as seconds from a fixed starting time (often January 1, 1970).
If the file doesn't exist or its modified time cannot be queried then an
error is generated.
.TP
\fBfile owned \fIname\fR
Returns \fB1\fR if file \fIname\fR is owned by the current user,
\fB0\fR otherwise.
.VS br
.TP
\fBfile pathtype \fIname\fR
Returns one of \fBabsolute\fR, \fBrelative\fR, \fBvolumerelative\fR.  If
\fIname\fR refers to a specific file on a specific volume, the path type
will be \fBabsolute\fR.  If \fIname\fR refers to a file relative to the
current working directory, then the path type will be \fBrelative\fR.  If
\fIname\fR refers to a file relative to the current working directory on
a specified volume, or to a specific file on the current working volume, then
the file type is \fBvolumerelative\fR.
.VE
.TP
\fBfile readable \fIname\fR
Returns \fB1\fR if file \fIname\fR is readable by
the current user, \fB0\fR otherwise.
Under UNIX this command uses the real user and group identifiers,
not the effective ones.
.TP
\fBfile readlink \fIname\fR
Returns the value of the symbolic link given by \fIname\fR (i.e. the
name of the file it points to).  If
\fIname\fR isn't a symbolic link or its value cannot be read, then
an error is returned.  On systems that don't support symbolic links
this option is undefined.
.TP
\fBfile rootname \fIname\fR
Returns all of the characters in \fIname\fR up to but not including
the last ``.'' character in the last component of name.  If the last
component of \fIname\fR doesn't contain a dot, then returns \fIname\fR.
.TP
\fBfile size \fIname\fR
Returns a decimal string giving the size of file \fIname\fR in bytes.
If the file doesn't exist or its size cannot be queried then an
error is generated.
.VS br
.TP
\fBfile split \fIname\fR
Returns a list whose elements are the path components in \fIname\fR.  The
first element of the list will have the same path type as \fIname\fR.
All other elements will be relative.  Path separators will be discarded
unless they are needed ensure that an element is unambiguously relative.  
For example, under Unix
.RS
.CS
\fBfile split /foo/~bar/baz\fR
.CE
returns \fB/\0\0foo\0\0./~bar\0\0baz\fR to ensure that later commands
that use the third component do not attempt to perform tilde
substitution.
.RE
.VE
.TP
\fBfile stat  \fIname varName\fR
Invokes the \fBstat\fR kernel call on \fIname\fR, and uses the
variable given by \fIvarName\fR to hold information returned from
the kernel call.
\fIVarName\fR is treated as an array variable,
and the following elements of that variable are set: \fBatime\fR,
\fBctime\fR, \fBdev\fR, \fBgid\fR, \fBino\fR, \fBmode\fR, \fBmtime\fR,
\fBnlink\fR, \fBsize\fR, \fBtype\fR, \fBuid\fR.
Each element except \fBtype\fR is a decimal string with the value of
the corresponding field from the \fBstat\fR return structure; see the
manual entry for \fBstat\fR for details on the meanings of the values.
The \fBtype\fR element gives the type of the file in the same form
returned by the command \fBfile type\fR.
This command returns an empty string.
.TP
\fBfile tail \fIname\fR
.VS
Returns all of the characters in \fIname\fR after the last directory
separator.  If \fIname\fR contains no separators then returns
\fIname\fR.
.VE
.TP
\fBfile type \fIname\fR
Returns a string giving the type of file \fIname\fR, which will be
one of \fBfile\fR, \fBdirectory\fR, \fBcharacterSpecial\fR,
\fBblockSpecial\fR, \fBfifo\fR, \fBlink\fR, or \fBsocket\fR.
.TP
\fBfile writable \fIname\fR
Returns \fB1\fR if file \fIname\fR is writable by
the current user, \fB0\fR otherwise.
Under UNIX this command uses the real user and group identifiers,
not the effective ones.

.VS
.SH "SEE ALSO"
filename
.VE

.SH KEYWORDS
attributes, directory, file, name, stat
