'\"
'\" Generated from units.xml
'\"
'\" BEGIN man.macros
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.de DS
.RS
.nf
.sp
..
.de DE
.fi
.RE
.sp
..
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
.if t .ft C
..
.de CE
.fi
.if t .ft R
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
'\" END man.macros
.TH units n "1.1" units n
.BS
.SH NAME
units \- Convert and manipulate quantities with units
.SH SYNOPSIS
.nf

package require units ?1.0?
units::convert \fIvalue\fR \fItargetUnits\fR
units::reduce \fIunitString\fR
units::new \fIname\fR \fIbaseUnits\fR

.fi
.BE
.SH DESCRIPTION
.PP
This library provides a conversion facility from a variety of
scientific and engineering shorthand notations into floating point
numbers.  This allows application developers to easily convert
values with different units into uniformly scaled numbers.
.PP
The units conversion facility is also able to convert between
compatible units.  If, for example, a application is expecting a value
in \fBohms\fR (Resistance), and the user specifies units of
\&\fBmilliwebers/femtocoulomb\fR, the conversion routine will
handle it appropriately.  An error will be generated if an incorrect
conversion is attempted.
.PP
Values are scaled from one set of units to another by dimensional
analysis.  Both the value units and the target units are reduced into
primitive units and a scale factor.  Units are checked for
compatibility, and the scale factors are applied by multiplication and
division.  This technique is extremely flexible and quite robust.
.PP
New units and new unit abbreviations can be defined in terms of
existing units and abbreviations.  It is also possible to define a new
primitive unit, although that will probably be unnecessary.  New units
will most commonly be defined to accommodate non-SI measurement
systems, such as defining the unit \fBinch\fR as \fB"2.54
cm"\fR.
.SH COMMANDS
.TP
\&\fBunits::convert \fIvalue\fB \fItargetUnits\fB
\&\fR
Converts the value string into a floating point number, scaled to the
specified \fItargetUnits\fR.  The \fIvalue\fR string may contain a
number and units.  If units are specified, then they must be
compatible with the \fItargetUnits\fR.  If units are not specified
for the \fIvalue\fR, then it will be scaled to the target units.  For
example, scaling \fB"1.0"\fR to \fB"millimeter"\fR would
result in \fB"1000.0"\fR.
.TP
\&\fBunits::reduce \fIunitString\fB
\&\fR
Returns a unit string consisting of a scale factor followed by a space
separated list of sorted and reduced primitive units.  The reduced
unit string may include a forward-slash (separated from the
surrounding primitive subunits by spaces) indicating that the
remaining subunits are in the denominator.  Generates an error if the
\&\fIunitString\fR is invalid.
.TP
\&\fBunits::new \fIname\fB \fIbaseUnits\fB
\&\fR
Creates a new unit conversion with the specified name.  The new unit
\&\fIname\fR must be only alphabetic (upper or lower case) letters.
The \fIbaseUnits\fR string can consist of any valid units conversion
string, including constant factors, numerator and denominator parts,
units with prefixes, and exponents.  The baseUnits may contain any
number of subunits, but it must reduce to primitive units.  BaseUnits
could also be the string \fB"-primitive"\fR to represent a new
kind of quantity which cannot be derived from other units.  But you
probably would not do that unless you have discovered some kind of new
univeral property.
.SH "Unit String Format"
.PP
Value and unit string format is quite flexible.  It is possible to
define virtually any combination of units, prefixes, and powers.
Valid unit strings must conform to these rules.
.IP "\(bu"
A unit string consists of an optional scale factor followed by zero or
more subunits.  The scale factor must be a valid floating point
number, and may or may not be separated from the subunits.  The scale
factor could be negative.
.IP "\(bu"
Subunits are separated form each other by one or more separator
characters, which are space (" "), hyphen ("-"), asterisk ("*"), and
forward-slash ("/").  Sure, go ahead and complain about using a minus
sign ("-") to represent multiplication.  It just isn't sound
mathematics, and, by rights, we should require everyone to use the
asterisk ("*") to separate all units.  But the bottom line is that
complex unit strings like \fB"m-kg/s^2"\fR are pleasantly
readable.
.IP "\(bu"
The forward-slash seperator ("/") indicates that following subunits are
in the denominator.  There can be at most one forward-slash separator.
.IP "\(bu"
Subunits can be floating point scale factors, but with the exception
of the leading scale factor, they must be surrounded by valid
separators.  Subunit scale factors cannot be negative. (Remember that
the hyphen is a unit separator.)
.IP "\(bu"
Subunits can be valid units or abbreviations.  They may include a
prefix.  They may include a plural suffix "s" or "es".  They may also
include a power string denoted by a circumflex ("^"), followed by a
integer, after the unit name (or plural suffix, if there is one).
Negative exponents are not allowed.  (Remember that the hyphen is a
unit separator.)
.SS " Example valid unit strings "


.CS

Unit String              Reduced Unit String
------------------------------------------------------------
meter                    1.0 meter
kilometer                1000.0 meter
km                       1000.0 meter
km/s                     1000.0 meter / second
/microsecond             1000000.0 / second
/us                      1000000.0 / second
kg-m/s^2                 1000.0 gram meter / second second
30second                 30.0 second
30 second                30.0 second
30 seconds               30.0 second
200*meter/20.5*second    9.75609756098 meter / second

.CE
.SH "SI UNITS"
.PP
The standard SI units are predefined according to \fINIST Special
Publication 330\fR.  Standard units for both SI Base Units (Table
1) and SI Derived Units with Special Names (Tables 3a and 3b) are
included here for reference.  Each standard unit name and abbreviation
are included in this package.
.SS "SI Base Units"


.CS

Quantity                Unit Name    Abbr.
---------------------------------------------
Length                  meter        m
Mass                    kilogram     kg
Time                    second       s
Current                 ampere       A
Temperature             kelvin       K
Amount                  mole         mol
Luminous Intensity      candela      cd

.CE
.SS "SI Derived Units with Special Names"


.CS

Quantity                Unit Name    Abbr.   Units     Base Units
--------------------------------------------------------------------
plane angle             radian      rad     m/m       m/m
solid angle             steradian   sr      m^2/m^2   m^2/m^2
frequency               hertz       Hz                /s
force                   newton      N                 m-kg/s^2
pressure                pascal      Pa      N/m^2     kg/m-s^2
energy, work            joule       J       N-m       m^2-kg/s^2
power, radiant flux     watt        W       J/s       m^2-kg/s^3
electric charge         coulomb     C                 s-A
electric potential      volt        V       W/A       m^2-kg/s^3-A
capacitance             farad       F       C/V       s^4-A^2/m^2-kg
electric resistance     ohm                 V/A       m^2-kg/s^3-A^2
electric conductance    siemens     S       A/V       s^3-A^2/m^2-kg
magnetic flux           weber       Wb      V-s       m^2-kg/s^2-A
magnetic flux density   tesla       T       Wb/m^2    kg/s^2-A
inductance              henry       H       Wb/A      m^2-kg/s^2-A^2
luminous flux           lumen       lm                cd-sr
illuminance             lux         lx      lm/m^2    cd-sr/m^2
activity (of a
radionuclide)           becquerel   Bq                /s
absorbed dose           gray        Gy      J/kg      m^2/s^2
dose equivalent         sievert     Sv      J/kg      m^2/s^2

.CE
.PP
Note that the SI unit kilograms is actually implemented as grams
because 1e-6 kilogram = 1 milligram, not 1 microkilogram.  The
abbreviation for Electric Resistance (ohms), which is the omega
character, is not supported.  Also note that there is no support for
Celsius temperature.  The units conversion routines can only scale
values with multiplication and division, and the abbreviation "C"
(which is the closest one could get to "degrees C" using the degrees
symbol) is already used by Electric Potential.
.PP
SI Units can have a multiple or sub-multiple prefix.  The prefix or its
abbreviation should appear before the unit, without spaces.  Compound
prefixes are not allowed, and a prefix should never be used alone.
These prefixes are defined in Table 5 of \fISpecial Publication
330\fR.
.SS "SI Prefixes"


.CS

Prefix Name     Abbr.   Factor
---------------------------------------
yotta           Y       1e24
zetta           Z       1e21
exa             E       1e18
peta            P       1e15
tera            T       1e12
giga            G       1e9
mega            M       1e6
kilo            k       1e3
hecto           h       1e2
deka            da      1e1
deca                    1e1

deci            d       1e-1
centi           c       1e-2
milli           m       1e-3
micro           u       1e-6
nano            n       1e-9
pico            p       1e-12
femto           f       1e-15
atto            a       1e-18
zepto           z       1e-21
yocto           y       1e-24

.CE
.PP
Note that we define the same prefix with both the USA ("deka") and
non-USA ("deca") spellings.  Also note that we take the liberty of
allowing "micro" to be typed as a "u" instead of the Greek character
mu.
.PP
Many non-SI units are commonly used in applications.  Appendix B.8 of
\&\fINIST Special Publication 811\fR lists many non-SI conversion
factors.  It is not possible to include all possible unit definitions
in this package.  In some cases, many different conversion factors
exist for a given unit, depending on the context. (The appendix lists
over 40 conversions for British thermal units!)  Application specific
conversions can always be added using the \fBnew\fR
command, but some well known and often used conversions are included
in this package.
.SS "Non-SI Units"


.CS

Unit Name            Abbr.    Base Units
--------------------------------------------------
angstrom                      1.0E-10 m
astronomicalUnit     AU       1.495979E11 m
atmosphere                    1.01325E5 Pa
bar                           1.0E5 Pa
calorie                       4.1868 J
curie                         3.7E10 Bq
day                           8.64E4 s
degree                        1.745329E-2 rad
erg                           1.0E-7 J
faraday                       9.648531 C
fermi                         1.0E-15 m
foot                 ft       3.048E-1 m
gauss                         1.0E-4 T
gilbert                       7.957747E-1 A
grain                gr       6.479891E-5 kg
hectare              ha       1.0E4 m^2
hour                 h        3.6E3 s
inch                 in       2.54E-2 m
lightYear                     9.46073E15 m
liter                L        1.0E-3 m^3
maxwell              Mx       1.0E-8 Wb
mho                           1.0 S
micron                        1.0E-6 m
mil                           2.54E-5 m
mile                 mi       1.609344E3 m
minute               min      6.0E1 s
parsec               pc       3.085E16 m
pica                          4.233333E-3 m
pound                lb       4.535924E-1 kg
revolution                    6.283185 rad
revolutionPerMinute  rpm      1.047198E-1 rad/s
yard                 yd       9.144E-1 m
year                          3.1536E7 s

.CE
.SS "Quantities and Derived Units with Special Names"
.PP
This units conversion package is limited specifically to unit
reduction, comparison, and scaling.  This package does not consider
any of the quantity names for either base or derived units.  A similar
implementation or an extension in a typed or object-oriented language
might introduce user defined types for the quantities.  Quantity type
checking could be used, for example, to ensure that all
\&\fB"length"\fR values properly reduced to \fB"meters"\fR, or
that all \fB"velocity"\fR values properly reduced to
\&\fB"meters/second"\fR.
.PP
A C implementation of this package has been created to work in
conjunction with the Simplified Wrapper Interface Generator
(http://www.swig.org).  That package (units.i) exploits SWIG's typemap
system to automatically convert script quantity strings into floating
point quantities.  Function arguments are specified as quantity types
(e.g., \fBtypedef float Length\fR), and target units (expected
by the C application code) are specified in an associative array.
Default units are also defined for each quantity type, and are applied
to any unit-less quantity strings.
.PP
A units system enhanced with quantity type checking might benefit from
inclusion of other derived types which are expressed in terms of
special units, as illustrated in Table 2 of \fINIST Publication
330\fR.  The quantity \fB"area"\fR, for example, could be
defined as units properly reducing to \fB"meter^2"\fR, although
the utility of defining a unit named \fB"square meter"\fR is
arguable.
.SH REFERENCES
.PP
The unit names, abbreviations, and conversion values are derived from
those published by the United States Department of Commerce Technology
Administration, National Institute of Standards and Technology (NIST)
in \fINIST Special Publication 330: The International System of
Units (SI)\fR and \fINIST Special Publication 811: Guide for
the Use of the International System of Units (SI)\fR.  Both of
these publications are available (as of December 2000) from
http://physics.nist.gov/cuu/Reference/contents.html
.PP
The ideas behind implementation of this package is based in part on
code written in 1993 by Adrian Mariano which performed dimensional
analysis of unit strings using fixed size tables of C structs.
.SH KEYWORDS
unit, convert
