/*
 * Windows-specific Tk interface to TkGS
 */

#include <tk.h>
#include <tkgs.h>

/* Include Win32 driver as static package */
#include <drivers/win32/tkgsWin.h>

#include <tkWinInt.h>


TkGS_Device Win32Driver;


TkGS_Drawable
TkGS_GetWindowDrawable(tkwin)
    Tk_Window	tkwin;
{
    TkGS_Drawable d;
    WinDrawableCreateData cd;

    cd.hwnd = TkWinGetHWND(Tk_WindowId(tkwin));

    d = TkGS_GetDrawable(Win32Driver, (ClientData) &cd);
    return d;
}

void
TkGSpGetSystemColorRGBValues(systemColor, redPtr, greenPtr, bluePtr)
    int		   systemColor;
    unsigned short *redPtr;
    unsigned short *greenPtr;
    unsigned short *bluePtr;
{
    COLORREF rgb = GetSysColor(systemColor);

    /* 
     * Remark: the right way to map 8bit to 16bit color values isn't to
     * multiply by 256, but 257. The former fills the upper bits with the 
     * original value and leaves the lower bits to zero. Since 257 = 256+1,
     * the latter fills the lower bits to the original 8bit value, such that
     * zero maps to zero and 255 maps to 65535. Thus perfect 8bit black and
     * white colors will map to perfect 16bit colors.
     */

    *redPtr   = GetRValue(rgb)*257;
    *greenPtr = GetGValue(rgb)*257;
    *bluePtr  = GetBValue(rgb)*257;
}


int
TkGSpInit(interp)
    Tcl_Interp *interp;
{
    /* Load Win32 driver as static package */
    WinTkGS_StaticPackage(NULL);

    /* FIXME: better way to do this? */
    if (Tcl_Eval(interp, "load {} WinTkGS") == TCL_ERROR) {
	return TKGS_ERROR;
    }

    Win32Driver = TkGS_GetDevice("Win32");

    return TKGS_OK;
}

