#ifndef _TKGSDRIVER
#define _TKGSDRIVER

#include <tcl.h>

/*
 *--------------------------------------------------------------
 *
 * Device drivers
 *
 *--------------------------------------------------------------
 */

/* Update proc */

typedef int (TkGSUpdateDrawableStateProc) _ANSI_ARGS_((TkGS_Drawable d, 
	unsigned long valueMask));

/* Line & shape primitives */

typedef TkGS_Drawable (TkGS_GetDrawableProc) _ANSI_ARGS_((
	ClientData clientData));
typedef void (TkGS_DrawRectangleProc) _ANSI_ARGS_((TkGS_Drawable d, int filled,
	int x, int y, unsigned int width, unsigned int height));
typedef void (TkGS_DrawRectanglesProc) _ANSI_ARGS_((TkGS_Drawable d, int filled,
	TkGS_Rectangle* rectangles, int nbRectangles));
typedef void (TkGS_FillRectangleProc) _ANSI_ARGS_((TkGS_Drawable d,
	TkGS_Color color, int x, int y, unsigned int width,
	unsigned int height));
typedef void (TkGS_FillRectanglesProc) _ANSI_ARGS_((TkGS_Drawable d,
	TkGS_Color color, TkGS_Rectangle* rectangles, int nbRectangles));
typedef void (TkGS_DrawEllipseProc) _ANSI_ARGS_((TkGS_Drawable d, int filled,
	int x, int y, unsigned int width, unsigned int height));
typedef void (TkGS_DrawEllipsesProc) _ANSI_ARGS_((TkGS_Drawable d, int filled,
	TkGS_Rectangle* ellipses, int nbEllipses));

/* Fonts & text primitives */

typedef void (TkGS_GetFontMetricsProc) _ANSI_ARGS_((TkGS_Drawable d,
	TkGS_Font font, TkGS_FontMetrics *fmPtr));
typedef void (TkGS_GetActualFontAttributesProc) _ANSI_ARGS_((TkGS_Drawable d,
	TkGS_Font font, TkGS_FontAttributes *faPtr));
typedef int (TkGS_FontFamiliesEnumProc) _ANSI_ARGS_((TkGS_Drawable d,
	ClientData clientData, CONST TkGS_StringUtf name));
typedef void (TkGS_EnumerateFontFamiliesProc) _ANSI_ARGS_((TkGS_Drawable d, 
	CONST TkGS_StringUtf name, TkGS_FontFamiliesEnumProc *enumProc, 
	ClientData clientData));
typedef int (TkGS_FontFamilyExistsProc) _ANSI_ARGS_((TkGS_Drawable d, 
	CONST TkGS_StringUtf name));

/*  - Unicode version */

typedef int (TkGS_MeasureCharsUniProc) _ANSI_ARGS_((TkGS_Drawable d,
	CONST TkGS_StringUni string, int length, int maxPixels, 
	int flags, int *lengthPtr));
typedef int (TkGS_TextWidthUniProc) _ANSI_ARGS_((TkGS_Drawable d,
	CONST TkGS_StringUni string, int length));
typedef void (TkGS_DrawCharsUniProc) _ANSI_ARGS_((TkGS_Drawable d,
	CONST TkGS_StringUni string, int length, int x, int y, 
	int *widthPtr));
typedef void (TkGS_UnderlineCharsUniProc) _ANSI_ARGS_((TkGS_Drawable d,
	CONST TkGS_StringUni string, int length, int x, int y, int first, 
	int last));

/*  - UTF-8 version */

typedef int (TkGS_MeasureCharsUtfProc) _ANSI_ARGS_((TkGS_Drawable d,
	CONST TkGS_StringUtf string, int length, int maxPixels, 
	int flags, int *lengthPtr));
typedef int (TkGS_TextWidthUtfProc) _ANSI_ARGS_((TkGS_Drawable d,
	CONST TkGS_StringUtf string, int length));
typedef void (TkGS_DrawCharsUtfProc) _ANSI_ARGS_((TkGS_Drawable d,
	CONST TkGS_StringUtf string, int length, int x, int y, 
	int *widthPtr));
typedef void (TkGS_UnderlineCharsUtfProc) _ANSI_ARGS_((TkGS_Drawable d,
	CONST TkGS_StringUtf string, int length, int x, int y, int first, 
	int last));

/* - System-specific version */

typedef int (TkGS_MeasureCharsSysProc) _ANSI_ARGS_((TkGS_Drawable d,
	CONST TkGS_StringSys string, int length, int maxPixels, 
	int flags, int *lengthPtr));
typedef int (TkGS_TextWidthSysProc) _ANSI_ARGS_((TkGS_Drawable d,
	CONST TkGS_StringSys string, int length));
typedef void (TkGS_DrawCharsSysProc) _ANSI_ARGS_((TkGS_Drawable d,
	CONST TkGS_StringSys string, int length, int x, int y, 
	int *widthPtr));
typedef void (TkGS_UnderlineCharsSysProc) _ANSI_ARGS_((TkGS_Drawable d,
	CONST TkGS_StringSys string, int length, int x, int y, int first, 
	int last));

/*  - Internal multi-font Unicode system */

typedef TkGSSubFont (TkGSGetSubFontProc) _ANSI_ARGS_((TkGS_Drawable d, 
	TkGSMultiFont multiFont, TkGSSubFontId subFontId));
typedef void (TkGSSetDrawableSubFontProc) _ANSI_ARGS_((TkGS_Drawable d,
	TkGSSubFontId subFontId));
typedef void (TkGSFontMapLoadPageProc) _ANSI_ARGS_((TkGS_Drawable d,
	TkGSSubFont subFont, int row));
typedef TkGSSubFontId (TkGSCanUseFontProc) _ANSI_ARGS_((TkGS_Drawable d, 
	TkGS_Font font, TkGSMultiFont multiFont, TkGS_UniChar ch));
typedef TkGSSubFontId (TkGSCanUseFallbackProc) _ANSI_ARGS_((TkGS_Drawable d, 
	TkGS_Font font, TkGSMultiFont multiFont, CONST char *faceName, 
	TkGS_UniChar ch));
typedef TkGSSubFontId (TkGSDefaultSubFontProc) _ANSI_ARGS_((TkGS_Drawable d, 
	TkGS_Font font, TkGSMultiFont multiFont));

/* 
 * The following structure is a device driver descriptor. It contains a
 * function table corresponding to each standard TkGS calls.
 */

typedef struct TkGS_DeviceDriver {
    char *name;		/* Name of device driver */

    TkGS_GetDrawableProc *getDrawable;

    TkGSUpdateDrawableStateProc *updateDrawableState;

    /* Line & shape primitives */
    TkGS_DrawRectangleProc  *drawRectangle;
    TkGS_DrawRectanglesProc *drawRectangles;
    TkGS_FillRectangleProc  *fillRectangle;
    TkGS_FillRectanglesProc *fillRectangles;
    TkGS_DrawEllipseProc    *drawEllipse;
    TkGS_DrawEllipsesProc   *drawEllipses;

    /* Fonts and text primitives: */
    TkGS_GetFontMetricsProc          *getFontMetrics;
    TkGS_GetActualFontAttributesProc *getActualFontAttributes;
    TkGS_EnumerateFontFamiliesProc   *enumerateFontFamilies;
    TkGS_FontFamilyExistsProc        *fontFamilyExists;

    /*  - Unicode */
    TkGS_MeasureCharsUniProc	      *measureCharsUni;
    TkGS_TextWidthUniProc	      *textWidthUni;
    TkGS_DrawCharsUniProc	      *drawCharsUni;
    TkGS_UnderlineCharsUniProc	      *underlineCharsUni;

    /*  - UTF-8 */
    TkGS_MeasureCharsUtfProc	      *measureCharsUtf;
    TkGS_TextWidthUtfProc	      *textWidthUtf;
    TkGS_DrawCharsUtfProc	      *drawCharsUtf;
    TkGS_UnderlineCharsUtfProc	      *underlineCharsUtf;

    /*  - System-specific */
    TkGS_MeasureCharsSysProc	      *measureCharsSys;
    TkGS_TextWidthSysProc	      *textWidthSys;
    TkGS_DrawCharsSysProc	      *drawCharsSys;
    TkGS_UnderlineCharsSysProc	      *underlineCharsSys;

    /*  - Multi-font Unicode system */
    int isUnicodeMultiFont;
    int tryHomonymousFonts;
    TkGSGetSubFontProc         *getSubFont;
    TkGSSetDrawableSubFontProc *setDrawableSubFont;
    TkGSFontMapLoadPageProc    *fontMapLoadPage;
    TkGSCanUseFontProc         *canUseFont;
    TkGSCanUseFallbackProc     *canUseFallback;
    TkGSDefaultSubFontProc     *defaultSubFont;
    TkGS_MeasureCharsUniProc   *subFontMeasureCharsUni;
    TkGS_TextWidthUniProc      *subFontTextWidthUni;
    TkGS_DrawCharsUniProc      *subFontDrawCharsUni;
    TkGS_MeasureCharsUtfProc   *subFontMeasureCharsUtf;
    TkGS_TextWidthUtfProc      *subFontTextWidthUtf;
    TkGS_DrawCharsUtfProc      *subFontDrawCharsUtf;

} TkGS_DeviceDriver;


/*
 * Driver related procs
 */

EXTERN void		TkGS_RegisterDeviceDriver _ANSI_ARGS_((
			    TkGS_DeviceDriver *deviceDriverPtr));


/*
 * Macro for device procedure access
 */

#define TKGS_GETDEVICEMEMBER(d, member) \
    ((TkGS_DeviceDriver *)TkGSDrawable_Device(d))->member


#define TkGSUpdateDrawableState(d, mask) \
    TKGS_GETDEVICEMEMBER(d, updateDrawableState)(d, mask)



#endif /* _TKGSDRIVER */

