#include "tkgs.h"
#include "tkgsInt.h"


/*
 * Color Obj type
 */

static TkGS_DupBaseProc DupColor;

TkGS_BaseType TkGSColorBaseType = {
    "Color",
    sizeof(TkGS_Color_),
    1,				/* nbIntRep */

    NULL,			/* freeBaseProc */
				/* NULL means no freeing needed */
    DupColor			/* dupBaseProc */
};

TkGS_BaseType *
TkGS_GetColorBaseType()
{
    return &TkGSColorBaseType;
}

static void
DupColor(srcPtr, dupPtr)
    TkGS_Obj *srcPtr;
    TkGS_Obj *dupPtr;
{
    int type = TkGSColor_Type(srcPtr);

    TkGSColor_Type(dupPtr) = type;
    switch (type) {
	case TKGS_COLOR_SYSTEM:
	    TkGSColor_SystemColor(dupPtr) = TkGSColor_SystemColor(srcPtr);
	    break;

	case TKGS_COLOR_RGB: {
	    unsigned short *srcRgb = TkGSColor_RGB(srcPtr),
			   *dupRgb = TkGSColor_RGB(dupPtr);

	    dupRgb[0] = srcRgb[0];
	    dupRgb[1] = srcRgb[1];
	    dupRgb[2] = srcRgb[2];
	    break;
	}
    }
}




TkGS_Color_ *
TkGSNewSystemColor(systemColor)
    int systemColor;
{
    register TkGS_Color_ *colorPtr = (TkGS_Color_*) TkGSNewObj(&TkGSColorBaseType);

    TkGSColor_Type(colorPtr) = TKGS_COLOR_SYSTEM;
    TkGSColor_SystemColor(colorPtr) = systemColor;

    return colorPtr;
}

TkGS_Color_ *
TkGSNewRGBColor(red, green, blue)
    unsigned short red, green, blue;
{
    register TkGS_Color_ *colorPtr = (TkGS_Color_*) TkGSNewObj(&TkGSColorBaseType);
    register unsigned short *rgb = TkGSColor_RGB(colorPtr);

    TkGSColor_Type(colorPtr) = TKGS_COLOR_RGB;

    rgb[0] = red;
    rgb[1] = green;
    rgb[2] = blue;

    return colorPtr;
}


