#ifndef _TKGSWINFONT
#define _TKGSWINFONT

/*
 * Win32 Fonts
 */

/* Constants */
#define WIN_BASE_CHARS		128

/* Object type */
EXTERN TkGS_ObjType *WinFontTypePtr;

/* Structures */

typedef struct WinFontFamily {
    TkGSFontFamily_ header;	/* Must be first */

    Tcl_HashEntry *hashPtr;	/* Pointer to hash table entry that
				 * corresponds to the font family. */

    int isSymbolFont;		/* Non-zero if this is a symbol font. */
    int isWideFont;		/* 1 if this is a double-byte font, 0 
				 * otherwise. */

    /*
     * Cached Truetype font info.
     */
     
    int segCount;		/* The length of the following arrays. */
    USHORT *startCount;		/* Truetype information about the font, */
    USHORT *endCount;		/* indicating which characters this font
				 * can display (malloced).  The format of
				 * this information is (relatively) compact,
				 * but would take longer to search than 
				 * indexing into the fontMap[][] table. */
} WinFontFamily;

typedef struct WinSubFont {
    TkGSSubFont_ header;	/* Must be first */

    HFONT hFont;		/* The specific screen font that will be
				 * used when displaying/measuring chars
				 * belonging to the WinFontFamily. */
} WinSubFont;

typedef struct WinFont {
    TkGSMultiFont_ header;	/* Must be first */

    TkGS_FontAttributes	fa;	/* Real font attributes (actually, 
				 * for the base font). */
    TkGS_FontMetrics fm;	/* Real font metrics, ditto. */
    /* TODO: widths lazily computed? */
    int widths[WIN_BASE_CHARS];	/* Widths of first 128 chars in the base
				 * font, for handling common case. */
    HFONT hFont;		/* HFONT for base font. */
} WinFont;

/* Subfont-related macros */

#define WinTkGSGetSubFontId(index) \
    ((TkGSSubFontId) (index)+1)
#define WinTkGSGetSubFontIndex(subFontId) \
    ((int) (subFontId)-1)
#define WinTkGSGetSubFontFromIndex(multiFont, index) \
    (&((WinSubFont *) ((WinFont *) (multiFont))->header.subFontArray)[(index)])
#define WinTkGSGetSubFontFromId(multiFont, subFontId) \
    (WinTkGSGetSubFontFromIndex((multiFont), WinTkGSGetSubFontIndex((subFontId))))

/* Accessors */
#define WinFont_InternalRep(intRepPtr) \
    ((WinFont *) intRepPtr->value.otherValuePtr)

#define WinFont_MultiFont(intRepPtr) \
    (WinFont_InternalRep(intRepPtr)->header)
#define WinFont_FontMetrics(intRepPtr) \
    (WinFont_InternalRep(intRepPtr)->fm)
#define WinFont_Widths(intRepPtr) \
    (WinFont_InternalRep(intRepPtr)->widths)
#define WinFont_HFONT(intRepPtr) \
    (WinFont_InternalRep(intRepPtr)->hFont)

#define WinSubFont_HFONT(subFont) \
    (((WinSubFont *) subFont)->hFont)

#endif /* _TKGSWINFONT */

