#ifndef _TKGSWIN
#define _TKGSWIN

#include <tkgs.h>

/*
 *--------------------------------------------------------------
 *
 * Tcl package initialization
 *
 *--------------------------------------------------------------
 */


/*
 * if the BUILD_WinTkGS macro is defined, the assumption is that we are
 * building the dynamic library.
 */

#ifdef BUILD_WinTkGS
#   undef TCL_STORAGE_CLASS
#   define TCL_STORAGE_CLASS DLLEXPORT
#endif

#define EXPORT(a,b) a b

#ifdef WIN32
#   define WIN32_LEAN_AND_MEAN
#   include <windows.h>
#   undef WIN32_LEAN_AND_MEAN

#   ifndef STATIC_BUILD
#	if defined(__BORLANDC__)
#           undef EXPORT
#           define EXPORT(a,b) a _export b
#	endif
#   endif
#endif	/* WIN32 */

/*
 * The DLL's main entry point
 */

EXTERN EXPORT(int,Wintkgs_Init) _ANSI_ARGS_((Tcl_Interp *interp));
EXTERN EXPORT(int,Wintkgs_SafeInit) _ANSI_ARGS_((Tcl_Interp *interp));

void WinTkGS_StaticPackage _ANSI_ARGS_((Tcl_Interp *interp));


/*
 * Win32-dependent structures
 */

#include <windows.h>


/* Drawable initialization structure */

typedef struct WinDrawableCreateData {
    HWND hwnd;
} WinDrawableCreateData;

/* Various functions */

EXTERN HPEN		WinTkGS_GetPenFromDrawable _ANSI_ARGS_((
			    Tcl_Interp *interp, TkGS_Drawable d));
EXTERN HBRUSH		WinTkGS_GetBrushFromDrawable _ANSI_ARGS_((
			    Tcl_Interp *interp, TkGS_Drawable d));
EXTERN HPEN		WinTkGS_GetPenFromColor _ANSI_ARGS_((Tcl_Interp *interp,
			    TkGS_Color color));
EXTERN HBRUSH		WinTkGS_GetBrushFromColor _ANSI_ARGS_((
			    Tcl_Interp *interp, TkGS_Color color));
EXTERN COLORREF		WinTkGS_GetColorrefFromColor _ANSI_ARGS_((
			    TkGS_Color color));

/*
 * end of tkgsWin.h
 * reset TCL_STORAGE_CLASS to DLLIMPORT.
 */

#undef TCL_STORAGE_CLASS
#define TCL_STORAGE_CLASS DLLIMPORT

#endif /* _TKGSWIN */
