'\" -*- nroff -*-
'\" Copyright (c) 1997 Donal K. Fellows
'\"
'\" The author hereby grants permission to use, copy, modify, distribute,
'\" and license this software and its documentation for any purpose, provided
'\" that existing copyright notices are retained in all copies and that this
'\" notice is included verbatim in any distributions. No written agreement,
'\" license, or royalty fee is required for any of the authorized uses.
'\" Modifications to this software may be copyrighted by their authors
'\" and need not follow the licensing terms described here, provided that
'\" the new terms are clearly indicated on the first page of each file where
'\" they apply.
'\"
'\" IN NO EVENT SHALL THE AUTHOR OR DISTRIBUTORS BE LIABLE TO ANY PARTY
'\" FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
'\" ARISING OUT OF THE USE OF THIS SOFTWARE, ITS DOCUMENTATION, OR ANY
'\" DERIVATIVES THEREOF, EVEN IF THE AUTHOR HAS BEEN ADVISED OF THE
'\" POSSIBILITY OF SUCH DAMAGE.
'\"
'\" THE AUTHOR AND DISTRIBUTORS SPECIFICALLY DISCLAIM ANY WARRANTIES,
'\" INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY,
'\" FITNESS FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT.  THIS SOFTWARE
'\" IS PROVIDED ON AN "AS IS" BASIS, AND THE AUTHOR AND DISTRIBUTORS HAVE
'\" NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR
'\" MODIFICATIONS.
'\" 
'\" $Id: shape.n,v 1.1.1.1 2000/09/09 01:16:12 ericm Exp $
'\" 
.so man.macros
.TH shape n 0.3 Shape "Non-rectangular Window Extension"
.BS
.SH NAME
shape \- Set/update/query shaped window information
.SH SYNOPSIS
\fBpackage require shape 0.3\fR

\fBshape \fIoption window \fR?\fIarg ...\fR?
.BE

.SH DESCRIPTION
.PP
The \fBshape\fR command is used to manipulate windows so as to make
them have non-rectangular shapes.  It also permits the querying of the
current status of windows to see what shape they have.  The
\fBshape\fR can have any of several forms, depending on the
\fIoption\fR argument:
.TP
\fBshape bounds \fIwindow \fR?\fIkind\fR?
Returns the bounding box of the shape of \fIwindow\fR, or an empty
string if the window does not currently have a shape set for it
(i.e. it is rectangular.)  The \fIkind\fR option allows the selection
of which shape to retrieve the bounding box of.  The \fB-bounding\fR
option indicates that the bounding shape of the window is to be
queried (the default.)  The \fB-clip\fR option indicates that the
clipping shape of the window is to be queried.
.TP
\fBshape get \fIwindow \fR?\fIkind\fR?
Returns a list of rectangles describing the shape of \fIwindow\fR. If
\fIwindow\fR currently has no shape set for it, this command returns
the Xserver's current idea of the rectangular shape of \fIwindow\fR
which might or might not be ``sensible''.  The \fIkind\fR option
allows the selection of which shape to retrieve the shape of.  The
\fB-bounding\fR option indicates that the bounding shape of the window
is to be queried (the default.)  The \fB-clip\fR option indicates that
the clipping shape of the window is to be queried.
.TP
\fBshape offset \fIwindow \fR?\fIkind\fR? \fIxOffset yOffset\fR
Moves the shape of \fIwindow\fR by \fIxOffset\fR pixels right and
\fIyOffset\fR pixels down, relative to the overall position of
\fIwindow\fR.  The contents of \fIwindow\fR do not move.

The \fIkind\fR option allows the selection of which shape to move.
The \fB-bounding\fR option indicates that the bounding shape of
\fIwindow\fR is to be moved.  The \fB-clip\fR option indicates that
the clipping shape of \fIwindow\fR is to be moved.  The \fB-both\fR
option (the default) moves both the bounding and the clipping shapes
of \fIwindow\fR.
.TP
\fBshape set \fIwindow \fR?\fIkind\fR? ?\fI-offset xOffset yOffset\fR? \fIsourcekind \fR?\fIarg ...\fR?
Sets the shape of \fIwindow\fR to the shape specified by the source
described by \fIsourcekind ...\fR, possibly pre-offset by
(\fIxOffset\fR,\fIyOffset\fR), much as in the \fBshape offset\fR
command.  Shape sources are described in ``SHAPE SOURCES'' below.

The \fIkind\fR option allows the selection of which shape to set.  The
\fB-bounding\fR option indicates that the bounding shape of
\fIwindow\fR is to be set.  The \fB-clip\fR option indicates that the
clipping shape of \fIwindow\fR is to be set.  The \fB-both\fR option
(the default) sets both the bounding and the clipping shapes of
\fIwindow\fR.
.TP
\fBshape update \fIwindow operation \fR?\fIkind\fR? ?\fI-offset xOffset yOffset\fR? \fIsourcekind \fR?\fIarg ...\fR?
Updates the shape of \fIwindow\fR, applying a shape using set
operation \fIoperation\fR.  The shape applied is specified by the
source described by \fIsourcekind ...\fR and is possibly pre-offset by
(\fIxOffset\fR,\fIyOffset\fR), much as in the \fBshape offset\fR
command.  Shape sources are described in ``SHAPE SOURCES'' below.

The \fIkind\fR option allows the selection of which shape to set.  The
\fB-bounding\fR option indicates that the bounding shape of
\fIwindow\fR is to be set.  The \fB-clip\fR option indicates that the
clipping shape of \fIwindow\fR is to be set.  The \fB-both\fR option
(the default) sets both the bounding and the clipping shapes of
\fIwindow\fR.

The following set operations (and unique abbreviations of them) are
supported:
.RS
.TP
\fBset\fR (aliases: \fB:=\fR, \fB=\fR)
The shape specified by the source becomes the shape of \fIwindow\fR.
.TP
\fBunion\fR (aliases: \fB+=\fR, \fB||\fR)
The new shape of \fIwindow\fR consists of all areas specified in
either the old shape of \fIwindow\fR, or by the source.
.TP
\fBintersect\fR (aliases: \fB*=\fR, \fB&&\fR)
The new shape of \fIwindow\fR consists of all areas specified in both
the old shape of \fIwindow\fR, and by the source.
.TP
\fBsubtract\fR (aliases: \fB-=\fR)
The new shape of \fIwindow\fR consists of all areas specified by the
old shape of \fIwindow\fR that are not specified by the source.
.TP
\fBinvert\fR (no aliases)
The new shape of \fIwindow\fR consists of all areas specified by the
source that are not specified by the old shape of \fIwindow\fR.
.RE
.TP
\fBshape version\fR
Return the version number of the non-rectangular window extension
installed on the X server that serves the screen that \fB.\fR is on.
Note that this is \fInot\fR the version number of the Tcl/Tk
extension, which is reported in the (global) variables
\fBshape_version\fR and \fBshape_patchLevel\fR.
.SH "SHAPE SOURCES"
There are five types of shape sources:
.TP
\fBbitmap \fIbitmap\fR
This uses the outline of \fIbitmap\fR (which may be any string
acceptable to \fBTk_GetBitmap\fR) as a shape source (the same
information is supplied to operations involving bounding and clipping
shapes).
.TP
\fBrectangles \fIrectangleList\fR
This uses the union of the rectangles in \fIrectangleList\fR as a
source of shape information (the same information is supplied to
operations involving bounding and clipping shapes).  Each rectangle is
described a list of four numbers \fIx1\fR, \fIy1\fR, \fIx2\fR and
\fIy2\fR where (\fIx1\fR,\fIy1\fR) is the top-left corner of the
rectangle, and (\fIx2\fR,\fIy2\fR) is the bottom-right corner of the
rectangle.
.TP
\fBreset\fR
This resets the shape of the window the operation is being applied to
to a rectangle with the dimensions of the window (or at least, the
dimensions that the Xserver thinks that the window has.)  This
operation is only valid as part of the \fBshape set\fR command.  It
ought to mark the window as not being shaped at all, but there is no
protocol for this in version 1.0 of the X non-rectangular window
extension, making it an impossible operation.
.TP
\fBtext \fIstring font\fR
This uses an image of \fIstring\fR drawn in \fIfont\fR as a source of
shape information (the same information is supplied to operations
involving bounding and clipping shapes) where \fIfont\fR is any string
acceptable to \fBTk_GetFont\fR.  Note that only spaces are supported
as whitespace characters in \fIstring\fR, and that the effects of
using newline and tab characters is undefined.
.TP
\fBwindow \fIwindow\fR
This uses \fIwindow\fR as a source of shape information, with the
bounding shape of \fIwindow\fR being used to supply bounding
information, and the clipping shape of \fIwindow\fR being used to
supply clipping information.
.SH "KINDS OF SHAPE"
Every window has two kinds of shape; their \fBbounding\fR and their
\fBclipping\fR shapes.  The \fBbounding\fR shape of a window describes
the area covered by that window, and the \fBclipping\fR shape of a
window describes the part of the window occupied by the contents of
that window.  The area of the window contained in the bounding area of
the window but not in the clipping area of the window is (X) border of
the window.  This border is not useful under Tk (which manages all
widget borders internally,) so the default kinds that the various
operations work on are such that read-only operations work by default
on the bounding shape (via the \fB-bounding\fR option) and read-write
operations work by default on both the clip and the bounding shapes
(via the \fB-both\fR option.)  The \fB-clip\fR option is unlikely to
be useful in normal operation.

.SH CAVEATS
When setting the shape of a toplevel window, make sure that you
perform an \fBupdate idletasks\fR between the creation of the toplevel
and applying a \fBshape set\fR or \fBshape update\fR operation to it.
This is because Tk works by reparenting toplevel windows into a
(user-invisible) container, so allowing the introduction of a menubar
to windows without having to alter the internal dimensions of the
toplevel.  Because this is done on an idle handler, you must wait
until after that idle handler has executed before applying a reshape
operation to a toplevel.  Failure to do this will result in the
reshaped toplevel being apparently encased in a toplevel window that
is unresponsive to all events (like Expose events).  While no harm is
done to the application, this an undesirable effect that you probably
do not want in your application.  Sometime, I will have a go at fixing
this.

This extension can only handle applications that use a single screen,
or at least, it can only handle those that only attempt to use shaped
windows on the same screen as \fB.\fR Since this is the vast majority
of all applications, this should not prove too onerous a restriction
for the present.

Updating window shapes can be a very expensive operation, so you are
advised to avoid doing it as much as possible (do not use it as a way
of doing animation \- it does not work well.)  Of course, if you need
to change the shape, then do so, but you should try to find ways that
do it as little as possible due to it being an expensive operation.

Some other X clients can run far slower if they have to interact with
shaped windows.  The troublemakers are not always the clients that you
would expect to cause problems.
.SH "DEMO PROGRAMS"
All these programs are located in \fCshape0.3/demos\fR.
.TP
\fBdragger\fR
This creates a window that when Mouse Button 1 is depressed in, brings
up a coloured cursor that (partially) changes colour depending on
whether the cursor is over the source window or not.
.TP
\fBfancytext\fR
A fairly simple, but effective, demonstration of how to make a simple
piece of text look far more effective using moving lines clipped to
the text to suggest the letters without showing them all at once.
.TP
\fBfingerprint\fR
This puts a grubby-looking fingerprint on the screen.  The fingerprint
can be dragged about the screen (the cursor changes when it is
possible to drag the fingerprint).  Thanks to John LoVerso
\fC<loverso@opengroup.org>\fR for this little demo!
.SH TO-DO
I need fix the caveat relating to toplevels and check for and resolve
any conflicts with some of the other capabilities of toplevels
(especially the \fB-menu\fR and \fB-use\fR options).

I want to write some code to install the extension.

I would like input about using non-rectangular windows on the other
major Tk platforms.

It would be rather nice to be able to anchor cutouts to corners/edges
of a window and have them handle window resizes correctly.  Possibly
also a scaling operation could be added.

There are probably loads of other things that need doing, but I can't
think of them right now.
.SH AUTHOR
Donal K. Fellows \fC<fellowsd@cs.man.ac.uk>\fR
.SH KEYWORDS
shape, window
