# Tix Demostration Program
#
# This sample program is structured in such a way so that it can be
# executed from the Tix demo program "widget": it must have a
# procedure called "RunSample". It should also have the "if" statment
# at the end of this file so that it can be run as a standalone
# program using tixwish.

# This file demonstrates the use of the tixNoteBook widget, which allows
# you to lay out your interface using a "notebook" metaphore
#
# $Id: NoteBook.tcl,v 1.4 2001/03/03 09:06:24 ioilam Exp $

proc RunSample {w} {
    global tcl_platform
    wm title $w "Tix Demo: NoteBook"
    # Create the notebook widget.
    tixNoteBook $w.nb
    #$w.nb subwidget nbframe config -bd 1

    # Create the three tabs on the notebook. The -underline option
    # puts a underline on the first character of the labels of the tabs.
    # Keyboard accelerators will be defined automatically according
    # to the underlined character.	
    #
    $w.nb add mail -label "Mail" -underline 0
    $w.nb add news -label "News" -underline 0
    $w.nb add prox -label "Proxy" -underline 0
    pack $w.nb -expand yes -fill both -padx 5 -pady 5 -side top

    button $w.ok -text OK -width 8 -default active -command "destroy $w"
    button $w.cancel -text Cancel -width 8 -command "destroy $w"

    if {$tcl_platform(platform) == "windows"} {
        $w.ok config -pady 0
        $w.cancel config -pady 0
    }

    pack $w.cancel $w.ok -side right -padx 5 -pady 3

    #----------------------------------------
    # Create the "Mail" page
    #----------------------------------------
    set f [$w.nb subwidget mail]

    set ent1 [tixLabelEntry $f.ent1 -label "Incoming SMTP Server: "]
    set ent2 [tixLabelEntry $f.ent2 -label "Outgoing Server: "]
    set type [tixComboBox   $f.type -label "Outgoing Server Type: "]
    set ent3 [tixLabelEntry $f.ent3 -label "User Name: "]
    set ent4 [tixLabelEntry $f.ent4 -label "Password: "]

    pack $ent1 $ent2 $type $ent3 $ent4 -side top -anchor w -padx 10 -pady 10

    $ent1 subwidget label config -width 21 -underline 0 -anchor e
    $ent2 subwidget label config -width 21 -underline 0 -anchor e
    $ent3 subwidget label config -width 21 -underline 0 -anchor e
    $ent4 subwidget label config -width 21 -underline 0 -anchor e
    $type subwidget label config -width 21 -underline 0 -anchor e -bd 0

    $ent1 subwidget entry config -width 20
    $ent2 subwidget entry config -width 20
    $ent3 subwidget entry config -width 20
    $ent4 subwidget entry config -width 20 -show *
    $type subwidget entry config -width 6
    $type subwidget listbox config -width 6 -height 2

    $type subwidget listbox insert end IMAP
    $type subwidget listbox insert end POP3

    # Some default values
    $ent1 subwidget entry insert 0 imap04
    $ent2 subwidget entry insert 0 mail
    $ent3 subwidget entry insert 0 barney
    $ent4 subwidget entry insert 0 iamevil
    $type config -value IMAP

    #----------------------------------------
    # Create the "News" page
    #----------------------------------------
    set f [$w.nb subwidget news]

    set ent1 [tixLabelEntry $f.ent1 -label "News Server: "]
    set ent2 [tixLabelEntry $f.ent2 -label "Port: "]
    set ent3 [tixLabelEntry $f.ent3 -label "User Name: "]
    set ent4 [tixLabelEntry $f.ent4 -label "Password: "]

    pack $ent1 $ent2 $ent3 $ent4 -side top -anchor w -padx 10 -pady 10

    $ent1 subwidget label config -width 21 -underline 0 -anchor e
    $ent2 subwidget label config -width 21 -underline 0 -anchor e
    $ent3 subwidget label config -width 21 -underline 0 -anchor e
    $ent4 subwidget label config -width 21 -underline 0 -anchor e

    $ent1 subwidget entry config -width 20
    $ent2 subwidget entry config -width 5
    $ent3 subwidget entry config -width 20
    $ent4 subwidget entry config -width 20 -show *

    #----------------------------------------
    # Create the "Proxy" page
    #----------------------------------------
    set f [$w.nb subwidget prox]

    set lab10 [label $f.lab10 -text Host -anchor c]
    set lab30 [label $f.lab30 -text Port -anchor c]

    set lab01 [label $f.lab01 -text HTTP  -anchor e]
    set lab02 [label $f.lab02 -text FTP   -anchor e]
    set lab03 [label $f.lab03 -text HTTPS -anchor e]
    set lab04 [label $f.lab04 -text SOCKS -anchor e]

    set ent11 [entry $f.ent11 -width 20]
    set ent12 [entry $f.ent12 -width 20]
    set ent13 [entry $f.ent13 -width 20]
    set ent14 [entry $f.ent14 -width 20]

    set lab21 [label $f.lab21 -text : -anchor e]
    set lab22 [label $f.lab22 -text : -anchor e]
    set lab23 [label $f.lab23 -text : -anchor e]
    set lab24 [label $f.lab24 -text : -anchor e]

    set ent31 [entry $f.ent31 -width 5]
    set ent32 [entry $f.ent32 -width 5]
    set ent33 [entry $f.ent33 -width 5]
    set ent34 [entry $f.ent34 -width 5]

    grid $lab10 -col 1 -row 0 -sticky news -pady 0
    grid $lab30 -col 3 -row 0 -sticky news -pady 0 

    grid $lab01 -col 0 -row 1 -sticky news -padx 4 -pady 8
    grid $lab02 -col 0 -row 2 -sticky news -padx 4 -pady 8
    grid $lab03 -col 0 -row 3 -sticky news -padx 4 -pady 8
    grid $lab04 -col 0 -row 4 -sticky news -padx 4 -pady 8

    grid $ent11 -col 1 -row 1 -sticky news -padx 4 -pady 8
    grid $ent12 -col 1 -row 2 -sticky news -padx 4 -pady 8
    grid $ent13 -col 1 -row 3 -sticky news -padx 4 -pady 8
    grid $ent14 -col 1 -row 4 -sticky news -padx 4 -pady 8

    grid $lab21 -col 2 -row 1 -pady 8
    grid $lab22 -col 2 -row 2 -pady 8
    grid $lab23 -col 2 -row 3 -pady 8
    grid $lab24 -col 2 -row 4 -pady 8

    grid $ent31 -col 3 -row 1 -sticky news -padx 4 -pady 8
    grid $ent32 -col 3 -row 2 -sticky news -padx 4 -pady 8
    grid $ent33 -col 3 -row 3 -sticky news -padx 4 -pady 8
    grid $ent34 -col 3 -row 4 -sticky news -padx 4 -pady 8
}

if {![info exists tix_demo_running]} {
    wm withdraw .
    set w .demo
    toplevel $w; wm transient $w ""
    RunSample $w
    bind $w <Destroy> {if {"%W" == ".demo"} {after 10 exit}}
}
