'\"
'\" $Id: tixDirSelectDialog.n,v 1.2 2001/01/22 08:02:45 ioilam Exp $
'\"
'\"
'\" Copyright (c) 1993-1999 Ioi Kim Lam.
'\" Copyright (c) 2000-2001 Tix Project Group.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" The file man.macros and some of the macros used by this file are
'\" copyrighted: (c) 1990 The Regents of the University of California.
'\"              (c) 1994-1995 Sun Microsystems, Inc.
'\" The license terms of the Tcl/Tk distrobution are in the file
'\" license.tcl.
.so man.macros
'\"----------------------------------------------------------------------
.TH tixDirSelectDialog n 4.1 Tix "Tix Built-In Commands"
.BS
'\"
'\"
'\"----------------------------------------------------------------------
.SH NAME
tixDirSelectDialog \- Create and manipulate directory selection dialogs.
'\"
'\"
'\"
'\"----------------------------------------------------------------------
.SH SYNOPSIS
\fBtixDirSelectDialog \fIpathName \fR?\fIoptions\fR?
'\"
'\"
'\"----------------------------------------------------------------------
.SH "STANDARD OPTIONS"
'\"
\fBTixDirSelectDialog\fR supports all the standard options of a
toplevel widget. See the \fBoptions(n)\fR manual entry for details on
the standard options.
'\"
'\"
'\"----------------------------------------------------------------------
.SH "WIDGET-SPECIFIC OPTIONS"
'\"
'\"----------BEGIN
.OP \-command command Command
Specifies the command to be called when the user selects a directory
in the dialog box. The command is called with one extra argument, the
complete pathname of the directory. If the user cancels the selection,
this command is not called.
'\"----------END
'\"
'\"----------------------------------------------------------------------
.SH SUBWIDGETS
'\"----------BEGIN
.LP
.nf
Name:		\fBdirbox\fR
Class:		\fBTixDirSelectBox\fR
.fi
.IP
The DirSelectBox widget that consists of the main part of the dialog.
'\"----------END
'\"
'\"----------BEGIN
.LP
.nf
Name:		\fBcancel\fR
Class:		\fBButton\fR
.fi
.IP
The "Cancel" button.
'\"----------END
'\"
'\"
'\"----------BEGIN
.LP
.nf
Name:		\fBok\fR
Class:		\fBButon\fR
.fi
.IP
The "OK" button.
'\"----------END
'\"
.BE
'\"
'\"
'\"----------------------------------------------------------------------
.SH DESCRIPTION
'\"
.PP
'\"
The \fBtixDirSelectDialog\fR command creates a new window (given by
the \fIpathName\fR argument) and makes it into a DirSelectDialog
widget.  Additional options, described above, may be specified on the
command line or in the option database to configure aspects of the
DirSelectDialog such as its cursor and relief.

The DirSelectDialog widget presents the directories in the file system
in a dialog window. The user can use this dialog window to navigate
through the file system to select the desired directory.
'\"
'\"----------------------------------------------------------------------
.SH WIDGET COMMANDS
.PP
'\"
The \fBtixDirSelectDialog\fR command creates a new Tcl command whose
name is the same as the path name of the DirSelectDialog's window.
This command may be used to invoke various operations on the
widget. It has the following general form:
'\"
.RS
.CS
'\"
\fIpathName option \fR?\fIarg arg ...\fR?
.CE
.RE
'\"
\fIPathName\fR is the name of the command, which is the same as the
DirSelectDialog widget's path name. \fIOption\fR and the \fIarg\fRs
determine the exact behavior of the command. The following commands
are possible for DirSelectDialog widgets:
'\"
.TP
\fIpathName \fBcget\fR \fIoption\fR
'\"
Returns the current value of the configuration option given by
\fIoption\fR. \fIOption\fR may have any of the values accepted by the
\fBtixDirSelectDialog\fR command.
'\"
.TP
\fIpathName \fBconfigure\fR ?\fIoption\fR? \fI?value option value ...\fR?
'\"
Query or modify the configuration options of the widget.  If no
\fIoption\fR is specified, returns a list describing all of the
available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s); in
this case the command returns an empty string.  \fIOption\fR may have
any of the values accepted by the \fBtixDirSelectDialog\fR command.
'\"
.TP
\fIpathName \fBpopup\fR
'\"
Pops up the DirSelectDialog widget on the screen.
'\"
.TP
\fIpathName \fBsubwidget \fI name ?args?\fR 
'\"
When no options are given, this command returns the pathname of the
subwidget of the specified name.

When options are given, the widget command of the specified subwidget
will be called with these options.
'\"
'\"
.SH EXAMPLE
'\"
.CS
set dlg [tixDirSelectDialog .dlg -command SelectDir]
$dlg popup

proc SelectDir {dir} {
    puts "You have selected \\"$dir\\""
}
.CE
'\"----------------------------------------------------------------------
.SH KEYWORDS
Tix(n)



