[comment {-*- tcl -*- doctools manpage}]
[manpage_begin html n 1.3]
[moddesc   {HTML Generation}]
[titledesc {Procedures to generate HTML structures}]
[require Tcl 8.2]
[require html [opt 1.3]]
[description]
[para]

The package [package html] provides commands that generate HTML.
These commands typically return an HTML string as their result. In
particular, they do not output their result to [const stdout].

[para]

The command [cmd ::html::init] should be called early to initialize
the module.  You can also use this procedure to define default values
for HTML tag parameters.

[list_begin definitions]

[call [cmd ::html::author] [arg author]]

[emph {Side effect only}].  Call this before [cmd ::html::head] to
define an author for the page.  The author is noted in a comment in
the HEAD section.


[call [cmd ::html::bodyTag] [arg args]]

Generate a BODY tag.  The tag parameters are taken from [arg args] or
from the body.* attributes define with [cmd ::html::init].


[call [cmd ::html::cell] [arg {param value}] [opt [arg tag]]]

Generate a TD (or TH) tag, a value, and a closing TD (or TH) tag. The
tag parameters come from [arg param] or TD.* attributes defined with
[cmd ::html::init].  This uses [cmd ::html::font] to insert a standard
FONT tag into the table cell. The [arg tag] argument defaults to "td".


[call [cmd ::html::checkbox] [arg {name value}]]

Generate a CHECKBOX form element with the specified name and value.
This uses [cmd ::html::checkValue].


[call [cmd ::html::checkSet] [arg {key sep list}]]

Generate a set of CHECKBOX form elements and associated labels.  The
[arg list] should contain an alternating list of labels and values.
This uses [cmd ::html::checkbox]. All the CHECKBOX buttons share the
same [arg key] for their name. The [arg sep] is text used to separate
the elements.


[call [cmd ::html::checkValue] [arg name] [opt [arg value]]]

Generate the "name=[arg name] value=[arg value] for a CHECKBOX form
element.  If the CGI variable [arg name] has the value [arg value],
then SELECTED is added to the return value. [arg value] defaults to
"1".


[call [cmd ::html::closeTag]]

Pop a tag off the stack created by [cmd ::html::openTag] and generate
the corresponding close tag (e.g., /BODY).


[call [cmd ::html::default] [arg key] [opt [arg param]]]

This procedure is used by [cmd ::html::tagParam] to generate the name,
value list of parameters for a tag.  The [cmd ::html::default]
procedure is used to generate default values for those items not
already in [arg param].  If the value identified by [arg key] matches
a value in [arg param] then this procedure returns the empty string.
Otherwise, it returns a "parameter=value" string for a form element
identified by [arg key].  The [arg key] has the form "tag.parameter"
(e.g., body.bgcolor).  Use [cmd ::html::init] to register default
values. [arg param] defaults to the empty string.


[call [cmd ::html::description] [arg description]]

[emph {Side effect only}].  Call this before [cmd ::html::head] to
define a description META tag for the page.  This tag is generated
later in the call to [cmd ::html::head].


[call [cmd ::html::end]]

Pop all open tags from the stack and generate the corresponding close
HTML tags, (e.g., </body></html>).


[call [cmd ::html::eval] [arg arg] [opt [arg args]]]

This procedure is similar to the built-in Tcl [cmd eval] command.  The
only difference is that it returns "" so it can be called from an HTML
template file without appending unwanted results.


[call [cmd ::html::extractParam] [arg {param key}] [opt [arg varName]]]

This is a parsing procedure that extracts the value of [arg key] from
[arg param], which is a HTML-style "name=quotedvalue" list.

[arg varName] is used as the name of a Tcl variable that is changed to
have the value found in the parameters.  The function returns 1 if the
parameter was found in [arg param], otherwise it returns 0.  If the
[arg varName] is not specified, then [arg key] is used as the variable
name.


[call [cmd ::html::font] [arg args]]

Generate a standard FONT tag.  The parameters to the tag are taken
from [arg args] and the HTML defaults defined with [cmd ::html::init].


[call [cmd ::html::for] [arg {start test next body}]]

This procedure is similar to the built-in Tcl [cmd for] control
structure.  Rather than evaluating the body, it returns the subst'ed
[arg body]. Each iteration of the loop causes another string to be
concatenated to the result value.


[call [cmd ::html::foreach] [arg {varlist1 list1}] [opt [arg {varlist2 list2 ...}]] [arg body]]

This procedure is similar to the built-in Tcl [cmd foreach] control
structure.  Rather than evaluating the body, it returns the subst'ed
[arg body].  Each iteration of the loop causes another string to be
concatenated to the result value.


[call [cmd ::html::formValue] [arg name] [opt [arg defvalue]]]

Return a name and value pair, where the value is initialized from
existing CGI data, if any.  The result has this form:

[nl]
[example {
  name="fred" value="freds value"
}]


[call [cmd ::html::getFormInfo] [arg args]]

Generate hidden fields to capture form values.  If [arg args] is
empty, then hidden fields are generated for all CGI values.  Otherwise
args is a list of string match patterns for form element names.


[call [cmd ::html::getTitle]]

Return the title string, with out the surrounding TITLE tag, set with
a previous call to [cmd ::html::title].


[call [cmd ::html::h] [arg {level string}] [opt [arg param]]]

Generate a heading (e.g., H1) tag.  The [arg string] is nested in the
heading, and [arg param] is used for the tag parameters.

[call [cmd ::html::h1] [arg string] [opt [arg param]]]

Generate an H1 tag.  See [cmd ::html::h].

[call [cmd ::html::h2] [arg string] [opt [arg param]]]

Generate an H2 tag.  See [cmd ::html::h].

[call [cmd ::html::h3] [arg string] [opt [arg param]]]

Generate an H3 tag.  See [cmd ::html::h].

[call [cmd ::html::h4] [arg string] [opt [arg param]]]

Generate an H4 tag.  See [cmd ::html::h].

[call [cmd ::html::h5] [arg string] [opt [arg param]]]

Generate an H5 tag.  See [cmd ::html::h].

[call [cmd ::html::h6] [arg string] [opt [arg param]]]

Generate an H6 tag.  See [cmd ::html::h].


[call [cmd ::html::hdrRow] [arg args]]

Generate a table row, including TR and TH tags.
Each value in [arg args] is place into its own table cell.
This uses [cmd ::html::cell].


[call [cmd ::html::head] [arg title]]

Generate the HEAD section that includes the page TITLE.
If previous calls have been made to
[cmd ::html::author], 
[cmd ::html::keywords], 
[cmd ::html::description], 
or
[cmd ::html::meta]
then additional tags are inserted into the HEAD section.
This leaves an open HTML tag pushed on the stack with
[cmd ::html::openTag].


[call [cmd ::html::headTag] [arg string]]

Save a tag for inclusion in the HEAD section generated by

[cmd ::html::head].  The [arg string] is everything in the tag except
the enclosing angle brackets, < >.


[call [cmd ::html::html_entities] [arg string]]

This command replaces all special characters in the [arg string] with
their HTML entities and returns the modified text.


[call [cmd ::html::if] [arg {expr1 body1}] [opt "[const elseif] [arg {expr2 body2 ...}]"] [opt "[const else] [arg bodyN]"]]

This procedure is similar to the built-in Tcl [cmd if] control
structure.  Rather than evaluating the body of the branch that is
taken, it returns the subst'ed [arg body].  Note that the syntax is
slightly more restrictive than that of the built-in Tcl [cmd if]
control structure.


[call [cmd ::html::keywords] [arg args]]

[emph {Side effect only}].  Call this before [cmd ::html::head] to
define a keyword META tag for the page.  The META tag is included in
the result of [cmd ::html::head].


[call [cmd ::html::mailto] [arg email] [opt [arg subject]]]

Generate a hypertext link to a mailto: URL.


[call [cmd ::html::meta] [arg args]]

[emph {Side effect only}].  Call this before [cmd ::html::head] to
define a META tag for the page.  The [arg args] is a Tcl-style name,
value list that is used for the name= and value= parameters for the
META tag.  The META tag is included in the result of

[cmd ::html::head].


[call [cmd ::html::minorMenu] [arg list] [opt [arg sep]]]

Generate a series of hypertext links.  The [arg list] is a Tcl-style
name, value list of labels and urls for the links.  The [arg sep] is
the text to put between each link. It defaults to " | ".


[call [cmd ::html::minorList] [arg list] [opt [arg ordered]]]

Generate an ordered or unordered list of links.  The [arg list] is a
Tcl-style name, value list of labels and urls for the links.

[arg ordered] is a boolean used to choose between an ordered or
unordered list. It defaults to [const false].


[call [cmd ::html::nl2br] [arg string]]

This command replaces all line-endings in the [arg string] with a <br>
tag and returns the modified text.


[call [cmd ::html::openTag] [arg {tag args}]]

Push [arg tag] onto a stack and generate the opening tag for

[arg tag].  Use [cmd ::html::closeTag] to pop the tag from the stack.


[call [cmd ::html::passwordInput] [opt [arg name]]]

Generate an INPUT tag of type PASSWORD. The [arg name] defaults to
"password".


[call [cmd ::html::passwordInputRow] [arg label] [opt [arg name]]]

Format a table row containing a label and an INPUT tag of type
PASSWORD. The [arg name] defaults to "password".


[call [cmd ::html::quoteFormValue] [arg value]]

Quote special characters in [arg value] by replacing them with HTML
entities for quotes, ampersand, and angle brackets.


[call [cmd ::html::radioSet] [arg {key sep list}]]

Generate a set of INPUT tags of type RADIO and an associated text
label.  All the radio buttons share the same [arg key] for their name.
The [arg sep] is text used to separate the elements.  The [arg list]
is a Tcl-style label, value list.


[call [cmd ::html::radioValue] [arg {name value}]]

Generate the "name=[arg name] value=[arg value] for a RADIO form
element.  If the CGI variable [arg name] has the value [arg value],
then SELECTED is added to the return value.


[call [cmd ::html::refresh] [arg {seconds url}]]

Set up a refresh META tag. Call this before [cmd ::html::head] and the
HEAD section will contain a META tag that causes the document to
refresh in [arg seconds] seconds.  The [arg url] is optional.  If
specified, it specifies a new page to load after the refresh interval.


[call [cmd ::html::init] [opt [arg list]]]

[cmd ::html::init] accepts a Tcl-style name-value list that defines
values for items with a name of the form "tag.parameter".  For
example, a default with key "body.bgcolor" defines the background
color for the BODY tag.


[call [cmd ::html::row] [arg args]]

Generate a table row, including TR and TD tags.  Each value in

[arg args] is place into its own table cell. This uses

[cmd ::html::cell].


[call [cmd ::html::paramRow] [arg list] [opt [arg rparam]] [opt [arg cparam]]]

Generate a table row, including TR and TD tags. Each value in

[arg list] is placed into its own table cell. This uses

[cmd ::html::cell]. The value of [arg rparam] is used as parameter for
the TR tag. The value of [arg cparam] is passed to [cmd ::html::cell]
as parameter for the TD tags.


[call [cmd ::html::select] [arg {name param choices}] [opt [arg current]]]

Generate a SELECT form element and nested OPTION tags. The [arg name]
and [arg param] are used to generate the SELECT tag. The [arg choices]
list is a Tcl-style name, value list.


[call [cmd ::html::selectPlain] [arg {name param choices}] [opt [arg current]]]

Like [cmd ::html::select] except that [arg choices] is a Tcl list of
values used for the OPTION tags.  The label and the value for each
OPTION are the same.

[call [cmd ::html::submit] [arg label] [opt [arg name]]]

Generate an INPUT tag of type SUBMIT. [arg name] defaults to "submit".


[call [cmd ::html::set] [arg {var val}]]

This procedure is similar to the built-in Tcl [cmd set] command.  The
main difference is that it returns "" so it can be called from an HTML
template file without appending unwanted results.  The other
difference is that it must take two arguments.


[call [cmd ::html::tableFromArray] [arg arrname] [opt [arg param]] [opt [arg pat]]]

Generate a TABLE and nested rows to display a Tcl array. The

[arg param] are for the TABLE tag. The [arg pat] is a

[cmd {string match}] pattern used to select array elements. It
defaults to "*".


[call [cmd ::html::tableFromList] [arg querylist] [opt [arg param]]]

Generate a TABLE and nested rows to display [arg querylist], which is
a Tcl-style name, value list.  The [arg param] are for the TABLE tag.


[call [cmd ::html::textarea] [arg name] [opt [arg param]] [opt [arg current]]]

Generate a TEXTAREA tag wrapped around its current values.


[call [cmd ::html::textInput] [arg {name value args}]]

Generate an INPUT form tag with type TEXT.  This uses

[cmd ::html::formValue].  The args is any additional tag attributes
you want to put into the INPUT tag.


[call [cmd ::html::textInputRow] [arg {label name value args}]]

Generate an INPUT form tag with type TEXT formatted into a table row
with an associated label.  The args is any additional tag attributes
you want to put into the INPUT tag.


[call [cmd ::html::title] [arg title]]

[emph {Side effect only}].  Call this before [cmd ::html::head] to
define the TITLE for a page.


[call [cmd ::html::varEmpty] [arg name]]

This returns 1 if the named variable either does not exist or has the
empty string for its value.


[call [cmd ::html::while] [arg {test body}]]

This procedure is similar to the built-in Tcl [cmd while] control
structure.  Rather than evaluating the body, it returns the subst'ed
[arg body].  Each iteration of the loop causes another string to be
concatenated to the result value.

[list_end]

[see_also ncgi htmlparse]
[keywords html form table checkbox radiobutton checkbutton]
[manpage_end]
