'\"
'\" Copyright (c) 1995 DSC Technologies Corporation
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\"
'\" @(#) watch.n
'\"
.so man.macros
.HS iwidgets::watch iwid
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
iwidgets::watch \- Create and manipulate time with a watch widgets
.SH SYNOPSIS
\fBiwidgets::watch\fI \fIpathName \fR?\fIoptions\fR?
.SH "INHERITANCE"
itk::Widget <- iwidgets::Watch

.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fBbackground\fR	\fBcursor\fR	\fBforeground\fR	\fBrelief\fR
.fi
.LP
See the "options" manual entry for details on the standard options.
.SH "ASSOCIATED OPTIONS"
.LP
See the "Canvas" manual entry for details on the above associated options.

.SH "WIDGET-SPECIFIC OPTIONS"
.LP
.nf
Name:	\fBclockColor\fR
Class:	\fBColorfR
Command-Line Switch:	\fB-clockcolor\fR
.fi
.IP
Fill color for the main oval encapsulating the watch, in any of the forms
acceptable to \fBTk_GetColor\fR.  The default is "White".
.nf
.LP
Name:	\fBclockStipple\fR
Class:	\fBBitmapfR
Command-Line Switch:	\fB-clockstipple\fR
.fi
.IP
Bitmap for the main oval encapsulating the watch, in any of the forms
acceptable to \fBTk_GetBitmap\fR.  The default is "".
.LP
.nf
Name:	\fBheight\fR
Class:	\fBHeight\fR
Command-Line Switch:	\fB-height\fR
.fi
.IP
Specifies the height of the watch widget in any of the forms 
acceptable to \fBTk_GetPixels\fR.  The default height is 175 pixels.
.LP
.nf
Name:	\fBhourColor\fR
Class:	\fBColorfR
Command-Line Switch:	\fB-hourcolor\fR
.fi
.IP
Fill color for the hour hand, in any of the forms acceptable to \fBTk_GetColor\fR.
The default is "Red".
.LP
.nf
Name:	\fBhourRadius\fR
Class:	\fBRadius\fR
Command-Line Switch:	\fB-hourradius\fR
.fi
.IP
Specifies the radius of the hour hand as a percentage of the radius
from the center to the out perimeter of the clock.
The value must be a fraction <= 1.  The default is ".5".
.LP
.nf
Name:	\fBminuteColor\fR
Class:	\fBColorfR
Command-Line Switch:	\fB-minutecolor\fR
.fi
.IP
Fill color for the minute hand, in any of the forms acceptable to \fBTk_GetColor\fR.
The default is "Yellow".
.LP
.nf
Name:	\fBminuteRadius\fR
Class:	\fBRadius\fR
Command-Line Switch:	\fB-minuteradius\fR
.fi
.IP
Specifies the radius of the minute hand as a percentage of the radius
from the center to the out perimeter of the clock.
The value must be a fraction <= 1.  The default is ".8".
.LP
.nf
Name:	\fBpivotColor\fR
Class:	\fBColorfR
Command-Line Switch:	\fB-pivotcolor\fR
.fi
.IP
Fill color for the circle in which the watch hands rotate
in any of the forms acceptable to \fBTk_GetColor\fR.
The default is "White".
.LP
.nf
Name:	\fBpivotRadius\fR
Class:	\fBRadius\fR
Command-Line Switch:	\fB-pivotradius\fR
.fi
.IP
Specifies the radius of the circle in which the watch hands rotate
as a percentage of the radius.  The value must be a fraction <= 1.
The default is ".1".
.LP
.nf
Name:	\fBsecondColor\fR
Class:	\fBColorfR
Command-Line Switch:	\fB-secondcolor\fR
.fi
.IP
Fill color for the second hand, in any of the forms acceptable to \fBTk_GetColor\fR.
The default is "Black".
.LP
.nf
Name:	\fBsecondRadius\fR
Class:	\fBRadius\fR
Command-Line Switch:	\fB-secondradius\fR
.fi
.IP
Specifies the radius of the second hand as a percentage of the radius
from the center to the out perimeter of the clock.
The value must be a fraction <= 1.  The default is ".9".
.LP
.nf
Name:	\fBshowAmPm\fR
Class:	\fBShosAmPm\fR
Command-Line Switch:	\fB-showampm\fR
.fi
.IP
Specifies whether the AM/PM radiobuttons should be displayed, in any
of the forms acceptable to \fBTcl_GetBoolean\fR.  The default is yes.
.LP
.nf
Name:	\fBstate\fR
Class:	\fBState\fR
Command-Line Switch:	\fB-state\fR
.fi
.IP
Specifies the editable state for the hands on the watch.  In a normal
state, the user can select and move the hands via mouse button 1.  The 
valid values are \fBnormal\fR, and \fBdisabled\fR.  The defult is normal.
.LP
.nf
Name:	\fBtickColor\fR
Class:	\fBColorfR
Command-Line Switch:	\fB-tickcolor\fR
.fi
.IP
Fill color for the 60 ticks around the perimeter of the watch,
in any of the forms acceptable to \fBTk_GetColor\fR.  The default is "Black".
.LP
.nf
Name:	\fBwidth\fR
Class:	\fBWidth\fR
Command-Line Switch:	\fB-width\fR
.fi
.IP
Specifies the width of the watch widget in any of the forms 
acceptable to \fBTk_GetPixels\fR.  The default height is 155 pixels.
.BE

.SH DESCRIPTION
.PP

The \fBiwidgets::watch\fR command creates a watch with hour, minute, and
second hands modifying the time value.

.SH "METHODS"
.PP
The \fBiwidgets::watch\fR command creates a new Tcl command whose
name is \fIpathName\fR. This command may be used to invoke various
operations on the widget. It has the following general form:
.DS C
\fIpathName option \fR?\fIarg arg ...\fR?
.DE
\fIOption\fR and the \fIarg\fRs
determine the exact behavior of the command. The following
commands are possible for watch widgets:

.SH "WIDGET-SPECIFIC METHODS"
.TP
\fIpathName \fBcget\fR \fIoption\fR
Returns the current value of the configuration option given
by \fIoption\fR.
\fIOption\fR may have any of the values accepted by the \fBiwidgets::watch\fR
command.
.TP
\fIpathName\fR \fBconfigure\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?
Query or modify the configuration options of the widget.
If no \fIoption\fR is specified, returns a list describing all of
the available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s);  in
this case the command returns an empty string.
\fIOption\fR may have any of the values accepted by the \fBiwidgets::watch\fR
command.
.TP
\fIpathName \fBget\fR ?\fBformat\fR?
Returns the current time of the watch in a format of 
string or as an integer clock value using the \fB-string\fR and \fB-clicks\fR
format options respectively.  The default is by string.  Reference the 
clock command for more information on obtaining time and its 
formats.
.TP
\fIpathName \fBshow\fR \fItime\fR
Changes the currently displayed time to be that of the time 
argument.  The time may be specified either as a string, an
integer clock value or the keyword "now".  Reference the clock 
command for more information on obtaining time and its format.
.TP
\fIpathName \fBwatch\fR ?\fBargs\fR?
Evaluates the specifieds \fBargs\fR against the canvas component.

.ta 4c
.SH "COMPONENTS"
.LP
.nf
Name:	\fBcanvas\fR
Class:	\fBCanvas\fR
.fi
.IP
The canvas component is the where the clock is drawn.  See the 
Canvas widget manual entry for details.
.LP
.nf
Name:	\fBframe\fR
Class:	\fBFrame\fR
.fi
.IP
The frame component is the where the "AM" and "PM" radiobuttons are displayed.
See the Frame widget manual entry for details.
.LP
.nf
Name:	\fBam\fR
Class:	\fBRadiobutton\fR
.fi
.IP
The am component indicates whether on not the time is relative to "AM".
See the Radiobutton widget manual entry for details.
.LP
.nf
Name:	\fBpm\fR
Class:	\fBRadiobutton\fR
.fi
.IP
The pm component indicates whether on not the time is relative to "PM".
See the Radiobutton widget manual entry for details.
.fi

.SH EXAMPLE
.DS
package require Iwidgets 4.0
iwidgets::watch .w -state disabled -showampm no -width 155 -height 155
pack .w -padx 10 -pady 10 -fill both -expand yes

while {1} {
  after 1000
  .w show
  update
}
.DE
.SH AUTHOR
John Tucker
.DE
Mark L. Ulferts
.SH KEYWORDS
watch, hand, ticks, pivot, widget

