dnl @(#)$Id: acinformix.m4,v 1.1 2000/04/17 22:26:54 jonathan Exp $
dnl
dnl Autoconf macros for supporting Informix ESQL/C

dnl Determine correct value for INFORMIXDIR
AC_DEFUN(IX_ENV_INFORMIXDIR,
[
AC_MSG_CHECKING(for INFORMIXDIR)
ixd_specified=false
AC_ARG_WITH(informixdir,
[   --with-informixdir=dir	Where to find your Informix installation.],
[	INFORMIXDIR=${withval}
	ixd_specified=true
])

if test $ixd_specified = false
then
	INFORMIXDIXDIR=$INFORMIXDIR
	if test x$INFORMIXDIR = x
	then INFORMIXDIR=/usr/informix
	fi
fi

if test -d $INFORMIXDIR
then AC_MSG_RESULT($INFORMIXDIR)
else AC_MSG_ERROR(Unable to determine valid value for INFORMIXDIR)
fi

AC_SUBST(INFORMIXDIR)
])

dnl Determine ESQL/C compiler and version number, and whether there
dnl is support for CONNECT and IUS data types.
dnl Set ESQLC_COMMAND, ESQLC_VERSION, ESQLC_VERTEXT
AC_DEFUN(IX_PROG_ESQLC,
[
AC_REQUIRE([IX_ENV_INFORMIXDIR])

AC_MSG_CHECKING(for ESQL/C compiler and version)

ESQLC_COMMAND=""
for esqlc in esql $INFORMIXDIR/bin/esql
do
	dnl Sample output from 'esql -V'
	dnl INFORMIX-ESQL Version 7.24.UC5  
	dnl Software Serial Number ACN#A287337
	dnl Using 'sed 1q' instead of 'sed -n 1p' generates error messages.
	dnl Note that you cannot easily use [0-9] notation in the sed scripts.
	if esql_output=`$esqlc -V 2>/dev/null | sed -n 1p`
	then
		esqlv=`echo "$esql_output" |
			   sed -e 's/^INFORMIX-.* Version *//' \
				   -e 's/\\.//' -e 's/\\..*//' `
		if test x$esqlv = x
		then AC_MSG_ERROR(Version information from $esqlc not parsable)
		else
			AC_MSG_RESULT($esqlc (version $esqlv))
			ESQLC_COMMAND=$esqlc
			ESQLC_VERSION=$esqlv
			ESQLC_VERTEXT="$esql_output"
			break
		fi
	fi
done
if test x$ESQLC_COMMAND = x
then AC_MSG_ERROR(Could not find a valid ESQL/C compiler)
fi

AC_SUBST(ESQLC_COMMAND)
AC_SUBST(ESQLC_VERSION)
AC_SUBST(ESQLC_VERTEXT)

AC_MSG_CHECKING(ESQL/C Features)
esqltest=esql-$$.h
rm -f $esqltest
{
echo "/* ESQL/C Features determined by configure script */"
if test $ESQLC_VERSION -ge 400 && test $ESQLC_VERSION -lt 600
then echo '$undef  ESQLC_CONNECT;'
else echo '$define ESQLC_CONNECT;'
fi
if test $ESQLC_VERSION -ge 400 && test $ESQLC_VERSION -lt 700
then echo '$undef  ESQLC_CONNECT_DORMANT;'
else echo '$define ESQLC_CONNECT_DORMANT;'
fi
if test $ESQLC_VERSION -ge 900
then echo '$define ESQLC_IUSTYPES;'
else echo '$undef  ESQLC_IUSTYPES;'
fi
} > $esqltest
if cmp -s esqlinfo.h $esqltest 2>/dev/null
then
	AC_MSG_RESULT(esqlinfo.h unchanged)
	rm -f $esqltest
else
	rm -f esqlinfo.h
	mv $esqltest esqlinfo.h
	AC_MSG_RESULT(esqlinfo.h written)
fi
])

dnl Determine ESQL/C header directory and set ESQLC_INCLDIR
AC_DEFUN(IX_PATH_ESQLINCL,
[
AC_REQUIRE([IX_ENV_INFORMIXDIR])

AC_MSG_CHECKING(for ESQL/C header directory)
ESQLC_INCLDIR=
for esqli in $INFORMIXDIR/incl/esql $INFORMIXDIR/incl/tools $INFORMIXDIR/incl
do
	if test -d $esqli
	then ESQLC_INCLDIR=$esqli
		break;
	fi
done
if test x$ESQLC_INCLDIR = x
then AC_MSG_ERROR(Could not find a ESQL/C header directory)
else AC_MSG_RESULT($ESQLC_INCLDIR)
fi

AC_SUBST(ESQLC_INCLDIR)
])

dnl Determine presence or absence of ESQL/C varchar.h header
AC_DEFUN(IX_HEADER_VARCHAR,
[
AC_REQUIRE([IX_PATH_ESQLINCL])

AC_MSG_CHECKING(for ESQL/C varchar.h header)
if test -f $ESQLC_INCLDIR/varchar.h
then
	AC_DEFINE(HAVE_VARCHAR_H)
	AC_MSG_RESULT(yes)
else
	if test -f Missing/varchar.h
	then
		if cmp -s varchar.h Missing/varchar.h 2>/dev/null
		then : OK
			AC_MSG_RESULT(no - using version previously copied from Missing directory)
		else
			rm -f varchar.h
			cp Missing/varchar.h .
			AC_MSG_RESULT(no - copying version from Missing directory)
		fi
	else
		AC_MSG_RESULT(no - creating minimal varchar.h)
		cat - <<! | sed 's/^[ 	][ 	]*//' > varchar.h
		#ifndef VARCHAR_H
		#define VARCHAR_H
		#define MAXVCLEN        (255)
		#define VCLENGTH(len)   (VCMAX(len) + 1)
		#define VCMIN(size)     (((size) >> 8) & 0xFF)
		#define VCMAX(size)     ((size) & 0xFF)
		#define VCSIZ(max, min) ((((min) & 0xFF) << 8) | ((max) & 0xFF))
		#endif VARCHAR_H
!
	fi
	AC_DEFINE(HAVE_VARCHAR_H)
fi
])

dnl Sort out whether config.h needs to undo the damage caused
dnl by sqlhdr.h and sqliapi.h, which can both do #define inappropriately
AC_DEFUN(IX_C_CONST,
[
AC_C_CONST
if test "$ac_cv_c_const" = yes
then AC_DEFINE(HAVE_WORKING_CONST)
fi
AC_SUBST(HAVE_WORKING_CONST)
])

dnl determine whether we need to worry about AIX and the loc_t from
dnl /usr/include/sys/localdef31.h; the body of the file is protected
dnl by _H_LOCALEDEF, but the damage is done before config.h is read,
dnl so the define has to be on the command line.
AC_DEFUN(IX_DEFINE_AIXLOCT,
[
AC_CANONICAL_SYSTEM
AC_MSG_CHECKING(for loc_t problems on AIX)

case "$host_os" in
aix*)
	AC_MSG_RESULT([yes; use -D_H_LOCALEDEF workaround])
	ESQLC_AIXLOCT=-D_H_LOCALEDEF;;
*)
	AC_MSG_RESULT([no, thank goodness!])
	ESQLC_AIXLOCT="";;
esac
AC_SUBST(ESQLC_AIXLOCT)
])
