# Provide ISTAR capability for client ISTAR 1.1
# Created: Thu Apr  4 10:06:58 EST 1996
# Last Updated: Tue Apr 30 14:17:13 EDT 1996

if {"[info command getenv]" == ""} {
	proc getenv {var} {
		global env
		if {[info exists env($var)]} {
			return $env($var)
		}
		return ""
	}
}
proc sql_send_command {cmd} {
	global istar
	set len [string length "$cmd"]
	if {$istar(debug) == 1} {
		puts "SENDING COMMAND [format "%06d" $len] {$cmd}"
	}
	puts -nonewline $istar(conn) [format "%06d" $len]
	puts -nonewline $istar(conn) "$cmd"
	flush $istar(conn)
	set len [read $istar(conn) 7]
	set control [string range $len 0 0]
	scan $len "%*c%d" len
	if {$istar(debug) == 1} {
		puts "READING len $len"
	}
	if {[catch {read $istar(conn) $len} out] != 0} {
		if {$istar(debug) == 1} {
			puts "READERR: $out"
		}
		close $istar(conn)
		set istar(state) 0
		error $out
	}
	if {$control == "F"} {
		if {$istar(debug) == 1} {
			puts "CONTROL F: $out"
		}
		close $istar(conn)
		set istar(state) 0
	} elseif {$control == "X"} {
		if {$istar(debug) == 1} {
			puts "CONTROL X: $out"
		}
		close $istar(conn)
		set istar(state) 0
	} elseif {$control == "E"} {
		if {$istar(debug) == 1} {
			puts "CONTROL E: $out"
		}
		error $out
	} else {
		return $out
	}
}
proc istar_connect {args} {
	global istar
	if {![info exists istar(state)] || $istar(state) == 0} {
		set server [getenv ISTARSERVER]
		set sock [getenv ISTARSOCKET]
		set idebug [getenv ISTARDEBUG]
		set istar(debug) 0
		if {$idebug == "1"} {
			set istar(debug) 1
		}
		if {$sock == ""} {set sock 7028}
		if {$server == ""} {
			error "NO ISTARSERVER SPECIFIED !"
		}
		set istar(conn) [socket $server $sock]
		set istar(server) $server
		set istar(sock) $sock
		set istar(state) 1
		fconfigure $istar(conn) -translation binary
	}
	return $istar(conn)
}
proc sql {args} {
	global istar
	if {![info exists istar(state)] || $istar(state) == 0} {
		istar_connect ""
	}
	sql_send_command "sql $args"
}

#set env(ISTARSERVER) dagger
#set env(ISTARDEBUG) 1
#set env(APPLIB) /ref/smart/guif
#set env(APPMAP) /ref/smart/guif
#set env(DATABASE) ni
#source /ref/smart/guif/ext.tcl
#sql database ni
#fconfigure sock3 -buffering none -buffersize 1 -translation binary
#puts [sql_database ni]
#puts [sql_open "select * from com_ne_defn"]
#puts [sql_fetch 0]
#exit 0
