###########################################################################
#                                                                         #
# Main file for loading the tged package.				  #
#                                                                         #
# This file is part of the tged package.                                  #
#                                                                         #
###########################################################################

# Copyright (c) 2000-2003, JYL Software Inc.
# 
# Permission is hereby granted, free of charge, to any person obtaining
# a copy of this software and associated documentation files (the
# "Software"), to deal in the Software without restriction, including
# without limitation the rights to use, copy, modify, merge, publish,
# distribute, sublicense, and/or sell copies of the Software, and to
# permit persons to whom the Software is furnished to do so, subject to
# the following conditions:
# 
# The above copyright notice and this permission notice shall be
# included in all copies or substantial portions of the Software.
# 
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
# NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
# LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
# OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
# WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

# This package only works in Tk, so ensure we're in a "wish" and
# not in a "tclsh":

if {![package present Tk]} {
    puts stderr "This package must be loaded only in wish, it does not"
    puts stderr "work in tclsh. Aborting"

    return
}

# Create the namespace to contain all the procedures of TGed:

namespace eval tged {}

# Add the directory containing TGed to the auto_path:

proc ::tged::addTGEDDirToAutoPath {} {
    variable data

    # Do this only once:

    if {[info exists data(gc,tgedDir)]} {
	return
    }

    # Compute the directory containing this script:

    set olddir [pwd]
    set curdir [file dirname [info script]]
    cd $curdir
    set curdir [pwd]
    cd $olddir

    # Add that directory to the auto_path:

    lappend ::auto_path $curdir

    # And save the directory name for later use:

    set data(gc,tgedDir) $curdir
}

# Add the directory containing TGed to the auto_path and
# store the name of the directory for future use.

::tged::addTGEDDirToAutoPath

# Source all other files that implement parts of tged, sorted by
# alphabetical name order:

source [file join $::tged::data(gc,tgedDir) tgedbindings.tcl]
source [file join $::tged::data(gc,tgedDir) tgedcache.tcl]
source [file join $::tged::data(gc,tgedDir) tgededit.tcl]
source [file join $::tged::data(gc,tgedDir) tgedevents.tcl]
source [file join $::tged::data(gc,tgedDir) tgedfonts.tcl]
source [file join $::tged::data(gc,tgedDir) tgedinit.tcl]
source [file join $::tged::data(gc,tgedDir) tgedgui.tcl]
source [file join $::tged::data(gc,tgedDir) tgedplatform.tcl]

# Ensure that required packages are loaded:

package require BWidget 1.3

# Ensure that the TGraph package is available (and initialized into this
# interpreter):

::tged::loadTGraph

# Ensure that the global data used by the tged package is available:

::tged::init

# At this point the tged package source is loaded.
#
# $ tged::tged ?win? ?storage? ?options...?
#	Creates an editable storage view inside a
#	new tged widget with the specified options.
#
# $ tged::editor ?win? ?storage? ?options...?
#	Creates a new storage editor based on the tged widget.
#
# $ tged::view ?win? ?storage? ?options...?
#	Creates a read-only storage view inside a
#	new tged widget with the specified options.

package provide tged 1.0.0

