/*
 * i4intstack.cpp --
 *
 *	This file contains the implementation of the e4_IntStack class
 *	defined in e4intstack.h.
 *
 *	Authors: Jacob Levy and Jean-Claude Wippler.
 *		 jyl@best.com	jcw@equi4.com
 *
 * Copyright (c) 2000-2003, JYL Software Inc.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE, EVEN IF
 * JYL SOFTWARE INC. IS MADE AWARE OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "e4graphimpl.h"

/*
 * Constructor:
 */

e4_IntStack::e4_IntStack()
{
    next = 0;
    size = 0;
    stack = NULL;
}

/*
 * Destructor:
 */

e4_IntStack::~e4_IntStack()
{
    if (stack != NULL) {
	free((char *) stack);
    }
}

/*
 * Push an element on the stack.
 */

void
e4_IntStack::Push(int id)
{
    if (next >= size) {
	if (size == 0) {
	    size = 100;
	    stack = (int *) malloc((unsigned) size * sizeof(int));
	} else {
	    size *= 2;
	    stack = (int *) realloc((char *) stack,
				    (unsigned) size * sizeof(int));
	}
    }

    stack[next] = id;
    next++;
}

/*
 * Pop an element from the stack.
 */

bool
e4_IntStack::Pop(int *idp)
{
    if (next < 1) {
	return false;
    }
    *idp = stack[next - 1];
    next--;
    return true;
}

/*
 * Reset the stack to empty state.
 */

void
e4_IntStack::Reset()
{
    next = 0;
}

