/*
 * Decompiled with CFR 0.152.
 */
package com.e4graph;

import com.e4graph.Node;
import com.e4graph.StorageCreationException;
import com.e4graph.StorageIsNotOpenException;
import com.e4graph.StorageIterator;
import com.e4graph.Vertex;

public final class Storage {
    public static final int COMMITATCLOSE = 1;
    public static final int AUTOCOMMIT = 2;
    public static final int OPENGC = 4;
    public static final int GCBEFORECOMMIT = 8;
    public static final int AUTOGC = 16;
    public static final int BIGPREALLOC = 32;
    public static final int COMPACTATCLOSE = 128;
    public static final int DEFAULTSTATE = 21;
    public static final int INVALID = -1;
    public static final String METAKIT = "Metakit 2.4";
    private String name;
    private String driver;
    private int storageIndex;
    private int generation;

    private static native void initNativeIDs();

    private static native int createStorage(String var0, String var1, int var2) throws StorageCreationException;

    private static native int getStorageGeneration(int var0) throws StorageIsNotOpenException;

    private static native String getNameOfStorage(int var0, int var1) throws StorageIsNotOpenException;

    private static native String getDriverOfStorage(int var0, int var1) throws StorageIsNotOpenException;

    private Storage(int n, int n2) {
        this.storageIndex = n;
        this.generation = n2;
        try {
            this.name = Storage.getNameOfStorage(n, n2);
            this.driver = Storage.getDriverOfStorage(n, n2);
        }
        catch (StorageIsNotOpenException storageIsNotOpenException) {
            this.storageIndex = -1;
            this.generation = -1;
        }
    }

    public Storage() {
        this.storageIndex = -1;
        this.generation = -1;
        this.name = null;
        this.driver = null;
    }

    public Storage(String string, String string2) {
        try {
            this.storageIndex = Storage.createStorage(string, string2, 21);
            this.generation = Storage.getStorageGeneration(this.storageIndex);
        }
        catch (StorageCreationException storageCreationException) {
            this.storageIndex = -1;
            this.generation = -1;
        }
        catch (StorageIsNotOpenException storageIsNotOpenException) {
            this.storageIndex = -1;
            this.generation = -1;
        }
        if (this.storageIndex == -1) {
            this.name = null;
            this.driver = null;
        } else {
            this.name = string;
            this.driver = string2;
        }
    }

    public Storage(String string, String string2, int n) {
        try {
            this.storageIndex = Storage.createStorage(string, string2, n);
            this.generation = Storage.getStorageGeneration(this.storageIndex);
        }
        catch (StorageCreationException storageCreationException) {
            this.storageIndex = -1;
            this.generation = -1;
        }
        catch (StorageIsNotOpenException storageIsNotOpenException) {
            this.storageIndex = -1;
            this.generation = -1;
        }
        if (this.storageIndex == -1) {
            this.name = null;
            this.driver = null;
        } else {
            this.name = string;
            this.driver = string2;
        }
    }

    public static StorageIterator getStorageIterator() {
        return new StorageIterator();
    }

    public static native Storage getStorage(int var0, int var1) throws StorageIsNotOpenException;

    public int getIndex() {
        return this.storageIndex;
    }

    public int getStorageIndex() {
        return this.storageIndex;
    }

    public int getGeneration() {
        return this.generation;
    }

    public static native String version();

    public boolean isValid() {
        return this.isValid1(this.storageIndex, this.generation);
    }

    private native boolean isValid1(int var1, int var2);

    public boolean equals(Storage storage) {
        return this.storageIndex == storage.storageIndex && this.generation == storage.generation;
    }

    public int setState(int n) {
        return this.setState1(this.storageIndex, this.generation, n);
    }

    public int getState() {
        return this.getState1(this.storageIndex, this.generation);
    }

    private native int setState1(int var1, int var2, int var3);

    private native int getState1(int var1, int var2);

    public boolean commit() {
        return this.commit1(this.storageIndex, this.generation);
    }

    private native boolean commit1(int var1, int var2);

    public void close() {
        this.close1(this.storageIndex, this.generation);
    }

    private native void close1(int var1, int var2);

    public boolean copyTo(Storage storage, boolean bl) {
        return this.copyTo1(this.storageIndex, this.generation, storage.storageIndex, storage.generation, bl);
    }

    private native boolean copyTo1(int var1, int var2, int var3, int var4, boolean var5);

    public boolean delete() {
        return this.delete1(this.storageIndex, this.generation);
    }

    private native boolean delete1(int var1, int var2);

    public Node getRoot() {
        return this.getRoot1(this.storageIndex, this.generation);
    }

    public boolean setRoot(Node node) {
        return this.setRoot1(this.storageIndex, this.generation, node.getIndex(), node.getStorageIndex());
    }

    private native Node getRoot1(int var1, int var2);

    private native boolean setRoot1(int var1, int var2, int var3, int var4);

    public boolean isStable() {
        return this.isStable1(this.storageIndex, this.generation);
    }

    public void markUnstable() {
        this.markUnstable1(this.storageIndex, this.generation);
    }

    private native boolean isStable1(int var1, int var2);

    private native void markUnstable1(int var1, int var2);

    public String name() {
        return this.name;
    }

    public String driver() {
        return this.driver;
    }

    public Node getNode() {
        return this.getNode1(this.storageIndex, this.generation);
    }

    public Vertex getVertex(String string, Node node) {
        return this.getNodeVertex1(this.storageIndex, this.generation, string, node.getIndex(), node.getStorageIndex(), node.getGeneration());
    }

    public Vertex getVertex(String string, int n) {
        return this.getIntVertex1(this.storageIndex, this.generation, string, n);
    }

    public Vertex getVertex(String string, double d) {
        return this.getDoubleVertex1(this.storageIndex, this.generation, string, d);
    }

    public Vertex getVertex(String string, String string2) {
        return this.getStringVertex1(this.storageIndex, this.generation, string, string2);
    }

    public Vertex getVertex(String string, byte[] byArray) {
        return this.getBytesVertex1(this.storageIndex, this.generation, string, byArray);
    }

    private native Node getNode1(int var1, int var2);

    private native Vertex getNodeVertex1(int var1, int var2, String var3, int var4, int var5, int var6);

    private native Vertex getIntVertex1(int var1, int var2, String var3, int var4);

    private native Vertex getDoubleVertex1(int var1, int var2, String var3, double var4);

    private native Vertex getStringVertex1(int var1, int var2, String var3, String var4);

    private native Vertex getBytesVertex1(int var1, int var2, String var3, byte[] var4);

    public void doGC() {
        this.doGC1(this.storageIndex, this.generation);
    }

    private native void doGC1(int var1, int var2);

    public boolean needsGC() {
        return this.needsGC1(this.storageIndex, this.generation);
    }

    private native boolean needsGC1(int var1, int var2);

    static {
        System.loadLibrary("e4java");
        Storage.initNativeIDs();
    }
}

