/*
** get_new_var_name, implemented in C
**
** Compile with -DWITH_TK to get the -type window capability.  This will
** not work unless you are using it with tk (it won't work with tcl by itself).
*/

#include <dirent.h>
#include <tcl.h>
#include <tclInt.h>
#ifdef WITH_TK
#include <tk.h>
#include <tkInt.h>
#endif
#define VAR_FILE	0
#define VAR_WINDOW	1
#define VAR_COMMAND	2
#define VAR_VARIABLE	3

int do_Varname(ClientData cl, Tcl_Interp *interp, int argc, char *argv[])
{
    char	*cmd,
		*dir = ".",
		*kernel = "var_name",
		**list,
		r[256],
		**t;
    int		global=0,
		i,
    		count=0,
		exists=0,
    		result=TCL_OK,
		type=VAR_VARIABLE;
    Tcl_CmdInfo	cmd_info;
    DIR		*dptr;
    struct	dirent *direntp;
#ifdef WITH_TK
    Tk_Window	window;
#endif

    cmd = *argv;
    ++argv, --argc;

    while (argc) {
	if (!strcmp(*argv, "-dir")) {
	    --argc, ++argv;
	    dir = *argv;
	}
	else if (!strcmp(*argv, "-kernel")) {
	    --argc, ++argv;
	    kernel = *argv;
	}
	else if (!strcmp(*argv, "-list")) {
	    --argc, ++argv;
	    /*
	    ** Count the number of elements in the list
	    */
	    t = argv;
	    count = 0;
	    while (**t && !strcmp(*t, "--") && **t != '-' && count < argc) {
		count++;
	    }
	    list = (char **)malloc(sizeof(char *)*count);
	    t = argv;
	    while (**t && !strcmp(*t, "--") && **t != '-' && count < argc) {
		list[i] = strdup(*t);
	    }
	}
	else if (!strcmp(*argv, "-global")) {
	    global = TCL_GLOBAL_ONLY;
	}
	else if (!strcmp(*argv, "-type")) {
	    --argc, ++argv;
	    if (!strcmp(*argv, "file")) {
		type = VAR_FILE;
		if (!strcmp(kernel, "var_name"))
		    kernel = "file";
	    }
#ifdef WITH_TK
	    else if (!strcmp(*argv, "window")) {
		type = VAR_WINDOW;
		if (!strcmp(kernel, "var_name"))
		    kernel = ".win";
	    }
#endif
	    else if (!strcmp(*argv, "command")) {
		type = VAR_COMMAND;
		if (!strcmp(kernel, "var_name"))
		    kernel = "proc";
	    }
	    else if (!strcmp(*argv, "variable"))
		type = VAR_VARIABLE;
	    else {
		result = TCL_ERROR;

#ifdef WITH_TK
		sprintf(r, "Invalid type %s.  Must be one of 'window', 'command', 'variable', or 'file'", *argv);
#else
		sprintf(r, "Invalid type %s.  Must be one of 'command', 'variable', or 'file'", *argv);
#endif
		Tcl_SetResult(interp, r, TCL_VOLATILE);
	    }
	} else {
	    result = TCL_ERROR;
	    sprintf(r, "Bad option %s.  Must be one of '-global', '-type', '-kernel', '-dir'", *argv);
	    Tcl_SetResult(interp, r, TCL_VOLATILE);
	    return result;
	}
	--argc, ++argv;
    }

    if (result == TCL_OK) {
	char *temp_r = (char *)NULL;
	switch (type) {
	    case VAR_FILE:	dptr = opendir(dir);
		    exists = 1;
		    count=0;
		    while( exists ) {
			rewinddir(dptr);
			sprintf(r, "%s%d", kernel, count);
			exists = 0;
			while( (direntp = readdir(dptr)) != NULL && !exists) {
			    if (!strcmp(direntp->d_name, r))
				exists = 1;
			}
			count++;
		    }
		    (void)closedir(dptr);
		    break;
	    /* 
	    ** the global flag restricts the search to global variables.
	    */ 
	    case VAR_VARIABLE:	exists = 1;
		    count = 0;
		    while(exists) {
			sprintf(r, "%s%d", kernel, count);
#ifdef _DEBUG
			fprintf(stderr, "Checking %s\n", r);
#endif
			/*
			** The following was copied from tclCmdIL.c
			** since they take care of the special case where
			** r is an array
			*/
			if (global) {
			    temp_r = Tcl_GetVar(interp, r, TCL_GLOBAL_ONLY);
			} else {
			    temp_r = Tcl_GetVar(interp, r, TCL_NAMESPACE_ONLY);
			}

			if (! temp_r)
			    exists = 0;
			else
			    count++;
		    }
		    break;
	    /*
	    ** This section has been commented out because of the calls
	    ** to Tk routines.  It won't work in tclsh if this section
	    ** has been compiled in.
	    */
#ifdef WITH_TK
	    case VAR_WINDOW:	exists = 1;
		    count = 0;
		    while(exists) {
			sprintf(r, "%s%d", kernel, count);
			window = Tk_NameToWindow(interp, r, Tk_MainWindow(interp));
			/*
			 * Forget checking if the window is dead.  This would
			 * require us to #include <tkInt.h>, which causes
			 * trouble with some Tcl installations.  It doesn't
			 * matter if the window is in the process of being
			 * destroyed, we'll just go on and search for
			 * a new name anyway.
			if ((window == NULL) || (((TkWindow *) window)->flags & TK_ALREADY_DEAD))
			 */
			if ((window == NULL))
			    exists = 0;
			sprintf(r, "%s%d", kernel, count);
			count++;
		    }
		    break;
#endif
	    case VAR_COMMAND:	exists = 1;
		    count = 0;
		    while(exists) {
			sprintf(r, "%s%d", kernel, count);
			if (!Tcl_GetCommandInfo(interp, r, &cmd_info))
			    exists = 0;
			count++;
		    }
		    break;
	    default:	break;
	}
	Tcl_SetResult(interp, r, TCL_VOLATILE);
    }

    return result;
}

int Varname_Init(Tcl_Interp *interp)
{
    Tcl_CreateCommand(interp, "var_name", do_Varname, NULL, NULL);
    Tcl_PkgProvide(interp, "Varname", "1.0");
    return TCL_OK;
}
