proc tkp_open_file {args} {
    level
    global rinfo_obj files

    set optlist {
	{string} server
	{string} filename
    }

    if ![typedopts $args $optlist opt_found opt_values remains] {
	error "$opt_values(_ERROR_)" 
    }

    if !$opt_found(filename) {
	;#
	;# Get the filename from the user
	;#
    }

    set fileid [File #auto $opt_values(filename)]
    if {$opt_found(server)} { $fileid setserver $opt_values(server) }

    lappend files $fileid

    return $fileid
}

proc tkp_close_file {args} {
    level
    global rinfo_obj

    set optlist {
	{string} filename
    }

    if ![typedopts $args $optlist opt_found opt_values remains] {
	error "$opt_values(_ERROR_)" 
    }

    if !$opt_found(filename) {
	;#
	;# Get the filename from the user
	;#
    }
}

proc tkp_save_file {args} {
    level

    set optlist {
	{string} fileobj
	{string} newfilename
    }

    if ![typedopts $args $optlist opt_found opt_values remains] {
	error "$opt_values(_ERROR_)" 
    }

    if !$opt_found(fileobj) {
	error "No filename specified for saving."
    }
    if !$opt_found(newfilename) {
	;#
	;# Get the filename from the user
	;#
    }

    $opt_values(fileobj) rename $opt_values(newfilename)
}

proc tkp_info_file {args} {
    level
    global rinfo_obj

    set optlist {
	{string} file
	{boolean} num_frames
	{integer} frame
	{multiple} tag
    }

    if ![typedopts $args $optlist opt_found opt_values remains] {
	error "$opt_values(_ERROR_)" 
    }

    if !$opt_found(filename) {
	error "No -filename argument passed to [lindex [info level 0] 0]"
    }
}

proc tkp_select_file {args} {
    level
    global files tags server

    set optlist {
	{string} file
    }

    if ![typedopts $args $optlist opt_found opt_values remains] {
	error "$opt_values(_ERROR_)" 
    }

    if $opt_found(file) {
	set file $opt_values(file)
	set activefiles $file
    }
}

proc tkp_get_processing {args} {
    level
    global sock_list trigger
    set optlist {
	{string} host
	{integer} port
	{boolean} commands
	{string} options
	{string} var
	{string} command
	{string} prog_command
	{string} option_command
    }

    if ![typedopts $args $optlist opt_found opt_values remains] {
	error "$opt_values(_ERROR_)" 
    }

    if !$opt_found(option_command) { set opt_values(option_command) {#}}
    if !$opt_found(prog_command) { set opt_values(prog) {#}}
    if {!$opt_found(host) || !$opt_found(port)} {
	error "options -host and -port must be supplied to [lindex [info level 0] 0]"
    }
    if {$opt_found(commands) || $opt_found(options)} {
	if !$opt_found(var) {
	    error "option -var must be supplied with -commands and -options option"
	}
	if {[catch {set sockid [socket $opt_values(host) $opt_values(port)]} errors]} {
	    bgerror "Could not connect to $opt_values(host):$opt_values(port):  $errors"
	    return
	} else {
	    sputs "Connected to $opt_values(host):$opt_values(port):  $errors"
	}
	fconfigure $sockid -buffering none -blocking 0
	set var $opt_values(var)
	global $var
;#	sputs "opened socket $sockid"
    }

    if $opt_found(commands) {
	fileevent $sockid readable "
	    gets $sockid line
	    if {\[eof $sockid\]} {
		fileevent $sockid readable {}
		return
	    }
	    sputs \"$sockid:  \$line\"
	    if \[regexp {^Unrecognized command:} \$line\] {
		sputs \$line
	    }
	    if \[regexp ^Programlist: \$line\] {
		fileevent $sockid readable {}
		set $var\(cmd_list) \[lrange \$line 1 end\]
		eval \"$opt_values(prog_command)\"
		fileevent $sockid readable {}
		close $sockid
	    }
	"
	puts $sockid "request listing"
    } elseif $opt_found(options) {
	set cmd $opt_values(options)

	fileevent $sockid readable "
	    gets $sockid line
	    if {\[eof $sockid\]} {
		fileevent $sockid readable {}
		return
	    }

	    if {\[llength \$line\] == 4} {
		set cmd \[lindex \$line 0\]
		set $var\(\$cmd,arglist) \[lindex \$line 1\]
		set $var\(\$cmd,sdesc) \[lindex \$line 2\]
		set $var\(\$cmd,ldesc) \[lindex \$line 3\]
	    } elseif {\[llength \$line\] == 7} {
		set cmd \[lindex \$line 0\]
		set flag \[lindex \$line 1\]
		set $var\(\$cmd,\$flag,arg) \[lindex \$line 2\]
		set $var\(\$cmd,\$flag,type) \[lindex \$line 3\]
		set $var\(\$cmd,\$flag,req) \[lindex \$line 4\]
		set $var\(\$cmd,\$flag,sdesc) \[lindex \$line 5\]
		set $var\(\$cmd,\$flag,ldesc) \[lindex \$line 6\]
	    } else {
		puts stderr \"Bad output: \$line\"
		eval \"$opt_values(option_command)\"
	    }
	"
	puts $sockid "help $cmd"
    }
}

#proc tkp_apply_proc {args} {
#    level
#
#    if {[catch  {
#
#    set optlist {
#	{string} arglist
#	{string} file
#	{string} command
#	{string} select
#    }
#    if ![typedopts $args $optlist opt_found opt_values remains] {
#	puts stderr "$opt_values(_ERROR_)" 
#    }
#
#    if {!$opt_found(arglist) || !$opt_found(file)} {
#	error "options -arglist and -file must be passed to [lindex [info level 0] 0]"
#    }
#
#    if {[catch {$opt_values(file) cget -filename}]} {
#	error "No file seleted for processing"
#    }
#
#    array set var "
#	%	%
#	i	[$opt_values(file) cget -filename]
#	o	results.rdf
#	u	[$opt_values(file) url]
#    "
#
#    regsub -all %(.) $opt_values(arglist) \$var(\\1) opt_values(arglist)
#    set opt_values(arglist) [eval list $opt_values(arglist)]
#
##    sputs "$opt_values(file) process $opt_values(arglist)"
#    eval $opt_values(file) process $opt_values(arglist)
#
#
#    if $opt_found(command) {
#	uplevel 1 $opt_values(command)
#    }
#
#    } errors]} {
#	global errorInfo
#	set savedInfo $errorInfo
#	error $errors $savedInfo
#    }
#
#    return $var(o)
#}

proc tkp_exit {} {
    exit
}

#
# The following procs are defined here:
#
# addframeURL -frame n
# addspecURL ?-start n? ?-end n? ?-list n1 n2 n3...? ?-index n?
# addfileURL -file f
#
#

source $datadir/tcl/url.tcl
