/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import tcl.lang.AssocData;
import tcl.lang.Command;
import tcl.lang.Notifier;
import tcl.lang.ReflectObject;
import tcl.lang.TclBoolean;
import tcl.lang.TclDouble;
import tcl.lang.TclException;
import tcl.lang.TclInteger;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;
import tcl.lang.Util;
import tcl.lang.VarTrace;

public class Interp {
    long interpPtr;
    Hashtable reflectIDTable;
    Hashtable reflectObjTable;
    long reflectObjCount;
    private Notifier notifier;
    Hashtable assocDataTab;

    private Interp(long l) {
        this.interpPtr = l;
        this.notifier = Notifier.getNotifierForThread(Thread.currentThread());
        this.notifier.preserve();
        ReflectObject.init((Interp)this);
    }

    public Interp() {
        this.interpPtr = this.create();
        this.notifier = Notifier.getNotifierForThread(Thread.currentThread());
        this.notifier.preserve();
        ReflectObject.init((Interp)this);
        if (this.init(this.interpPtr) != 0) {
            String result = this.getResult().toString();
            this.dispose();
            throw new TclRuntimeError(result);
        }
    }

    private final native long create();

    public void dispose() {
        if (this.assocDataTab != null) {
            Enumeration e = this.assocDataTab.keys();
            while (e.hasMoreElements()) {
                Object key = e.nextElement();
                AssocData data = (AssocData)this.assocDataTab.get(key);
                data.disposeAssocData(this);
                this.assocDataTab.remove(key);
            }
            this.assocDataTab = null;
        }
        if (this.notifier != null) {
            this.notifier.release();
            this.notifier = null;
        }
        if (this.interpPtr != 0L) {
            Interp.doDispose(this.interpPtr);
            this.interpPtr = 0L;
        }
    }

    protected void finalize() {
        this.dispose();
    }

    File getWorkingDir() {
        return new File(Util.getCwd());
    }

    public final native TclObject setVar(String var1, String var2, TclObject var3, int var4) throws TclException;

    public final TclObject setVar(String name, TclObject value, int flags) throws TclException {
        return this.setVar(name, null, value, flags | 0x400);
    }

    public final native TclObject getVar(String var1, String var2, int var3) throws TclException;

    public final TclObject getVar(String name, int flags) throws TclException {
        return this.getVar(name, null, flags | 0x400);
    }

    public final void unsetVar(String name, int flags) throws TclException {
        this.unsetVar(name, null, flags | 0x400);
    }

    public final native void unsetVar(String var1, String var2, int var3) throws TclException;

    public void traceVar(String name, VarTrace trace, int flags) throws TclException {
        this.traceVar(name, null, trace, flags | 0x400);
    }

    public native void traceVar(String var1, String var2, VarTrace var3, int var4) throws TclException;

    public void untraceVar(String name, VarTrace trace, int flags) throws TclException {
        this.untraceVar(name, null, trace, flags | 0x400);
    }

    public native void untraceVar(String var1, String var2, VarTrace var3, int var4) throws TclException;

    public native void createCommand(String var1, Command var2);

    public native int deleteCommand(String var1);

    public Command getCommand(String name) {
        throw new TclRuntimeError("Not implemented yet.");
    }

    public static native boolean commandComplete(String var0);

    public final native TclObject getResult();

    public final native void setResult(TclObject var1);

    public final void setResult(String r) {
        this.setResult(TclString.newInstance((String)r));
    }

    public final void setResult(int r) {
        this.setResult(TclInteger.newInstance((int)r));
    }

    public final void setResult(boolean r) {
        this.setResult(TclBoolean.newInstance((boolean)r));
    }

    public final void setResult(double r) {
        this.setResult(TclDouble.newInstance((double)r));
    }

    public final native void resetResult();

    public native void eval(String var1, int var2) throws TclException;

    public void eval(String script) throws TclException {
        this.eval(script, 0);
    }

    public void eval(TclObject tobj, int flags) throws TclException {
        this.eval(tobj.toString(), flags);
    }

    public void evalFile(String s) throws TclException {
        throw new TclRuntimeError("Not implemented yet.");
    }

    void evalResource(String resName) throws TclException {
        InputStream stream = this.getClass().getResourceAsStream(resName);
        if (stream == null) {
            throw new TclException(this, "cannot read resource \"" + resName + "\"");
        }
        try {
            try {
                if ((System.getProperty("java.version").equals("1.2beta4") || System.getProperty("java.version").equals("1.2fcs")) && stream.getClass().getName().equals("java.util.zip.ZipFile$1")) {
                    int used = 0;
                    int size = stream.available() * 4;
                    byte[] byteArray = new byte[size];
                    int cur = stream.read();
                    while (cur != -1) {
                        if (used >= size) {
                            byte[] oldArray = byteArray;
                            int new_size = size * 2;
                            byteArray = new byte[new_size];
                            System.arraycopy(oldArray, 0, byteArray, 0, used);
                            oldArray = null;
                            size = new_size;
                        }
                        byteArray[used++] = (byte)cur;
                        cur = stream.read();
                    }
                    this.eval(new String(byteArray, 0, used), 0);
                } else {
                    int num = stream.available();
                    byte[] byteArray = new byte[num];
                    int offset = 0;
                    while (num > 0) {
                        int readLen = stream.read(byteArray, offset, num);
                        offset += readLen;
                        num -= readLen;
                    }
                    this.eval(new String(byteArray), 0);
                }
            }
            catch (IOException iOException) {
                Object var4_13 = null;
                this.closeInputStream(stream);
                return;
            }
            Object var4_14 = null;
            this.closeInputStream(stream);
        }
        catch (Throwable throwable) {
            Object var4_15 = null;
            this.closeInputStream(stream);
            throw throwable;
        }
    }

    private void closeInputStream(InputStream fs) {
        try {
            fs.close();
        }
        catch (IOException iOException) {}
    }

    private int callCommand(Command cmd, TclObject[] argv) {
        try {
            cmd.cmdProc(this, argv);
            return 0;
        }
        catch (TclException e) {
            return e.getCompletionCode();
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new TclRuntimeError("Error in command implementation");
        }
    }

    public native void setErrorCode(TclObject var1);

    public native void addErrorInfo(String var1);

    public native void backgroundError();

    public Notifier getNotifier() {
        return this.notifier;
    }

    public void setAssocData(String name, AssocData data) {
        if (this.assocDataTab == null) {
            this.assocDataTab = new Hashtable();
        }
        this.assocDataTab.put(name, data);
    }

    public void deleteAssocData(String name) {
        if (this.assocDataTab == null) {
            return;
        }
        this.assocDataTab.remove(name);
    }

    public AssocData getAssocData(String name) {
        if (this.assocDataTab == null) {
            return null;
        }
        return (AssocData)this.assocDataTab.get(name);
    }

    private final native int init(long var1);

    private static final native void doDispose(long var0);

    public final native void pkgProvide(String var1, String var2);

    public final native String pkgRequire(String var1, String var2, boolean var3);

    static {
        System.loadLibrary("tclblend");
    }
}

