/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.EventDeleter;
import tcl.lang.TclEvent;
import tcl.lang.TclRuntimeError;

public class Notifier {
    private static Notifier globalNotifier;
    private TclEvent firstEvent;
    private TclEvent lastEvent;
    private TclEvent markerEvent;
    Thread primaryThread;
    int refCount;

    private Notifier(Thread primaryTh) {
        this.primaryThread = primaryTh;
        this.firstEvent = null;
        this.lastEvent = null;
        this.markerEvent = null;
        this.refCount = 0;
        this.init();
    }

    public static synchronized Notifier getNotifierForThread(Thread thread) {
        if (globalNotifier == null) {
            globalNotifier = new Notifier(thread);
        } else if (Notifier.globalNotifier.primaryThread != thread) {
            return null;
        }
        return globalNotifier;
    }

    public synchronized void preserve() {
        if (this.refCount < 0) {
            throw new TclRuntimeError("Attempting to preserve a freed Notifier");
        }
        ++this.refCount;
    }

    public synchronized void release() {
        if (this.refCount == 0 && this.primaryThread != null) {
            throw new TclRuntimeError("Attempting to release a Notifier before it's preserved");
        }
        if (this.refCount <= 0) {
            throw new TclRuntimeError("Attempting to release a freed Notifier");
        }
        --this.refCount;
        if (this.refCount == 0) {
            this.primaryThread = null;
            globalNotifier = null;
            this.dispose();
        }
    }

    public synchronized void queueEvent(TclEvent evt, int position) {
        evt.notifier = this;
        if (position == 0) {
            evt.next = null;
            if (this.firstEvent == null) {
                this.firstEvent = evt;
            } else {
                this.lastEvent.next = evt;
            }
            this.lastEvent = evt;
        } else if (position == 1) {
            evt.next = this.firstEvent;
            if (this.firstEvent == null) {
                this.lastEvent = evt;
            }
            this.firstEvent = evt;
        } else if (position == 2) {
            if (this.markerEvent == null) {
                evt.next = this.firstEvent;
                this.firstEvent = evt;
            } else {
                evt.next = this.markerEvent.next;
                this.markerEvent.next = evt;
            }
            this.markerEvent = evt;
            if (evt.next == null) {
                this.lastEvent = evt;
            }
        } else {
            throw new TclRuntimeError("wrong position \"" + position + "\", must be TCL.QUEUE_HEAD, TCL.QUEUE_TAIL or TCL.QUEUE_MARK");
        }
        if (Thread.currentThread() != this.primaryThread) {
            this.alertNotifier();
        }
    }

    public synchronized void deleteEvents(EventDeleter deleter) {
        TclEvent prev = null;
        TclEvent evt = this.firstEvent;
        while (evt != null) {
            if (deleter.deleteEvent(evt) == 1) {
                if (this.firstEvent == evt) {
                    this.firstEvent = evt.next;
                    if (evt.next == null) {
                        this.lastEvent = null;
                    }
                } else {
                    prev.next = evt.next;
                }
                if (this.markerEvent == evt) {
                    this.markerEvent = null;
                }
            } else {
                prev = evt;
            }
            evt = evt.next;
        }
    }

    synchronized int serviceEvent(int flags) {
        if ((flags & 0xFFFFFFFD) == 0) {
            flags |= 0xFFFFFFFD;
        }
        TclEvent evt = this.firstEvent;
        while (evt != null) {
            boolean b = evt.isProcessing;
            evt.isProcessing = true;
            if (!b && evt.processEvent(flags) != 0) {
                evt.isProcessed = true;
                if (evt.needsNotify) {
                    TclEvent tclEvent = evt;
                    synchronized (tclEvent) {
                        evt.notifyAll();
                    }
                }
                if (this.firstEvent == evt) {
                    this.firstEvent = evt.next;
                    if (evt.next == null) {
                        this.lastEvent = null;
                    }
                    if (this.markerEvent == evt) {
                        this.markerEvent = null;
                    }
                } else {
                    TclEvent prev = this.firstEvent;
                    while (prev.next != evt) {
                        prev = prev.next;
                    }
                    prev.next = evt.next;
                    if (evt.next == null) {
                        this.lastEvent = prev;
                    }
                    if (this.markerEvent == evt) {
                        this.markerEvent = prev;
                    }
                }
                return 1;
            }
            evt.isProcessing = b;
            evt = evt.next;
        }
        return 0;
    }

    public native int doOneEvent(int var1);

    private final native void alertNotifier();

    private final native void init();

    final native void dispose();

    private final synchronized boolean hasEvents() {
        return this.firstEvent != null;
    }
}

