/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.CallFrame;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclString;
import tcl.lang.Util;

class UplevelCmd
implements Command {
    public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
        int objc = objv.length;
        if (objv.length < 2) {
            throw new TclNumArgsException(interp, 1, objv, "?level? command ?arg ...?");
        }
        String optLevel = objv[1].toString();
        CallFrame[] frameArr = new CallFrame[1];
        int result = CallFrame.getFrame(interp, optLevel, frameArr);
        CallFrame frame = frameArr[0];
        if ((objc -= result + 1) == 0) {
            throw new TclNumArgsException(interp, 1, objv, "?level? command ?arg ...?");
        }
        int objv_index = result + 1;
        CallFrame savedVarFrame = interp.varFrame;
        interp.varFrame = frame;
        TclObject cmd = objc == 1 ? objv[objv_index] : TclString.newInstance((String)Util.concat(objv_index, objv.length - 1, objv));
        cmd.preserve();
        try {
            try {
                interp.eval(cmd, 0);
            }
            catch (TclException e) {
                if (e.getCompletionCode() == 1) {
                    interp.addErrorInfo("\n    (\"uplevel\" body line " + interp.errorLine + ")");
                }
                throw e;
            }
            Object var12_11 = null;
            interp.varFrame = savedVarFrame;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            interp.varFrame = savedVarFrame;
            cmd.release();
            throw throwable;
        }
        cmd.release();
    }

    UplevelCmd() {
    }
}

