/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.util.Vector;
import tcl.lang.FindElemResult;
import tcl.lang.InternalRep;
import tcl.lang.Interp;
import tcl.lang.QSort;
import tcl.lang.TclException;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;
import tcl.lang.Util;

public class TclList
extends InternalRep {
    private Vector vector;

    /*
     * WARNING - void declaration
     */
    protected void dispose() {
        void var1_1;
        int size = this.vector.size();
        int i = 0;
        while (i < var1_1) {
            ((TclObject)this.vector.elementAt(i)).release();
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected InternalRep duplicate() {
        void var2_2;
        int size = this.vector.size();
        TclList newList = new TclList(size);
        int i = 0;
        while (i < size) {
            TclObject tobj = (TclObject)this.vector.elementAt(i);
            tobj.preserve();
            newList.vector.addElement(tobj.takeExclusive());
            ++i;
        }
        return var2_2;
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        int size = this.vector.size();
        try {
            int i = 0;
            while (i < size) {
                Object elm = this.vector.elementAt(i);
                if (elm != null) {
                    Util.appendElement(null, sbuf, elm.toString());
                } else {
                    Util.appendElement(null, sbuf, "");
                }
                ++i;
            }
        }
        catch (TclException e) {
            throw new TclRuntimeError("unexpected TclException: " + (Object)((Object)e));
        }
        return sbuf.toString();
    }

    public static TclObject newInstance() {
        return new TclObject((InternalRep)new TclList());
    }

    /*
     * WARNING - void declaration
     */
    static void setListFromAny(Interp interp, TclObject tobj) throws TclException {
        InternalRep rep = tobj.getInternalRep();
        if (!(rep instanceof TclList)) {
            void var3_3;
            TclList tlist = new TclList();
            TclList.splitList(interp, tlist.vector, tobj.toString());
            tobj.setInternalRep((InternalRep)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void splitList(Interp interp, Vector v, String s) throws TclException {
        void var3_3;
        int len = s.length();
        int i = 0;
        while (i < var3_3) {
            FindElemResult res = Util.findElement(interp, s, i, len);
            if (res == null) break;
            TclObject tobj = TclString.newInstance((String)res.elem);
            tobj.preserve();
            v.addElement(tobj);
            i = res.elemEnd;
        }
    }

    public static final void append(Interp interp, TclObject tobj, TclObject elemObj) throws TclException {
        TclList.setListFromAny(interp, tobj);
        tobj.invalidateStringRep();
        TclList tlist = (TclList)tobj.getInternalRep();
        elemObj.preserve();
        tlist.vector.addElement(elemObj.takeExclusive());
    }

    public static final int getLength(Interp interp, TclObject tobj) throws TclException {
        TclList.setListFromAny(interp, tobj);
        TclList tlist = (TclList)tobj.getInternalRep();
        return tlist.vector.size();
    }

    public static TclObject[] getElements(Interp interp, TclObject tobj) throws TclException {
        TclList.setListFromAny(interp, tobj);
        TclList tlist = (TclList)tobj.getInternalRep();
        int size = tlist.vector.size();
        TclObject[] objArray = new TclObject[size];
        int i = 0;
        while (i < size) {
            objArray[i] = (TclObject)tlist.vector.elementAt(i);
            ++i;
        }
        return objArray;
    }

    public static final TclObject index(Interp interp, TclObject tobj, int index) throws TclException {
        TclList.setListFromAny(interp, tobj);
        TclList tlist = (TclList)tobj.getInternalRep();
        if (index < 0 || index >= tlist.vector.size()) {
            return null;
        }
        return (TclObject)tlist.vector.elementAt(index);
    }

    static final void insert(Interp interp, TclObject tobj, int index, TclObject[] elements, int from, int to) throws TclException {
        TclList.replace(interp, tobj, index, 0, elements, from, to);
    }

    public static final void replace(Interp interp, TclObject tobj, int index, int count, TclObject[] elements, int from, int to) throws TclException {
        int i;
        TclList.setListFromAny(interp, tobj);
        tobj.invalidateStringRep();
        TclList tlist = (TclList)tobj.getInternalRep();
        int size = tlist.vector.size();
        if (index >= size) {
            index = size;
        } else {
            if (index < 0) {
                index = 0;
            }
            if (count > size - index) {
                count = size - index;
            }
            i = 0;
            while (i < count) {
                TclObject obj = (TclObject)tlist.vector.elementAt(index);
                obj.release();
                tlist.vector.removeElementAt(index);
                ++i;
            }
        }
        i = from;
        while (i <= to) {
            elements[i].preserve();
            tlist.vector.insertElementAt(elements[i].takeExclusive(), index++);
            ++i;
        }
    }

    static void sort(Interp interp, TclObject tobj, int sortMode, int sortIndex, boolean sortIncreasing, String command) throws TclException {
        TclList.setListFromAny(interp, tobj);
        tobj.invalidateStringRep();
        TclList tlist = (TclList)tobj.getInternalRep();
        int size = tlist.vector.size();
        if (size <= 1) {
            return;
        }
        TclObject[] objArray = new TclObject[size];
        int i = 0;
        while (i < size) {
            objArray[i] = (TclObject)tlist.vector.elementAt(i);
            ++i;
        }
        QSort s = new QSort();
        s.sort(interp, objArray, sortMode, sortIndex, sortIncreasing, command);
        int i2 = 0;
        while (i2 < size) {
            tlist.vector.setElementAt(objArray[i2], i2);
            objArray[i2] = null;
            ++i2;
        }
    }

    private TclList() {
        this.vector = new Vector();
    }

    private TclList(int size) {
        this.vector = new Vector(size);
    }
}

