/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.BackSlashResult;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.ParseResult;
import tcl.lang.Parser;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;

class SubstCmd
implements Command {
    private static final String[] validCmds = new String[]{"-nobackslashes", "-nocommands", "-novariables"};
    static final int OPT_NOBACKSLASHES = 0;
    static final int OPT_NOCOMMANDS = 1;
    static final int OPT_NOVARS = 2;

    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        int objc = argv.length - 1;
        boolean doBackslashes = true;
        boolean doCmds = true;
        boolean doVars = true;
        String result = "";
        int currentObjIndex = 1;
        while (currentObjIndex < objc) {
            if (!argv[currentObjIndex].toString().startsWith("-")) break;
            int opt = TclIndex.get((Interp)interp, (TclObject)argv[currentObjIndex], (String[])validCmds, (String)"switch", (int)0);
            switch (opt) {
                case 0: {
                    doBackslashes = false;
                    break;
                }
                case 1: {
                    doCmds = false;
                    break;
                }
                case 2: {
                    doVars = false;
                    break;
                }
                default: {
                    throw new TclException(interp, "SubstCmd.cmdProc: bad option " + opt + " index to cmds");
                }
            }
            ++currentObjIndex;
        }
        if (currentObjIndex != objc) {
            throw new TclNumArgsException(interp, currentObjIndex, argv, "?-nobackslashes? ?-nocommands? ?-novariables? string");
        }
        String s = argv[currentObjIndex].toString();
        int len = s.length();
        int i = 0;
        while (i < len) {
            char c = s.charAt(i);
            if (c == '[' && doCmds) {
                ParseResult res;
                try {
                    interp.evalFlags = 1;
                    interp.eval(s.substring(i + 1, len));
                    res = new ParseResult(interp.getResult(), i + interp.termOffset);
                }
                catch (TclException e) {
                    i = e.errIndex + 1;
                    throw e;
                }
                i = res.nextIndex + 2;
                result = result + res.value.toString();
            } else if (c == '\r') {
                ++i;
            } else if (c == '$' && doVars) {
                ParseResult vres = Parser.parseVar(interp, s.substring(i, len));
                i += vres.nextIndex;
                result = result + vres.value.toString();
            } else if (c == '\\' && doBackslashes) {
                BackSlashResult bs = Interp.backslash(s, i, len);
                i = bs.nextIndex;
                if (bs.isWordSep) break;
                result = result + bs.c;
            } else {
                result = result + c;
                ++i;
            }
            if (i >= len) break;
        }
        interp.setResult(result);
    }

    SubstCmd() {
    }
}

