/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;

public class PkgInvoker {
    static Hashtable cachedInvokers = new Hashtable();
    static PkgInvoker defaultInvoker = new PkgInvoker();

    public Object invokeConstructor(Constructor constructor, Object[] args) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        return constructor.newInstance(args);
    }

    public Object invokeMethod(Method method, Object obj, Object[] args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        return method.invoke(obj, args);
    }

    public Object getField(Field field, Object obj) throws IllegalArgumentException, IllegalAccessException {
        return field.get(obj);
    }

    public void setField(Field field, Object obj, Object value) throws IllegalArgumentException, IllegalAccessException {
        field.set(obj, value);
    }

    public static final PkgInvoker getPkgInvoker(Class cls) {
        String clsName = cls.getName();
        int index = clsName.lastIndexOf(46);
        String pkg = index == -1 ? "" : clsName.substring(0, index);
        PkgInvoker invoker = (PkgInvoker)cachedInvokers.get(pkg);
        if (invoker == null) {
            try {
                Class<?> invCls = Class.forName(String.valueOf(pkg) + ".TclPkgInvoker");
                invoker = (PkgInvoker)invCls.newInstance();
            }
            catch (Exception exception) {
                invoker = defaultInvoker;
            }
            if (invoker == null) {
                invoker = defaultInvoker;
            }
            cachedInvokers.put(pkg, invoker);
        }
        return invoker;
    }
}

