/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.InternalRep;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclObject;

public class TclIndex
extends InternalRep {
    private int index;
    private String[] table;

    private TclIndex(int i, String[] tab) {
        this.index = i;
        this.table = tab;
    }

    protected InternalRep duplicate() {
        return new TclIndex(this.index, this.table);
    }

    public String toString() {
        return this.table[this.index];
    }

    public static int get(Interp interp, TclObject tobj, String[] table, String msg, int flags) throws TclException {
        int index;
        block12: {
            int i;
            InternalRep rep = tobj.getInternalRep();
            if (rep instanceof TclIndex && ((TclIndex)rep).table == table) {
                return ((TclIndex)rep).index;
            }
            String str = tobj.toString();
            int strLen = str.length();
            int tableLen = table.length;
            index = -1;
            int numAbbrev = 0;
            if (strLen > 0) {
                char c = str.charAt(0);
                i = 0;
                while (i < tableLen) {
                    String option = table[i];
                    if ((flags & 1) != 1 || option.length() == strLen) {
                        if (option.equals(str)) {
                            index = i;
                            break block12;
                        }
                        if (option.startsWith(str)) {
                            ++numAbbrev;
                            index = i;
                        }
                    }
                    ++i;
                }
            }
            if (numAbbrev != 1) {
                StringBuffer sbuf = new StringBuffer();
                if (numAbbrev > 1) {
                    sbuf.append("ambiguous ");
                } else {
                    sbuf.append("bad ");
                }
                sbuf.append(msg);
                sbuf.append(" \"");
                sbuf.append(str);
                sbuf.append("\"");
                sbuf.append(": must be ");
                sbuf.append(table[0]);
                i = 1;
                while (i < tableLen) {
                    if (i == tableLen - 1) {
                        sbuf.append(", or ");
                    } else {
                        sbuf.append(", ");
                    }
                    sbuf.append(table[i]);
                    ++i;
                }
                throw new TclException(interp, sbuf.toString());
            }
        }
        tobj.setInternalRep(new TclIndex(index, table));
        return index;
    }
}

