/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import tcl.lang.ClassRep;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.ReflectObject;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclString;

class JavaInfoCmd
implements Command {
    private static final String[] validCmds = new String[]{"class", "baseclass", "dimensions", "events", "fields", "methods", "constructors", "properties", "superclass"};
    private static final int CLASS = 0;
    private static final int BASECLASS = 1;
    private static final int DIMENSIONS = 2;
    private static final int EVENTS = 3;
    private static final int FIELDS = 4;
    private static final int METHODS = 5;
    private static final int CONSTRUCTORS = 6;
    private static final int PROPERTIES = 7;
    private static final int SUPERCLASS = 8;
    private static final String[] propOpts = new String[]{"-type"};
    private static final String[] methOpts = new String[]{"-type", "-static"};
    static final int TYPE_OPT = 0;
    static final int STATIC_OPT = 1;

    /*
     * Unable to fully structure code
     */
    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        lastArg = argv.length - 1;
        statOpt = false;
        typeOpt = false;
        if (argv.length < 2) {
            throw new TclNumArgsException(interp, 1, argv, "option ?arg arg ...?");
        }
        opt = TclIndex.get(interp, argv[1], JavaInfoCmd.validCmds, "option", 0);
        switch (opt) {
            case 1: {
                if (argv.length != 3) {
                    throw new TclNumArgsException(interp, 2, argv, "objOrClass");
                }
                c = JavaInfoCmd.getClassFromObj(interp, argv[2]);
                if (c != null) {
                    interp.setResult(JavaInfoCmd.getBaseNameFromClass(c));
                }
                return;
            }
            case 0: {
                if (argv.length != 3) {
                    throw new TclNumArgsException(interp, 2, argv, "javaObj");
                }
                c = ReflectObject.getClass(interp, argv[2]);
                if (c != null) {
                    interp.setResult(JavaInfoCmd.getNameFromClass(c));
                }
                return;
            }
            case 2: {
                if (argv.length != 3) {
                    throw new TclNumArgsException(interp, 2, argv, "objOrClass");
                }
                c = JavaInfoCmd.getClassFromObj(interp, argv[2]);
                if (c == null) {
                    interp.setResult(0);
                } else {
                    interp.setResult(JavaInfoCmd.getNumDimsFromClass(c));
                }
                return;
            }
            case 3: {
                if (argv.length != 3) {
                    throw new TclNumArgsException(interp, 2, argv, "javaObj");
                }
                c = JavaInfoCmd.getClassFromObj(interp, argv[2]);
                if (c == null) {
                    interp.resetResult();
                    return;
                }
                try {
                    beanInfo = Introspector.getBeanInfo(c);
                }
                catch (IntrospectionException var10_19) {
                    ** GOTO lbl53
                }
                events = beanInfo.getEventSetDescriptors();
                if (events != null) {
                    list = TclList.newInstance();
                    i = 0;
                    while (i < events.length) {
                        TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance(events[i].getListenerType().getName()));
                        ++i;
                    }
                    interp.setResult(list);
                    return;
                }
lbl53:
                // 3 sources

                interp.resetResult();
                return;
            }
            case 4: {
                if (lastArg < 2 || lastArg > 4) {
                    throw new TclNumArgsException(interp, 2, argv, "?-type? ?-static? objOrClass");
                }
                i = 2;
                while (i < lastArg) {
                    opt = TclIndex.get(interp, argv[i], JavaInfoCmd.methOpts, "option", 0);
                    switch (opt) {
                        case 1: {
                            statOpt = true;
                            break;
                        }
                        case 0: {
                            typeOpt = true;
                            break;
                        }
                    }
                    ++i;
                }
                c = JavaInfoCmd.getClassFromObj(interp, argv[lastArg]);
                if (c != null) {
                    resultListObj = JavaInfoCmd.getFieldInfoList(interp, c, statOpt, typeOpt);
                    interp.setResult(resultListObj);
                }
                return;
            }
            case 5: {
                if (lastArg < 2 || lastArg > 4) {
                    throw new TclNumArgsException(interp, 2, argv, "?-type? ?-static? objOrClass");
                }
                i = 2;
                while (i < lastArg) {
                    opt = TclIndex.get(interp, argv[i], JavaInfoCmd.methOpts, "option", 0);
                    switch (opt) {
                        case 1: {
                            statOpt = true;
                            break;
                        }
                        case 0: {
                            typeOpt = true;
                            break;
                        }
                    }
                    ++i;
                }
                c = JavaInfoCmd.getClassFromObj(interp, argv[lastArg]);
                if (c != null) {
                    resultListObj = JavaInfoCmd.getMethodInfoList(interp, c, statOpt, typeOpt);
                    interp.setResult(resultListObj);
                }
                return;
            }
            case 6: {
                if (argv.length != 3) {
                    throw new TclNumArgsException(interp, 2, argv, "objOrClass");
                }
                c = JavaInfoCmd.getClassFromObj(interp, argv[lastArg]);
                if (c != null) {
                    resultListObj = JavaInfoCmd.getConstructorInfoList(interp, c);
                    interp.setResult(resultListObj);
                }
                return;
            }
            case 7: {
                if (lastArg < 2 || lastArg > 3) {
                    throw new TclNumArgsException(interp, 2, argv, "?-type? objOrClass");
                }
                if (lastArg == 3) {
                    opt = TclIndex.get(interp, argv[2], JavaInfoCmd.propOpts, "option", 0);
                    typeOpt = true;
                }
                if ((c = JavaInfoCmd.getClassFromObj(interp, argv[lastArg])) != null) {
                    resultListObj = JavaInfoCmd.getPropInfoList(interp, c, typeOpt);
                    interp.setResult(resultListObj);
                }
                return;
            }
            case 8: {
                if (argv.length != 3) {
                    throw new TclNumArgsException(interp, 2, argv, "objOrClass");
                }
                c = JavaInfoCmd.getClassFromObj(interp, argv[2]);
                interp.resetResult();
                if (c != null && (c = c.getSuperclass()) != null) {
                    interp.setResult(JavaInfoCmd.getNameFromClass(c));
                }
                return;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static Class getClassFromObj(Interp interp, TclObject objOrClass) throws TclException {
        void var2_2;
        Class c;
        try {
            c = ReflectObject.getClass(interp, objOrClass);
        }
        catch (TclException e) {
            try {
                c = ClassRep.get(interp, objOrClass);
            }
            catch (TclException e2) {
                throw new TclException(interp, "unknown java class or object \"" + objOrClass + "\"");
            }
        }
        return var2_2;
    }

    private static TclObject getPropInfoList(Interp interp, Class c, boolean typeOpt) throws TclException {
        BeanInfo beaninfo;
        try {
            beaninfo = Introspector.getBeanInfo(c);
        }
        catch (IntrospectionException e) {
            throw new TclException(interp, e.toString());
        }
        PropertyDescriptor[] propDesc = null;
        propDesc = beaninfo.getPropertyDescriptors();
        TclObject resultListObj = TclList.newInstance();
        int i = 0;
        while (i < propDesc.length) {
            TclObject elementObj;
            TclObject pairObj = TclList.newInstance();
            if (typeOpt && (elementObj = TclString.newInstance(propDesc[i].getPropertyType().getName())) != null) {
                TclList.append((Interp)interp, (TclObject)pairObj, (TclObject)elementObj);
            }
            elementObj = TclString.newInstance(propDesc[i].getName());
            TclList.append((Interp)interp, (TclObject)pairObj, (TclObject)elementObj);
            TclList.append((Interp)interp, (TclObject)resultListObj, (TclObject)pairObj);
            ++i;
        }
        return resultListObj;
    }

    private static TclObject getFieldInfoList(Interp interp, Class c, boolean statOpt, boolean typeOpt) throws TclException {
        Field[] fieldArray;
        try {
            fieldArray = c.getFields();
        }
        catch (SecurityException e) {
            throw new TclException(interp, e.toString());
        }
        TclObject resultListObj = TclList.newInstance();
        int f = 0;
        while (f < fieldArray.length) {
            boolean isStatic;
            boolean bl = isStatic = (fieldArray[f].getModifiers() & 8) > 0;
            if (isStatic == statOpt) {
                TclObject sigObj = TclList.newInstance();
                String fieldName = fieldArray[f].getName();
                TclObject elementObj = TclString.newInstance(fieldName);
                TclList.append((Interp)interp, (TclObject)sigObj, (TclObject)elementObj);
                Class<?> declClass = fieldArray[f].getDeclaringClass();
                if (!declClass.equals(c)) {
                    int i = 0;
                    while (i < fieldArray.length) {
                        Class<?> tmpClass;
                        if (i != f && fieldName.equals(fieldArray[i].getName()) && declClass.isAssignableFrom(tmpClass = fieldArray[i].getDeclaringClass())) {
                            elementObj = TclString.newInstance(declClass.getName());
                            TclList.append((Interp)interp, (TclObject)sigObj, (TclObject)elementObj);
                            break;
                        }
                        ++i;
                    }
                }
                if (typeOpt) {
                    TclObject pairObj = TclList.newInstance();
                    elementObj = TclString.newInstance(JavaInfoCmd.getNameFromClass(fieldArray[f].getType()));
                    TclList.append((Interp)interp, (TclObject)pairObj, (TclObject)elementObj);
                    TclList.append((Interp)interp, (TclObject)pairObj, (TclObject)sigObj);
                    TclList.append((Interp)interp, (TclObject)resultListObj, (TclObject)pairObj);
                } else {
                    TclList.append((Interp)interp, (TclObject)resultListObj, (TclObject)sigObj);
                }
            }
            ++f;
        }
        return resultListObj;
    }

    private static TclObject getMethodInfoList(Interp interp, Class c, boolean statOpt, boolean typeOpt) throws TclException {
        Method[] methodArray;
        try {
            methodArray = c.getMethods();
        }
        catch (SecurityException e) {
            throw new TclException(interp, e.toString());
        }
        TclObject resultListObj = TclList.newInstance();
        int m = 0;
        while (m < methodArray.length) {
            boolean isStatic;
            boolean bl = isStatic = (methodArray[m].getModifiers() & 8) > 0;
            if (isStatic == statOpt) {
                TclObject sigObj = TclList.newInstance();
                TclObject elementObj = TclString.newInstance(methodArray[m].getName());
                TclList.append((Interp)interp, (TclObject)sigObj, (TclObject)elementObj);
                Class<?>[] paramArray = methodArray[m].getParameterTypes();
                int p = 0;
                while (p < paramArray.length) {
                    elementObj = TclString.newInstance(JavaInfoCmd.getNameFromClass(paramArray[p]));
                    TclList.append((Interp)interp, (TclObject)sigObj, (TclObject)elementObj);
                    ++p;
                }
                if (typeOpt) {
                    TclObject sublist = TclList.newInstance();
                    TclObject exceptions = TclList.newInstance();
                    Class<?>[] ex = methodArray[m].getExceptionTypes();
                    int i = 0;
                    while (i < ex.length) {
                        TclList.append((Interp)interp, (TclObject)exceptions, (TclObject)TclString.newInstance(ex[i].getName()));
                        ++i;
                    }
                    TclList.append((Interp)interp, (TclObject)sublist, (TclObject)TclString.newInstance(JavaInfoCmd.getNameFromClass(methodArray[m].getReturnType())));
                    TclList.append((Interp)interp, (TclObject)sublist, (TclObject)sigObj);
                    TclList.append((Interp)interp, (TclObject)sublist, (TclObject)exceptions);
                    TclList.append((Interp)interp, (TclObject)resultListObj, (TclObject)sublist);
                } else {
                    TclList.append((Interp)interp, (TclObject)resultListObj, (TclObject)sigObj);
                }
            }
            ++m;
        }
        return resultListObj;
    }

    /*
     * WARNING - void declaration
     */
    private static TclObject getConstructorInfoList(Interp interp, Class c) throws TclException {
        void var3_4;
        Constructor<?>[] constructorArray;
        try {
            constructorArray = c.getConstructors();
        }
        catch (SecurityException e) {
            throw new TclException(interp, e.toString());
        }
        TclObject resultListObj = TclList.newInstance();
        int m = 0;
        while (m < constructorArray.length) {
            TclObject sigObj = TclList.newInstance();
            TclObject elementObj = TclString.newInstance(constructorArray[m].getName());
            TclList.append((Interp)interp, (TclObject)sigObj, (TclObject)elementObj);
            Class<?>[] paramArray = constructorArray[m].getParameterTypes();
            int p = 0;
            while (p < paramArray.length) {
                elementObj = TclString.newInstance(JavaInfoCmd.getNameFromClass(paramArray[p]));
                TclList.append((Interp)interp, (TclObject)sigObj, (TclObject)elementObj);
                ++p;
            }
            TclList.append((Interp)interp, (TclObject)resultListObj, (TclObject)sigObj);
            ++m;
        }
        return var3_4;
    }

    /*
     * WARNING - void declaration
     */
    static int getNumDimsFromClass(Class type) {
        void var1_1;
        int dim = 0;
        while (type.isArray()) {
            type = type.getComponentType();
            ++dim;
        }
        return (int)var1_1;
    }

    static String getNameFromClass(Class type) {
        StringBuffer name = new StringBuffer();
        while (type.isArray()) {
            name.append("[]");
            type = type.getComponentType();
        }
        name.insert(0, type.getName());
        return name.toString();
    }

    private static String getBaseNameFromClass(Class type) {
        while (type.isArray()) {
            type = type.getComponentType();
        }
        return type.getName();
    }

    JavaInfoCmd() {
    }
}

