/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;

class RegsubCmd
implements Command {
    private static final String[] validCmds = new String[]{"-all", "-nocase", "--"};
    private static final int OPT_ALL = 0;
    private static final int OPT_NOCASE = 1;
    private static final int OPT_LAST = 2;

    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        Class<?> cmdClass = null;
        Command cmd = null;
        try {
            cmdClass = Class.forName("tcl.regex.OroRegsubCmd");
        }
        catch (ClassNotFoundException classNotFoundException) {
            RegsubCmd.stubCmdProc(interp, argv);
            return;
        }
        try {
            cmd = (Command)cmdClass.newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new TclException(interp, "IllegalAccessException for class \"" + cmdClass.getName() + "\"");
        }
        catch (InstantiationException instantiationException) {
            throw new TclException(interp, "InstantiationException for class \"" + cmdClass.getName() + "\"");
        }
        catch (ClassCastException classCastException) {
            throw new TclException(interp, "ClassCastException for class \"" + cmdClass.getName() + "\"");
        }
        interp.createCommand("regsub", cmd);
        cmd.cmdProc(interp, argv);
    }

    private static void stubCmdProc(Interp interp, TclObject[] argv) throws TclException {
        String string;
        String pattern;
        int objc = argv.length - 1;
        boolean noCase = false;
        boolean all = false;
        boolean last = false;
        if (argv.length < 3) {
            throw new TclNumArgsException(interp, 1, argv, "?switches? exp string subSpec varName");
        }
        int currentObjIndex = 1;
        while (objc > 0 && !last) {
            if (!argv[currentObjIndex].toString().startsWith("-")) break;
            int opt = TclIndex.get((Interp)interp, (TclObject)argv[currentObjIndex], (String[])validCmds, (String)"switch", (int)1);
            switch (opt) {
                case 0: {
                    all = true;
                    break;
                }
                case 1: {
                    noCase = true;
                    break;
                }
                case 2: {
                    last = true;
                    break;
                }
                default: {
                    throw new TclException(interp, "RegsubCmd.cmdProc: bad option " + opt + " index to cmds");
                }
            }
            ++currentObjIndex;
            --objc;
        }
        if (objc != 4) {
            throw new TclNumArgsException(interp, 1, argv, "?switches? exp string subSpec varName");
        }
        int stringObjIndex = currentObjIndex + 1;
        int matchIndex = stringObjIndex + 1;
        if (noCase) {
            pattern = argv[currentObjIndex].toString().toLowerCase();
            string = argv[stringObjIndex].toString().toLowerCase();
        } else {
            pattern = argv[currentObjIndex].toString();
            string = argv[stringObjIndex].toString();
        }
        String subSpec = argv[stringObjIndex + 1].toString();
        String varName = argv[stringObjIndex + 2].toString();
        throw new TclException(interp, "Can't execute regsub \"" + pattern + " " + string + " " + subSpec + " " + varName + "\": not yet implemented");
    }

    RegsubCmd() {
    }
}

