/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.io.File;
import tcl.lang.Interp;
import tcl.lang.JACL;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.TclString;

class FileUtil {
    static final int PATH_RELATIVE = 0;
    static final int PATH_VOLUME_RELATIVE = 1;
    static final int PATH_ABSOLUTE = 2;

    private static int getWinHomePath(String path, boolean stopEarly, StringBuffer absBuf) {
        int pIndex = 0;
        while (pIndex < path.length()) {
            if (path.charAt(pIndex) != '/') break;
            ++pIndex;
        }
        if (pIndex < 2) {
            absBuf.setLength(0);
            return 0;
        }
        int firstNonSlash = pIndex;
        while (pIndex < path.length()) {
            if (path.charAt(pIndex) == '/') break;
            ++pIndex;
        }
        if (pIndex == firstNonSlash) {
            absBuf.setLength(0);
            return 0;
        }
        absBuf.ensureCapacity(absBuf.length() + path.length());
        absBuf.append("//");
        absBuf.append(path.substring(firstNonSlash, pIndex));
        int oldIndex = pIndex;
        while (pIndex < path.length()) {
            if (path.charAt(pIndex) != '/') {
                if (pIndex == oldIndex) {
                    absBuf.setLength(0);
                    return 0;
                }
                if (stopEarly) {
                    absBuf.setLength(0);
                    return firstNonSlash;
                }
                firstNonSlash = pIndex++;
                while (pIndex < path.length()) {
                    if (path.charAt(pIndex) == '/') break;
                    ++pIndex;
                }
                absBuf.append('/');
                absBuf.append(path.substring(firstNonSlash, pIndex));
                return pIndex;
            }
            ++pIndex;
        }
        absBuf.setLength(0);
        return 0;
    }

    private static int beginsWithLetterColon(String path) {
        if (path.length() > 1 && Character.isLetter(path.charAt(0)) && path.charAt(1) == ':') {
            int pIndex = 2;
            while (pIndex < path.length()) {
                if (path.charAt(pIndex) != '/') break;
                ++pIndex;
            }
            return pIndex;
        }
        return 0;
    }

    private static int getWinAbsPath(String path, StringBuffer absBuf) {
        absBuf.setLength(0);
        if (path.length() < 1) {
            return 0;
        }
        absBuf.ensureCapacity(absBuf.length() + path.length());
        int colonIndex = FileUtil.beginsWithLetterColon(path);
        if (colonIndex > 0) {
            if (colonIndex > 2) {
                absBuf.append(path.substring(0, 3));
            } else {
                absBuf.append(path.substring(0, 2));
            }
            return colonIndex;
        }
        int absIndex = FileUtil.getWinHomePath(path, false, absBuf);
        if (absIndex > 0) {
            return absIndex;
        }
        if (path.charAt(0) == '/') {
            int pIndex = 1;
            while (pIndex < path.length()) {
                if (path.charAt(pIndex) != '/') break;
                ++pIndex;
            }
            absBuf.append("/");
            return pIndex;
        }
        return 0;
    }

    /*
     * Unable to fully structure code
     */
    private static int getDegenerateUnixPath(String path) {
        pIndex = 0;
        while (pIndex < path.length() && path.charAt(pIndex) == '/') {
            ++pIndex;
        }
        if (pIndex != 0) ** GOTO lbl16
        return 0;
lbl-1000:
        // 1 sources

        {
            tmpPath = path.substring(pIndex);
            if (tmpPath.startsWith("./")) {
                pIndex += 2;
            } else {
                if (!tmpPath.startsWith("../")) break;
                pIndex += 3;
            }
            while (pIndex < path.length() && path.charAt(pIndex) == '/') {
                ++pIndex;
            }
lbl16:
            // 2 sources

            ** while (pIndex < path.length())
        }
lbl17:
        // 2 sources

        lastSlashIndex = pIndex;
        if (pIndex < path.length() && path.charAt(pIndex) == '.') {
            ++pIndex;
        }
        if (pIndex < path.length() && path.charAt(pIndex) == '.') {
            ++pIndex;
        }
        return pIndex;
    }

    static int getPathType(String path) {
        if (path.length() < 1) {
            return 0;
        }
        switch (JACL.PLATFORM) {
            case 1: {
                path = path.replace('\\', '/');
                char c = path.charAt(0);
                if (c == '~') {
                    return 2;
                }
                if (c == '/') {
                    StringBuffer absBuf = new StringBuffer(0);
                    if (FileUtil.getWinHomePath(path, true, absBuf) > 0) {
                        return 2;
                    }
                    return 1;
                }
                int colonIndex = FileUtil.beginsWithLetterColon(path);
                if (colonIndex > 0) {
                    if (colonIndex > 2) {
                        return 2;
                    }
                    return 1;
                }
                return 0;
            }
            case 2: {
                if (path.charAt(0) == '~') {
                    return 2;
                }
                switch (path.indexOf(58)) {
                    case -1: {
                        if (path.charAt(0) != '/' || FileUtil.getDegenerateUnixPath(path) >= path.length()) break;
                        return 2;
                    }
                    case 0: {
                        return 0;
                    }
                    default: {
                        return 2;
                    }
                }
                return 0;
            }
        }
        char c = path.charAt(0);
        if (c == '/' || c == '~') {
            return 2;
        }
        return 0;
    }

    static File getNewFileObj(Interp interp, String fileName) throws TclException {
        File f = FileUtil.getPathType(fileName = FileUtil.translateFileName(interp, fileName)) == 2 ? new File(fileName) : new File(interp.getWorkingDir(), fileName);
        return f;
    }

    private static void appendComponent(String component, int compIndex, int compSize, StringBuffer buf) {
        while (compIndex < component.length()) {
            char c = component.charAt(compIndex);
            if (c == '/') {
                while (compIndex < compSize && component.charAt(compIndex + 1) == '/') {
                    ++compIndex;
                }
                if (compIndex < compSize) {
                    buf.ensureCapacity(buf.length() + 1);
                    buf.append('/');
                }
            } else {
                buf.ensureCapacity(buf.length() + 1);
                buf.append(c);
            }
            ++compIndex;
        }
    }

    /*
     * Unable to fully structure code
     */
    static String joinPath(Interp interp, TclObject[] argv, int startIndex, int endIndex) throws TclException {
        result = new StringBuffer(10);
        switch (JACL.PLATFORM) {
            case 1: {
                i = startIndex;
                while (i < endIndex) {
                    p = argv[i].toString().replace('\\', '/');
                    pIndex = 0;
                    pLastIndex = p.length() - 1;
                    if (p.length() != 0) {
                        absBuf = new StringBuffer(0);
                        pIndex = FileUtil.getWinAbsPath(p, absBuf);
                        if (pIndex > 0) {
                            result = absBuf;
                        } else if (p.charAt(0) == '~') {
                            result.setLength(0);
                        } else {
                            if (result.length() != 0 && p.regionMatches(pIndex, "./~", 0, 3)) {
                                pIndex = 2;
                            }
                            if (result.length() != 0 && (c = result.charAt(result.length() - 1)) != '/' && c != ':') {
                                result.ensureCapacity(result.length() + 1);
                                result.append('/');
                            }
                        }
                        FileUtil.appendComponent(p, pIndex, pLastIndex, result);
                        pIndex = p.length();
                    }
                    ++i;
                }
                return result.toString();
            }
            case 2: {
                needsSep = true;
                i = startIndex;
                while (i < endIndex) {
                    splitArrayObj = TclList.getElements(interp, FileUtil.splitPath(interp, argv[i].toString()));
                    if (splitArrayObj.length == 0) ** GOTO lbl64
                    start = 0;
                    p = splitArrayObj[0].toString();
                    if (p.charAt(0) != ':' && p.indexOf(58) != -1) {
                        result.setLength(0);
                        result.append(p);
                        needsSep = false;
                    }
                    j = ++start;
                    while (j < splitArrayObj.length) {
                        p = splitArrayObj[j].toString();
                        if (!p.equals(":")) ** GOTO lbl49
                        if (result.length() != 0) ** GOTO lbl62
                        needsSep = false;
                        ** GOTO lbl60
lbl49:
                        // 1 sources

                        c = 111;
                        if (p.length() > 1) {
                            c = p.charAt(1);
                        }
                        if (p.charAt(0) == ':') {
                            if (!needsSep) {
                                p = p.substring(1);
                            }
                        } else if (needsSep) {
                            result.append(':');
                        }
                        needsSep = c != 58;
lbl60:
                        // 2 sources

                        result.append(p);
lbl62:
                        // 2 sources

                        ++j;
                    }
lbl64:
                    // 2 sources

                    ++i;
                }
                return result.toString();
            }
        }
        i = startIndex;
        while (i < endIndex) {
            p = argv[i].toString();
            pIndex = 0;
            pLastIndex = p.length() - 1;
            if (p.length() != 0) {
                if (p.charAt(pIndex) == '/') {
                    while (pIndex <= pLastIndex && p.charAt(pIndex) == '/') {
                        ++pIndex;
                    }
                    result.setLength(0);
                    result.append('/');
                } else if (p.charAt(pIndex) == '~') {
                    result.setLength(0);
                } else {
                    if (result.length() != 0 && p.regionMatches(pIndex, "./~", 0, 3)) {
                        pIndex += 2;
                    }
                    if (result.length() != 0 && result.charAt(result.length() - 1) != '/') {
                        result.ensureCapacity(result.length() + 1);
                        result.append('/');
                    }
                }
                FileUtil.appendComponent(p, pIndex, pLastIndex, result);
                pIndex = p.length();
            }
            ++i;
        }
        return result.toString();
    }

    static TclObject splitPath(Interp interp, String path) throws TclException {
        TclObject componentObj;
        String tmpPath;
        TclObject resultListObj = TclList.newInstance();
        String component = "";
        boolean foundComponent = false;
        boolean convertDotToColon = false;
        boolean isColonSeparator = false;
        boolean appendColon = false;
        boolean prependColon = false;
        String thisDir = "./";
        if (path.length() == 0) {
            return resultListObj;
        }
        block0 : switch (JACL.PLATFORM) {
            case 1: {
                tmpPath = path.replace('\\', '/');
                StringBuffer absBuf = new StringBuffer(0);
                int absIndex = FileUtil.getWinAbsPath(tmpPath, absBuf);
                if (absIndex <= 0) break;
                componentObj = TclString.newInstance((String)absBuf.toString());
                TclList.append(interp, resultListObj, componentObj);
                tmpPath = tmpPath.substring(absIndex);
                foundComponent = true;
                break;
            }
            case 2: {
                tmpPath = "";
                thisDir = ":";
                switch (path.indexOf(58)) {
                    case -1: {
                        if (path.charAt(0) != '/') {
                            tmpPath = path;
                            convertDotToColon = true;
                            if (path.charAt(0) != '~') break block0;
                            appendColon = true;
                            break;
                        }
                        int degenIndex = FileUtil.getDegenerateUnixPath(path);
                        if (degenIndex < path.length()) {
                            tmpPath = path.substring(degenIndex);
                            convertDotToColon = true;
                            appendColon = true;
                            break;
                        }
                        TclObject componentObj2 = TclString.newInstance((String)(":" + path));
                        TclList.append(interp, resultListObj, componentObj2);
                        return resultListObj;
                    }
                    case 0: {
                        if (path.length() == 1) {
                            TclObject componentObj3 = TclString.newInstance((String)":");
                            TclList.append(interp, resultListObj, componentObj3);
                            return resultListObj;
                        }
                        tmpPath = path.substring(1);
                        foundComponent = true;
                        prependColon = true;
                        isColonSeparator = true;
                        break;
                    }
                    default: {
                        tmpPath = path;
                        appendColon = true;
                        prependColon = true;
                        isColonSeparator = true;
                        break;
                    }
                }
                break;
            }
            default: {
                if (path.charAt(0) == '/') {
                    componentObj = TclString.newInstance((String)"/");
                    TclList.append(interp, resultListObj, componentObj);
                    tmpPath = path.substring(1);
                    foundComponent = true;
                    break;
                }
                tmpPath = path;
            }
        }
        int sIndex = 0;
        while (sIndex != -1) {
            if (isColonSeparator) {
                sIndex = tmpPath.indexOf(":");
                if (sIndex == 0) {
                    componentObj = TclString.newInstance((String)"::");
                    TclList.append(interp, resultListObj, componentObj);
                    foundComponent = true;
                    tmpPath = tmpPath.substring(sIndex + 1);
                    continue;
                }
            } else {
                sIndex = tmpPath.indexOf("/");
                if (sIndex == 0) {
                    tmpPath = tmpPath.substring(sIndex + 1);
                    continue;
                }
            }
            if (sIndex == -1) {
                if (tmpPath.length() == 0) break;
                component = tmpPath;
            } else {
                component = tmpPath.substring(0, sIndex);
            }
            if (convertDotToColon && (component.equals(".") || component.equals(".."))) {
                component = component.replace('.', ':');
            }
            if (foundComponent) {
                if (component.charAt(0) == '~') {
                    component = String.valueOf(thisDir) + component;
                } else if (prependColon) {
                    if (tmpPath.indexOf(47) == -1) {
                        prependColon = false;
                    } else {
                        component = ":" + component;
                    }
                }
            } else if (appendColon) {
                component = String.valueOf(component) + ":";
            }
            componentObj = TclString.newInstance((String)component);
            TclList.append(interp, resultListObj, componentObj);
            foundComponent = true;
            tmpPath = tmpPath.substring(sIndex + 1);
        }
        return resultListObj;
    }

    static String doTildeSubst(Interp interp, String user) throws TclException {
        if (user.length() == 0) {
            String dir;
            try {
                dir = interp.getVar("env", "HOME", 0).toString();
            }
            catch (Exception exception) {
                throw new TclException(interp, "couldn't find HOME environment variable to expand path");
            }
            return dir;
        }
        String dir = null;
        if (dir == null) {
            throw new TclException(interp, "user \"" + user + "\" doesn't exist");
        }
        return dir;
    }

    static String translateFileName(Interp interp, String path) throws TclException {
        String fileName = "";
        if (path.length() == 0 || path.charAt(0) != '~') {
            TclObject[] joinArrayObj = new TclObject[]{TclString.newInstance((String)path)};
            fileName = FileUtil.joinPath(interp, joinArrayObj, 0, 1);
        } else {
            TclObject[] splitArrayObj = TclList.getElements(interp, FileUtil.splitPath(interp, path));
            String user = splitArrayObj[0].toString().substring(1);
            if (JACL.PLATFORM == 2 && user.endsWith(":")) {
                user = user.substring(0, user.length() - 1);
            }
            user = FileUtil.doTildeSubst(interp, user);
            splitArrayObj[0] = TclString.newInstance((String)user);
            fileName = FileUtil.joinPath(interp, splitArrayObj, 0, splitArrayObj.length);
        }
        if (JACL.PLATFORM == 1) {
            fileName = fileName.replace('/', '\\');
        }
        return fileName;
    }

    static TclObject splitAndTranslate(Interp interp, String path) throws TclException {
        String fileName;
        TclObject splitResult = FileUtil.splitPath(interp, path);
        int len = TclList.getLength(interp, splitResult);
        if (len == 1 && (fileName = TclList.index(interp, splitResult, 0).toString()).charAt(0) == '~') {
            String user = FileUtil.translateFileName(interp, fileName);
            splitResult = FileUtil.splitPath(interp, user);
        }
        return splitResult;
    }

    FileUtil() {
    }
}

