/*
 * Decompiled with CFR 0.152.
 */
package tcl.bean;

import com.sun.jpro.vj.designtime.VJCustomizerPage;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Container;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import tcl.bean.StudioTclInterp;
import tcl.bean.StudioTclPort;
import tcl.lang.Interp;
import tcl.lang.TclException;

class VJInterpPage
extends VJCustomizerPage
implements ActionListener {
    private StudioTclInterp studioInterp;
    private String beanScript;
    private static String lastDirName = null;
    private TextField scriptInput;
    private TextArea scriptText;
    private Label scriptLabel;
    private Choice scriptChoice;
    private GridBagLayout gbl;
    private GridBagConstraints gbc;

    public void initPage(Object obj) {
        this.studioInterp = (StudioTclInterp)((Object)obj);
        Label fileLabel = new Label("File:");
        this.scriptInput = new TextField(20);
        this.scriptInput.addActionListener(this);
        Button browseButton = new Button("Browse");
        browseButton.addActionListener(new 1());
        this.scriptChoice = new Choice();
        this.scriptChoice.add("None");
        this.scriptChoice.add("choiceValue.tcl");
        this.scriptChoice.add("distrib.tcl");
        this.scriptChoice.add("eval.tcl");
        this.scriptChoice.add("exec.tcl");
        this.scriptChoice.add("inspect.tcl");
        this.scriptChoice.add("memory.tcl");
        this.scriptChoice.add("switch.tcl");
        this.scriptChoice.add("customDistrib.tcl");
        this.scriptChoice.add("customMemory.tcl");
        this.scriptChoice.add("customSwitch.tcl");
        this.scriptChoice.addItemListener(new 2());
        this.gbl = new GridBagLayout();
        this.gbc = new GridBagConstraints();
        this.gbc.anchor = 11;
        this.gbc.ipadx = 5;
        this.gbc.ipady = 5;
        this.setInsets(new Insets(10, 10, 10, 10));
        ((Container)((Object)this)).setLayout(this.gbl);
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.gridwidth = 1;
        this.gbc.gridheight = 1;
        this.gbc.weightx = 0.0;
        this.gbc.weighty = 0.0;
        this.gbc.fill = 0;
        this.gbl.setConstraints(fileLabel, this.gbc);
        ((Container)((Object)this)).add(fileLabel);
        this.gbc.gridx = 1;
        this.gbc.gridy = 0;
        this.gbc.gridwidth = 1;
        this.gbc.gridheight = 1;
        this.gbc.weightx = 1.0;
        this.gbc.weighty = 0.0;
        this.gbc.fill = 2;
        this.gbl.setConstraints(this.scriptInput, this.gbc);
        ((Container)((Object)this)).add(this.scriptInput);
        Panel padding = new Panel();
        this.gbc.gridx = 2;
        this.gbc.gridy = 0;
        this.gbc.gridwidth = 1;
        this.gbc.gridheight = 1;
        this.gbc.weightx = 0.0;
        this.gbc.weighty = 0.0;
        this.gbc.fill = 0;
        this.gbl.setConstraints(padding, this.gbc);
        ((Container)((Object)this)).add(padding);
        this.gbc.gridx = 3;
        this.gbc.gridy = 0;
        this.gbc.gridwidth = 1;
        this.gbc.gridheight = 1;
        this.gbc.weightx = 0.0;
        this.gbc.weighty = 0.0;
        this.gbc.fill = 0;
        this.gbl.setConstraints(browseButton, this.gbc);
        ((Container)((Object)this)).add(browseButton);
        padding = new Panel();
        this.gbc.gridx = 4;
        this.gbc.gridy = 0;
        this.gbc.gridwidth = 1;
        this.gbc.gridheight = 1;
        this.gbc.weightx = 0.0;
        this.gbc.weighty = 0.0;
        this.gbc.fill = 0;
        this.gbl.setConstraints(padding, this.gbc);
        ((Container)((Object)this)).add(padding);
        this.gbc.gridx = 5;
        this.gbc.gridy = 0;
        this.gbc.gridwidth = 1;
        this.gbc.gridheight = 1;
        this.gbc.weightx = 0.0;
        this.gbc.weighty = 0.0;
        this.gbc.fill = 0;
        this.gbl.setConstraints(this.scriptChoice, this.gbc);
        ((Container)((Object)this)).add(this.scriptChoice);
        padding = new Panel();
        this.gbc.gridx = 0;
        this.gbc.gridy = 1;
        this.gbc.gridwidth = 0;
        this.gbc.gridheight = 1;
        this.gbc.weightx = 1.0;
        this.gbc.weighty = 0.0;
        this.gbc.fill = 2;
        this.gbl.setConstraints(padding, this.gbc);
        ((Container)((Object)this)).add(padding);
        if (this.studioInterp.customExists()) {
            this.paintCustomPanel();
        } else {
            this.paintDefaultPanel();
        }
    }

    void paintCustomPanel() {
        try {
            this.studioInterp.evalCustom();
        }
        catch (TclException tclException) {
            this.studioInterp.invalidateCustom();
            return;
        }
        this.gbc.gridx = 0;
        this.gbc.gridy = 2;
        this.gbc.gridwidth = 0;
        this.gbc.gridheight = 0;
        this.gbc.weightx = 1.0;
        this.gbc.weighty = 1.0;
        this.gbc.fill = 1;
        this.gbl.setConstraints(this.studioInterp.getCustomPanel(), this.gbc);
        ((Container)((Object)this)).add(this.studioInterp.getCustomPanel());
        this.studioInterp.setCustomShowing(true);
    }

    public void paintDefaultPanel() {
        this.scriptLabel = new Label("Script:");
        this.scriptText = new TextArea("", 10, 50);
        this.scriptText.setText(this.studioInterp.getScript());
        this.studioInterp.setCustomShowing(false);
        this.gbc.gridx = 0;
        this.gbc.gridy = 2;
        this.gbc.gridwidth = 1;
        this.gbc.gridheight = 1;
        this.gbc.weightx = 0.0;
        this.gbc.weighty = 0.0;
        this.gbc.fill = 0;
        this.gbl.setConstraints(this.scriptLabel, this.gbc);
        ((Container)((Object)this)).add(this.scriptLabel);
        this.gbc.gridx = 1;
        this.gbc.gridy = 2;
        this.gbc.gridwidth = 0;
        this.gbc.gridheight = 0;
        this.gbc.weightx = 1.0;
        this.gbc.weighty = 1.0;
        this.gbc.fill = 1;
        this.gbl.setConstraints(this.scriptText, this.gbc);
        ((Container)((Object)this)).add(this.scriptText);
    }

    public void commitPage() {
        boolean length = false;
        Vector newVec = null;
        try {
            StudioTclPort indexPort;
            Enumeration e;
            if (this.beanScript != null) {
                this.studioInterp.setScript(this.beanScript);
            }
            Interp interp = this.studioInterp.resetInterp();
            if (this.studioInterp.customShowing()) {
                this.studioInterp.evalCustomCallback(interp);
                this.studioInterp.setCustomExists(true);
            } else {
                this.studioInterp.setCustomExists(false);
                this.studioInterp.setScript(this.scriptText.getText());
            }
            try {
                interp.eval(this.studioInterp.getScript(), 1);
            }
            catch (TclException tclException) {
                StudioTclInterp.printError(interp.getResult());
                return;
            }
            if (this.studioInterp.pendingVec == null) {
                newVec = new Vector();
            } else {
                newVec = this.studioInterp.pendingVec;
                this.studioInterp.pendingVec = null;
            }
            if (this.studioInterp.reuseVec != null) {
                e = this.studioInterp.reuseVec.elements();
                while (e.hasMoreElements()) {
                    StudioTclPort oldPort = (StudioTclPort)e.nextElement();
                    this.studioInterp.currentVec.removeElement(oldPort);
                }
                this.studioInterp.reuseVec = null;
            }
            if (this.studioInterp.currentVec != null) {
                try {
                    e = this.studioInterp.currentVec.elements();
                    while (e.hasMoreElements()) {
                        StudioTclPort diePort = (StudioTclPort)e.nextElement();
                        this.studioInterp.removeDynamicPort(diePort.port);
                    }
                }
                catch (Exception e2) {
                    StudioTclInterp.printError("   remove error" + e2);
                }
            }
            e = newVec.elements();
            while (e.hasMoreElements()) {
                StudioTclPort newPort = (StudioTclPort)e.nextElement();
                if (newPort == null) {
                    StudioTclInterp.printError("   damn");
                }
                if (newPort.added) continue;
                if (newPort.port == null) {
                    StudioTclInterp.printError("   really!!");
                }
                this.studioInterp.addDynamicPort(newPort.port);
                newPort.added = true;
            }
            this.studioInterp.currentVec = newVec;
            int max = -1;
            Enumeration e3 = this.studioInterp.currentVec.elements();
            while (e3.hasMoreElements()) {
                indexPort = (StudioTclPort)e3.nextElement();
                indexPort.initWithInterp(interp);
                int index = indexPort.port.getIndex();
                if (index <= max) continue;
                max = index;
            }
            this.studioInterp.indexLookup = new StudioTclPort[max + 1];
            Enumeration e4 = this.studioInterp.currentVec.elements();
            while (e4.hasMoreElements()) {
                this.studioInterp.indexLookup[indexPort.port.getIndex()] = indexPort = (StudioTclPort)e4.nextElement();
            }
        }
        catch (Exception e) {
            StudioTclInterp.printError(e);
            e.printStackTrace();
        }
    }

    public void loadScriptFile() {
        String customScript = null;
        InputStream in = null;
        this.beanScript = null;
        String src = this.scriptInput.getText();
        File sourceFile = new File(src);
        if (!sourceFile.isAbsolute()) {
            URL url = null;
            try {
                url = this.getClass().getResource("scripts/" + src);
                in = url.openStream();
            }
            catch (Exception exception) {}
        }
        if (in == null) {
            try {
                FileInputStream fs = new FileInputStream(sourceFile);
                in = fs;
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (SecurityException securityException) {}
        }
        if (in != null) {
            try {
                try {
                    int available = in.available();
                    int read = 0;
                    byte[] charArray = new byte[available];
                    read = in.read(charArray);
                    while (read < available) {
                        read += in.read(charArray, read, available - read);
                    }
                    this.beanScript = new String(charArray);
                }
                catch (IOException iOException) {
                }
                Object var8_11 = null;
            }
            catch (Throwable throwable) {
                Object var8_12 = null;
                try {
                    in.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        if (this.beanScript == null) {
            this.beanScript = "script file not found...";
        }
        if (this.beanScript.startsWith("#CUSTOM_BEGIN")) {
            int index = this.beanScript.indexOf("#CUSTOM_END");
            if (index < 0) {
                customScript = this.beanScript;
                this.beanScript = "";
            } else {
                customScript = this.beanScript.substring(0, index);
                this.beanScript = this.beanScript.substring(index);
            }
        }
        this.repaintCustomizer(customScript, this.beanScript);
    }

    void repaintCustomizer(String customScript, String beanScript) {
        if (this.studioInterp.customShowing()) {
            ((Container)((Object)this)).remove(this.studioInterp.getCustomPanel());
            this.studioInterp.invalidateCustom();
        } else {
            if (this.scriptLabel != null) {
                ((Container)((Object)this)).remove(this.scriptLabel);
            }
            if (this.scriptText != null) {
                ((Container)((Object)this)).remove(this.scriptText);
            }
        }
        if (customScript != null) {
            this.studioInterp.initCustom(customScript);
            this.paintCustomPanel();
        } else {
            this.paintDefaultPanel();
            this.scriptText.setText(beanScript);
        }
        ((Container)((Object)this)).validate();
    }

    public void actionPerformed(ActionEvent action) {
        this.loadScriptFile();
    }

    public void showFileDialog() {
        FileDialog fd = new FileDialog(new Frame(), "Select a script file.");
        if (lastDirName != null) {
            fd.setDirectory(lastDirName);
        }
        fd.show();
        String dir = fd.getDirectory();
        String file = fd.getFile();
        if (dir != null && file != null && !file.equals("")) {
            lastDirName = dir;
            ((TextComponent)this.scriptInput).setText(String.valueOf(dir) + file);
            this.loadScriptFile();
        }
    }

    private final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent event) {
            VJInterpPage.this.showFileDialog();
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    implements ItemListener {
        public void itemStateChanged(ItemEvent event) {
            if (VJInterpPage.this.scriptChoice.getSelectedItem().equals("None")) {
                VJInterpPage.this.repaintCustomizer(null, "");
                return;
            }
            ((TextComponent)VJInterpPage.this.scriptInput).setText(VJInterpPage.this.scriptChoice.getSelectedItem());
            VJInterpPage.this.loadScriptFile();
        }

        /* synthetic */ 2() {
        }
    }
}

