/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.lang.reflect.Array;
import tcl.lang.FuncSig;
import tcl.lang.Interp;
import tcl.lang.JavaInfoCmd;
import tcl.lang.JavaInvoke;
import tcl.lang.ReflectException;
import tcl.lang.ReflectObject;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;

class ArrayObject
extends ReflectObject {
    private static final String[] validCmds = new String[]{"length", "get", "getrange", "set", "setrange"};
    private static final int OPT_LENGTH = 0;
    private static final int OPT_GET = 1;
    private static final int OPT_GETRANGE = 2;
    private static final int OPT_SET = 3;
    private static final int OPT_SETRANGE = 4;

    public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
        int n;
        int n2;
        int n3;
        boolean bl;
        if (tclObjectArray.length < 2) {
            throw new TclNumArgsException(interp, 1, tclObjectArray, "?-noconvert? option ?arg arg ...?");
        }
        String string = tclObjectArray[1].toString();
        if (string.length() >= 2 && "-noconvert".startsWith(string)) {
            bl = false;
            n3 = 2;
            n2 = tclObjectArray.length - 3;
        } else {
            bl = true;
            n3 = 1;
            n2 = tclObjectArray.length - 2;
        }
        if (n2 < 0) {
            throw new TclNumArgsException(interp, 1, tclObjectArray, "?-noconvert? option ?arg arg ...?");
        }
        try {
            n = TclIndex.get(interp, tclObjectArray[n3], validCmds, "option", 1);
        }
        catch (TclException tclException) {
            try {
                int n4 = n3 + 1;
                FuncSig.get(interp, this.javaObj.getClass(), tclObjectArray[n3], tclObjectArray, n4, tclObjectArray.length - n4);
            }
            catch (TclException tclException2) {
                throw new TclException(interp, "bad option \"" + tclObjectArray[n3] + "\": must be length, get, getrange, " + "set, setrange, or a valid method signature");
            }
            super.cmdProc(interp, tclObjectArray);
            return;
        }
        switch (n) {
            case 0: {
                if (n2 != 0) {
                    throw new TclNumArgsException(interp, n3 + 1, tclObjectArray, "");
                }
                if (!bl) {
                    throw new TclException(interp, "-noconvert flag not allowed for the \"length\" sub-command");
                }
                int n5 = Array.getLength(this.javaObj);
                interp.setResult(TclInteger.newInstance(n5));
                return;
            }
            case 1: {
                int n6;
                Object object;
                if (n2 != 1) {
                    throw new TclNumArgsException(interp, n3 + 1, tclObjectArray, "indexList");
                }
                TclObject tclObject = tclObjectArray[n3 + 1];
                int n7 = TclList.getLength(interp, tclObject);
                if (n7 == 0) {
                    object = this.javaObj;
                    n6 = 0;
                } else {
                    object = ArrayObject.dereferenceArrayDims(interp, this.javaObj, n7, tclObject);
                    n6 = TclInteger.get(interp, TclList.index(interp, tclObject, n7 - 1));
                }
                interp.setResult(ArrayObject.getArrayElt(interp, object, n6, bl));
                return;
            }
            case 3: {
                int n8;
                Object object;
                if (n2 != 2) {
                    throw new TclNumArgsException(interp, n3 + 1, tclObjectArray, "indexList value");
                }
                if (!bl) {
                    throw new TclException(interp, "-noconvert flag not allowed for the \"set\" sub-command");
                }
                TclObject tclObject = tclObjectArray[n3 + 1];
                int n9 = TclList.getLength(interp, tclObject);
                if (n9 == 0) {
                    object = this.javaObj;
                    n8 = 0;
                } else {
                    object = ArrayObject.dereferenceArrayDims(interp, this.javaObj, n9, tclObject);
                    n8 = TclInteger.get(interp, TclList.index(interp, tclObject, n9 - 1));
                }
                ArrayObject.setArrayElt(interp, object, n8, tclObjectArray[n3 + 2]);
                interp.resetResult();
                return;
            }
            case 2: {
                TclObject tclObject;
                int n10;
                if (n2 > 2) {
                    throw new TclNumArgsException(interp, n3 + 1, tclObjectArray, "?indexList ?count??");
                }
                Object object = this.javaObj;
                int n11 = 0;
                if (n2 > 0 && (n10 = TclList.getLength(interp, tclObject = tclObjectArray[n3 + 1])) > 0) {
                    object = ArrayObject.dereferenceArrayDims(interp, this.javaObj, n10, tclObject);
                    n11 = TclInteger.get(interp, TclList.index(interp, tclObject, n10 - 1));
                }
                int n12 = Array.getLength(object) - n11;
                if (n2 > 1) {
                    n12 = Math.min(n12, TclInteger.get(interp, tclObjectArray[n3 + 2]));
                }
                interp.setResult(ArrayObject.getArrayElts(interp, object, n11, n12, bl));
                return;
            }
            case 4: {
                TclObject tclObject;
                int n13;
                if (n2 < 1 || n2 > 3) {
                    throw new TclNumArgsException(interp, n3 + 1, tclObjectArray, "?indexList ?count?? valueList");
                }
                if (!bl) {
                    throw new TclException(interp, "-noconvert flag not allowed for the \"setrange\" sub-command");
                }
                TclObject tclObject2 = tclObjectArray[tclObjectArray.length - 1];
                Object object = this.javaObj;
                int n14 = 0;
                if (n2 > 1 && (n13 = TclList.getLength(interp, tclObject = tclObjectArray[n3 + 1])) > 0) {
                    object = ArrayObject.dereferenceArrayDims(interp, this.javaObj, n13, tclObject);
                    n14 = TclInteger.get(interp, TclList.index(interp, tclObject, n13 - 1));
                }
                int n15 = Math.min(TclList.getLength(interp, tclObject2), Array.getLength(object) - n14);
                if (n2 > 2) {
                    n15 = Math.min(n15, TclInteger.get(interp, tclObjectArray[n3 + 2]));
                }
                ArrayObject.setArrayElts(interp, object, n14, n15, tclObject2);
                interp.resetResult();
                return;
            }
        }
    }

    static Object initArray(Interp interp, TclObject tclObject, int n, int n2, int n3, Class clazz, TclObject tclObject2) throws TclException {
        Object object;
        int n4;
        Class<?> clazz2 = clazz.getComponentType();
        int n5 = 0;
        if (tclObject2 != null) {
            n5 = TclList.getLength(interp, tclObject2);
        }
        if ((n4 = n2 < n ? TclInteger.get(interp, TclList.index(interp, tclObject, n2)) : n5) == 0 && n2 < n3 - 1) {
            throw new TclException(interp, "cannot initialize a " + n3 + " dimensional array with zero size in dimension " + n2);
        }
        try {
            object = Array.newInstance(clazz2, n4);
        }
        catch (Exception exception) {
            throw new ReflectException(interp, (Throwable)exception);
        }
        if (clazz2.isArray()) {
            int n6 = n2 + 1;
            int n7 = 0;
            while (n7 < n4) {
                TclObject tclObject3 = null;
                if (n7 < n5) {
                    tclObject3 = TclList.index(interp, tclObject2, n7);
                }
                Object object2 = ArrayObject.initArray(interp, tclObject, n, n6, n3, clazz2, tclObject3);
                Array.set(object, n7, object2);
                ++n7;
            }
        } else if (n5 > 0) {
            int n8 = Math.min(n4, n5);
            ArrayObject.setArrayElts(interp, object, 0, n8, tclObject2);
        }
        return object;
    }

    private static Object dereferenceArrayDims(Interp interp, Object object, int n, TclObject tclObject) throws TclException {
        int n2 = JavaInfoCmd.getNumDimsFromClass(object.getClass());
        if (n2 < n) {
            throw new TclException(interp, "bad indexList \"" + tclObject.toString() + "\": javaObj only has " + n2 + " dimension(s)");
        }
        Object object2 = object;
        int n3 = 0;
        while (n3 < n - 1) {
            int n4 = TclInteger.get(interp, TclList.index(interp, tclObject, n3));
            try {
                object2 = Array.get(object2, n4);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                int n5 = Array.getLength(object2) - 1;
                throw new TclException(interp, "array index \"" + n4 + "\" is out of bounds: must be between 0 and " + n5);
            }
            if (object2 == null) {
                throw new TclException(interp, "null value in dimension " + n3 + ": can't dereference " + n2 + " dimensions");
            }
            ++n3;
        }
        return object2;
    }

    static TclObject getArrayElts(Interp interp, Object object, int n, int n2, boolean bl) throws TclException {
        TclObject tclObject = TclList.newInstance();
        try {
            int n3 = 0;
            while (n3 < n2) {
                TclList.append(interp, tclObject, ArrayObject.getArrayElt(interp, object, n, bl));
                ++n3;
                ++n;
            }
        }
        catch (TclException tclException) {
            tclObject.release();
            throw tclException;
        }
        return tclObject;
    }

    static TclObject getArrayElt(Interp interp, Object object, int n, boolean bl) throws TclException {
        Object object2;
        try {
            object2 = Array.get(object, n);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            int n2 = Array.getLength(object) - 1;
            throw new TclException(interp, "array index \"" + n + "\" is out of bounds: must be between 0 and " + n2);
        }
        if (bl) {
            return JavaInvoke.convertJavaObject(interp, object.getClass().getComponentType(), object2);
        }
        return ReflectObject.newInstance(interp, object2);
    }

    static void setArrayElts(Interp interp, Object object, int n, int n2, TclObject tclObject) throws TclException {
        int n3 = 0;
        while (n3 < n2) {
            ArrayObject.setArrayElt(interp, object, n, TclList.index(interp, tclObject, n3));
            ++n3;
            ++n;
        }
    }

    static void setArrayElt(Interp interp, Object object, int n, TclObject tclObject) throws TclException {
        Class<?> clazz = object.getClass().getComponentType();
        Object object2 = JavaInvoke.convertTclObject(interp, clazz, tclObject);
        try {
            Array.set(object, n, object2);
            return;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            int n2 = Array.getLength(object) - 1;
            throw new TclException(interp, "array index \"" + n + "\" is out of bounds: must be between 0 and " + n2);
        }
    }

    static String getBaseName(String string) {
        if (string.endsWith("[]")) {
            int n = string.indexOf(91);
            return string.substring(0, n);
        }
        if (string.charAt(0) == '[') {
            if (string.endsWith("[")) {
                return string;
            }
            String string2 = string.substring(1);
            while (string2.charAt(0) == '[') {
                string2 = string2.substring(1);
            }
            if (string2.charAt(0) == 'L' && string2.endsWith(";")) {
                return string2.substring(1, string2.length() - 1);
            }
            if (string2.charAt(0) == 'I') {
                return "int";
            }
            if (string2.charAt(0) == 'Z') {
                return "boolean";
            }
            if (string2.charAt(0) == 'J') {
                return "long";
            }
            if (string2.charAt(0) == 'F') {
                return "float";
            }
            if (string2.charAt(0) == 'D') {
                return "double";
            }
            if (string2.charAt(0) == 'B') {
                return "byte";
            }
            if (string2.charAt(0) == 'S') {
                return "short";
            }
            if (string2.charAt(0) == 'C') {
                return "char";
            }
        }
        return string;
    }

    ArrayObject() {
    }
}

