/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.TclString;

class TclPosixException
extends TclException {
    static final int EPERM = 1;
    static final int ENOENT = 2;
    static final int ESRCH = 3;
    static final int EINTR = 4;
    static final int EIO = 5;
    static final int ENXIO = 6;
    static final int E2BIG = 7;
    static final int ENOEXEC = 8;
    static final int EBADF = 9;
    static final int ECHILD = 10;
    static final int EDEADLK = 11;
    static final int ENOMEM = 12;
    static final int EACCES = 13;
    static final int EFAULT = 14;
    static final int ENOTBLK = 15;
    static final int EBUSY = 16;
    static final int EEXIST = 17;
    static final int EXDEV = 18;
    static final int ENODEV = 19;
    static final int ENOTDIR = 20;
    static final int EISDIR = 21;
    static final int EINVAL = 22;
    static final int ENFILE = 23;
    static final int EMFILE = 24;
    static final int ENOTTY = 25;
    static final int ETXTBSY = 26;
    static final int EFBIG = 27;
    static final int ENOSPC = 28;
    static final int ESPIPE = 29;
    static final int EROFS = 30;
    static final int EMLINK = 31;
    static final int EPIPE = 32;
    static final int EDOM = 33;
    static final int ERANGE = 34;
    static final int EAGAIN = 35;
    static final int EWOULDBLOCK = 35;
    static final int EINPROGRESS = 36;
    static final int EALREADY = 37;
    static final int ENOTSOCK = 38;
    static final int EDESTADDRREQ = 39;
    static final int EMSGSIZE = 40;
    static final int EPROTOTYPE = 41;
    static final int ENOPROTOOPT = 42;
    static final int EPROTONOSUPPORT = 43;
    static final int ESOCKTNOSUPPORT = 44;
    static final int EOPNOTSUPP = 45;
    static final int EPFNOSUPPORT = 46;
    static final int EAFNOSUPPORT = 47;
    static final int EADDRINUSE = 48;
    static final int EADDRNOTAVAIL = 49;
    static final int ENETDOWN = 50;
    static final int ENETUNREACH = 51;
    static final int ENETRESET = 52;
    static final int ECONNABORTED = 53;
    static final int ECONNRESET = 54;
    static final int ENOBUFS = 55;
    static final int EISCONN = 56;
    static final int ENOTCONN = 57;
    static final int ESHUTDOWN = 58;
    static final int ETOOMANYREFS = 59;
    static final int ETIMEDOUT = 60;
    static final int ECONNREFUSED = 61;
    static final int ELOOP = 62;
    static final int ENAMETOOLONG = 63;
    static final int EHOSTDOWN = 64;
    static final int EHOSTUNREACH = 65;
    static final int ENOTEMPTY = 66;
    static final int EPROCLIM = 67;
    static final int EUSERS = 68;
    static final int EDQUOT = 69;
    static final int ESTALE = 70;
    static final int EREMOTE = 71;
    static final int EBADRPC = 72;
    static final int ERPCMISMATCH = 73;
    static final int EPROGUNAVAIL = 74;
    static final int EPROGMISMATCH = 75;
    static final int EPROCUNAVAIL = 76;
    static final int ENOLCK = 77;
    static final int ENOSYS = 78;
    static final int EFTYPE = 79;

    public TclPosixException(Interp interp, int n, String string) throws TclException {
        super(1);
        String string2 = TclPosixException.getPosixMsg(n);
        TclObject tclObject = TclList.newInstance();
        TclList.append(interp, tclObject, TclString.newInstance("posix"));
        TclList.append(interp, tclObject, TclString.newInstance(TclPosixException.getPosixId(n).toLowerCase()));
        TclList.append(interp, tclObject, TclString.newInstance(string2));
        interp.setErrorCode(tclObject);
        if (interp != null) {
            if (string == null) {
                interp.resetResult();
                return;
            }
            interp.setResult(TclString.newInstance(string));
        }
    }

    public TclPosixException(Interp interp, int n, boolean bl, String string) throws TclException {
        super(1);
        String string2 = TclPosixException.getPosixMsg(n);
        TclObject tclObject = TclList.newInstance();
        TclList.append(interp, tclObject, TclString.newInstance("posix"));
        TclList.append(interp, tclObject, TclString.newInstance(TclPosixException.getPosixId(n).toLowerCase()));
        TclList.append(interp, tclObject, TclString.newInstance(string2));
        interp.setErrorCode(tclObject);
        if (interp != null) {
            if (bl) {
                String string3 = String.valueOf(string) + ": " + string2;
                if (string3 == null) {
                    interp.resetResult();
                    return;
                }
                interp.setResult(TclString.newInstance(string3));
                return;
            }
            if (string == null) {
                interp.resetResult();
                return;
            }
            interp.setResult(TclString.newInstance(string));
        }
    }

    private static String getPosixId(int n) {
        switch (n) {
            case 7: {
                return "E2BIG";
            }
            case 13: {
                return "EACCES";
            }
            case 48: {
                return "EADDRINUSE";
            }
            case 49: {
                return "EADDRNOTAVAIL";
            }
            case 47: {
                return "EAFNOSUPPORT";
            }
            case 35: {
                return "EAGAIN";
            }
            case 37: {
                return "EALREADY";
            }
            case 9: {
                return "EBADF";
            }
            case 72: {
                return "EBADRPC";
            }
            case 16: {
                return "EBUSY";
            }
            case 10: {
                return "ECHILD";
            }
            case 53: {
                return "ECONNABORTED";
            }
            case 61: {
                return "ECONNREFUSED";
            }
            case 54: {
                return "ECONNRESET";
            }
            case 11: {
                return "EDEADLK";
            }
            case 39: {
                return "EDESTADDRREQ";
            }
            case 33: {
                return "EDOM";
            }
            case 69: {
                return "EDQUOT";
            }
            case 17: {
                return "EEXIST";
            }
            case 14: {
                return "EFAULT";
            }
            case 27: {
                return "EFBIG";
            }
            case 64: {
                return "EHOSTDOWN";
            }
            case 65: {
                return "EHOSTUNREACH";
            }
            case 36: {
                return "EINPROGRESS";
            }
            case 4: {
                return "EINTR";
            }
            case 22: {
                return "EINVAL";
            }
            case 5: {
                return "EIO";
            }
            case 56: {
                return "EISCONN";
            }
            case 21: {
                return "EISDIR";
            }
            case 62: {
                return "ELOOP";
            }
            case 31: {
                return "EMLINK";
            }
            case 40: {
                return "EMSGSIZE";
            }
            case 63: {
                return "ENAMETOOLONG";
            }
            case 50: {
                return "ENETDOWN";
            }
            case 52: {
                return "ENETRESET";
            }
            case 51: {
                return "ENETUNREACH";
            }
            case 23: {
                return "ENFILE";
            }
            case 55: {
                return "ENOBUFS";
            }
            case 19: {
                return "ENODEV";
            }
            case 2: {
                return "ENOENT";
            }
            case 8: {
                return "ENOEXEC";
            }
            case 77: {
                return "ENOLCK";
            }
            case 12: {
                return "ENOMEM";
            }
            case 42: {
                return "ENOPROTOOPT";
            }
            case 28: {
                return "ENOSPC";
            }
            case 78: {
                return "ENOSYS";
            }
            case 15: {
                return "ENOTBLK";
            }
            case 57: {
                return "ENOTCONN";
            }
            case 20: {
                return "ENOTDIR";
            }
            case 66: {
                return "ENOTEMPTY";
            }
            case 38: {
                return "ENOTSOCK";
            }
            case 25: {
                return "ENOTTY";
            }
            case 6: {
                return "ENXIO";
            }
            case 45: {
                return "EOPNOTSUPP";
            }
            case 1: {
                return "EPERM";
            }
            case 46: {
                return "EPFNOSUPPORT";
            }
            case 32: {
                return "EPIPE";
            }
            case 67: {
                return "EPROCLIM";
            }
            case 76: {
                return "EPROCUNAVAIL";
            }
            case 75: {
                return "EPROGMISMATCH";
            }
            case 74: {
                return "EPROGUNAVAIL";
            }
            case 43: {
                return "EPROTONOSUPPORT";
            }
            case 41: {
                return "EPROTOTYPE";
            }
            case 34: {
                return "ERANGE";
            }
            case 71: {
                return "EREMOTE";
            }
            case 30: {
                return "EROFS";
            }
            case 73: {
                return "ERPCMISMATCH";
            }
            case 58: {
                return "ESHUTDOWN";
            }
            case 44: {
                return "ESOCKTNOSUPPORT";
            }
            case 29: {
                return "ESPIPE";
            }
            case 3: {
                return "ESRCH";
            }
            case 70: {
                return "ESTALE";
            }
            case 60: {
                return "ETIMEDOUT";
            }
            case 59: {
                return "ETOOMANYREFS";
            }
            case 26: {
                return "ETXTBSY";
            }
            case 68: {
                return "EUSERS";
            }
            case 18: {
                return "EXDEV";
            }
        }
        return "unknown error";
    }

    static String getPosixMsg(int n) {
        switch (n) {
            case 7: {
                return "argument list too long";
            }
            case 13: {
                return "permission denied";
            }
            case 48: {
                return "address already in use";
            }
            case 49: {
                return "can't assign requested address";
            }
            case 47: {
                return "address family not supported by protocol family";
            }
            case 35: {
                return "resource temporarily unavailable";
            }
            case 37: {
                return "operation already in progress";
            }
            case 9: {
                return "bad file number";
            }
            case 72: {
                return "RPC structure is bad";
            }
            case 16: {
                return "file busy";
            }
            case 10: {
                return "no children";
            }
            case 53: {
                return "software caused connection abort";
            }
            case 61: {
                return "connection refused";
            }
            case 54: {
                return "connection reset by peer";
            }
            case 11: {
                return "resource deadlock avoided";
            }
            case 39: {
                return "destination address required";
            }
            case 33: {
                return "math argument out of range";
            }
            case 69: {
                return "disk quota exceeded";
            }
            case 17: {
                return "file already exists";
            }
            case 14: {
                return "bad address in system call argument";
            }
            case 27: {
                return "file too large";
            }
            case 64: {
                return "host is down";
            }
            case 65: {
                return "host is unreachable";
            }
            case 36: {
                return "operation now in progress";
            }
            case 4: {
                return "interrupted system call";
            }
            case 22: {
                return "invalid argument";
            }
            case 5: {
                return "I/O error";
            }
            case 56: {
                return "socket is already connected";
            }
            case 21: {
                return "illegal operation on a directory";
            }
            case 62: {
                return "too many levels of symbolic links";
            }
            case 24: {
                return "too many open files";
            }
            case 31: {
                return "too many links";
            }
            case 40: {
                return "message too long";
            }
            case 63: {
                return "file name too long";
            }
            case 50: {
                return "network is down";
            }
            case 52: {
                return "network dropped connection on reset";
            }
            case 51: {
                return "network is unreachable";
            }
            case 23: {
                return "file table overflow";
            }
            case 55: {
                return "no buffer space available";
            }
            case 19: {
                return "no such device";
            }
            case 2: {
                return "no such file or directory";
            }
            case 8: {
                return "exec format error";
            }
            case 77: {
                return "no locks available";
            }
            case 12: {
                return "not enough memory";
            }
            case 42: {
                return "bad proocol option";
            }
            case 28: {
                return "no space left on device";
            }
            case 78: {
                return "function not implemented";
            }
            case 15: {
                return "block device required";
            }
            case 57: {
                return "socket is not connected";
            }
            case 20: {
                return "not a directory";
            }
            case 66: {
                return "directory not empty";
            }
            case 38: {
                return "socket operation on non-socket";
            }
            case 25: {
                return "inappropriate device for ioctl";
            }
            case 6: {
                return "no such device or address";
            }
            case 45: {
                return "operation not supported on socket";
            }
            case 1: {
                return "not owner";
            }
            case 46: {
                return "protocol family not supported";
            }
            case 32: {
                return "broken pipe";
            }
            case 67: {
                return "too many processes";
            }
            case 76: {
                return "bad procedure for program";
            }
            case 75: {
                return "program version wrong";
            }
            case 74: {
                return "RPC program not available";
            }
            case 43: {
                return "protocol not suppored";
            }
            case 41: {
                return "protocol wrong type for socket";
            }
            case 34: {
                return "math result unrepresentable";
            }
            case 71: {
                return "pathname hit remote file system";
            }
            case 30: {
                return "read-only file system";
            }
            case 73: {
                return "RPC version is wrong";
            }
            case 58: {
                return "can't send afer socket shutdown";
            }
            case 44: {
                return "socket type not supported";
            }
            case 29: {
                return "invalid seek";
            }
            case 3: {
                return "no such process";
            }
            case 70: {
                return "stale remote file handle";
            }
            case 60: {
                return "connection timed out";
            }
            case 59: {
                return "too many references: can't splice";
            }
            case 26: {
                return "text file or pseudo-device busy";
            }
            case 68: {
                return "too many users";
            }
            case 18: {
                return "cross-domain link";
            }
        }
        return "unknown POSIX error";
    }
}

