'\"
'\" Copyright (c) 1995 DSC Technologies Corporation
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\"
'\" @(#) mainwindow.n 1.21 94/12/17 16:04:44
'/" 
.so man.macros
.HS mainwindow iwid
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
mainwindow \- Create and manipulate a mainwindow widget
.SH SYNOPSIS
\fBmainwindow\fI \fIpathName \fR?\fIoptions\fR?
.SH "INHERITANCE"
itk::Toplevel <- shell <- mainwindow
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fBbackground\fR	\fBcursor\fR	\fBdisabledForeground\fR	\fBfont\fR
\fBforeground\fR	\fBhighlightBackground\fR	\fBhighlightColor\fR	\fBhighlightThickness\fR
.fi
.LP
See the "options" manual entry for details on the standard options.
.SH "ASSOCIATED OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fBballoonBackground\fR	\fBballoonDelay1\fR	\fBballoonDelay2\fR	\fBballonFont\fR
\fBballoonForeground\fR
.fi
.LP
See the "toolbar" manual entry for details on the above associated options.
.SH "INHERITED OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fBtitle\fR 
.fi
.LP
See the "Toplevel" manual entry for details on the above inherited options.
.LP
.nf
.ta 4c 8c 12c
\fBheight\fR	\fBmaster\fR	\fBmodality\fR	\fBpadX\fR
\fBpadY\fR	\fBwidth\fR
.fi
.LP
See the "shell" manual entry for details on the above inherited options.

.SH "WIDGET-SPECIFIC OPTIONS"
.LP
.nf
Name:	\fBhelpLine\fR
Class:	\fBHelpLine\fR
Command-Line Switch:	\fB-helpline\fR
.fi
.IP
Specifies whether or not to display the help line.  The value
may be given in any of the forms acceptable to Tk_GetBoolean.
The default is yes.
.LP
.nf
Name:	\fBmenuBarBackground\fR
Class:	\fBBackground\fR
Command-Line Switch:	\fB-menubarbackground\fR
.fi
.IP
Specifies the normal background color for the menubar.
.LP
.nf
Name:	\fBmenuBarFont\fR
Class:	\fBFont\fR
Command-Line Switch:	\fB-menubarfont\fR
.fi
.IP
Specifies the font to use when drawing text inside the menubar.
.LP
.nf
Name:	\fBmenuBarForeround\fR
Class:	\fBForeground\fR
Command-Line Switch:	\fB-menubarforeground\fR
.fi
.IP
Specifies the normal foreground color for the menubar.
.LP
.nf
Name:	\fBstatusLine\fR
Class:	\fBStatusLine\fR
Command-Line Switch:	\fB-statusline\fR
.fi
.IP
Specifies whether or not to display the status line.  The value
may be given in any of the forms acceptable to Tk_GetBoolean.
The default is yes.
.LP
.nf
Name:	\fBtoolBarBackground\fR
Class:	\fBBackground\fR
Command-Line Switch:	\fB-toolbarbackground\fR
.fi
.IP
Specifies the normal background color for the toolbar.
.LP
.nf
Name:	\fBtoolBarFont\fR
Class:	\fBFont\fR
Command-Line Switch:	\fB-toolbarfont\fR
.fi
.IP
Specifies the font to use when drawing text inside the toolbar.
.LP
.nf
Name:	\fBtoolBarForeround\fR
Class:	\fBForeground\fR
Command-Line Switch:	\fB-toolbarforeground\fR
.fi
.IP
Specifies the normal foreground color for the toolbar.
.BE

.SH DESCRIPTION
.PP
The \fBmainwindow\fR command creates a mainwindow shell which contains
a menubar, toolbar, mousebar, childsite, status line, and help line.  
Each item may be filled and configured to suit individual needs.

.SH "METHODS"
.PP
The \fBmainwindow\fR command create a new Tcl command whose
name is \fIpathName\fR.  This command may be used to invoke various
operations on the widget.  It has the following general form:
.DS C
\fIpathName option \fR?\fIarg arg ...\fR?
.DE
\fIOption\fR and the \fIarg\fRs
determine the exact behavior of the command.  The following
commands are possible for mainwindow widgets:
.SH "INHERITED METHODS"
.LP
.nf
.ta 4c 8c 12c
\fBactivate\fR	\fBcenter\fR	\fBdeactivate\fR
.fi
.LP
See the "shell" manual entry for details on the above inherited methods.
.SH "WIDGET-SPECIFIC METHODS"
.TP
\fIpathName \fBcget\fR \fIoption\fR
Returns the current value of the configuration option given
by \fIoption\fR.
\fIOption\fR may have any of the values accepted by the \fBmainwindow\fR
command.
.TP
\fIpathName \fBchildsite\fR
Returns the pathname of the child site widget.
.TP
\fIpathName\fR \fBconfigure\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?
Query or modify the configuration options of the widget.
If no \fIoption\fR is specified, returns a list describing all of
the available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s);  in
this case the command returns an empty string.
\fIOption\fR may have any of the values accepted by the \fBmainwindow\fR
command.
.TP
\fIpathName \fBmenubar\fR ?\fIargs\fR?
The \fBmenubar\fR method provides access to the menubar.  Invoked with
no arguments it returns the pathname of the menubar.  With arguments,
they are evaluated against the menubar which in effect provides
access to the entire API of the menubar.  See the "menubar" manual
entry for details on the commands available in the menubar.
.TP
\fIpathName \fBmousebar\fR ?\fIargs\fR?
The \fBmousebar\fR method provides access to the mousebar which is a 
vertical toolbar.  Invoked with no arguments it returns the pathname 
of the mousebar.  With arguments, they are evaluated against the mousebar 
which in effect provides access to the entire API of the underlying 
toolbar.  See the "toolbar" manual entry for details on the commands 
available in the mousebar.
.TP
\fIpathName \fBmsgd\fR ?\fIargs\fR?
The \fBmsgd\fR method provides access to the messagedialog contained
in the mainwindow.  Invoked with no arguments it returns the pathname 
of the messagedialog.  With arguments, they are evaluated against the 
messagedialog which in effect provides access to the entire API of the 
messagedialog.  See the "messagedialog" manual
entry for details on the commands available in the messagedialog.
.TP
\fIpathName \fBtoolbar\fR ?\fIargs\fR?
The \fBtoolbar\fR method provides access to the toolbar.  Invoked with
no arguments it returns the pathname of the toolbar.  With arguments,
they are evaluated against the toolbar which in effect provides
access to the entire API of the toolbar.  See the "toolbar" manual
entry for details on the commands available in the toolbar.

.SH "COMPONENTS"
.LP
.nf
Name:	\fBhelp\fR
Class:	\fBLabel\fR
.fi
.IP
The help component provides a location for displaying any help
strings provided in the menubar, toolbar, or mousebar.  See the "label" 
widget manual entry for details on the help component item.
.LP
.nf
Name:	\fBmenubar\fR
Class:	\fBMenubar\fR
.fi
.IP
The menubar component is the menubar located at the top of the window.
See the "menubar" widget manual entry for details on the menubar 
component item.
.LP
.nf
Name:	\fBmousebar\fR
Class:	\fBToolbar\fR
.fi
.IP
The mousebar component is the vertical toolbar located on the right side
of the window.  See the "toolbar" widget manual entry for details on 
the mousebar component item.
.LP
.nf
Name:	\fBmsgd\fR
Class:	\fBMessagedialog\fR
.fi
.IP
The msgd component is a messagedialog which may be reconfigured as needed 
and used repeatedly throughout the application.  See the "messagedialog" 
widget manual entry for details on the messagedialog component item.
.LP
.nf
Name:	\fBstatus\fR
Class:	\fBLabel\fR
.fi
.IP
The status component provides a location for displaying application
status information.  See the "label" widget manual entry for details 
on the status component item.
.LP
.nf
Name:	\fBtoolbar\fR
Class:	\fBToolbar\fR
.fi
.IP
The toolbar component is the horizontal toolbar located on the top 
of the window.  See the "toolbar" widget manual entry for details on 
the toolbar component item.
.fi

.SH EXAMPLE
.DS
 mainwindow .mw

 #
 # Add a File menubutton
 #
 .mw menubar add menubutton file -text "File" -underline 0 -padx 8 -pady 2 \\
    -menu {options -tearoff no
	   command new -label "New" -underline 0 \\
	       -helpstr "Create a new file"
	   command open -label "Open ..." -underline 0 \\
	       -helpstr "Open an existing file"
	   command save -label "Save" -underline 0 \\
	       -helpstr "Save the current file"
	   command saveas -label "Save As ..." -underline 5 \\
	       -helpstr "Save the file as a differnet name"
	   command print -label "Print" -underline 0 \\
	       -helpstr "Print the file"
           separator sep1
	   command close -label "Close" -underline 0 \\
	       -helpstr "Close the file"
	   separator sep2
	   command exit -label "Exit" -underline 1 \\
	       -helpstr "Exit this application" 
    }

 #
 # Install a scrolledtext widget in the childsite.
 #
 scrolledtext [.mw childsite].st
 pack [.mw childsite].st -fill both -expand yes

 #
 # Activate the main window.
 #
 .mw activate
.DE
.SH AUTHOR
Mark L. Ulferts
.DE
John A. Tucker
.LP
.SH KEYWORDS
mainwindow, shell, widget
