[manpage_begin httpd::session n 1.0]
[copyright {2003 Andreas Kupries <andreas_kupries@users.sourceforge.net>}]
[titledesc {Session management}]
[moddesc   {Tcl Web Server}]
[require httpd::session [opt 1.0]]
[description]

The package [package httpd::session] implements session management
for a tcl based web server.

The basic idea is to implement a session as a safe slave interpreter
that holds its state. Each session has a four-character ID, allowing
around 128^4 different sessions, assuming the ASCII character set.

[para]

[emph Note:] This package does not care where a session id comes
from. They can be provided through hidden form data, or through
cookies, for example. This is in the area of responsibility of the
code making use of the package.

[section {Public API}]
[para]

[list_begin definitions]

[call [cmd Session_Create] [arg type] [opt [arg isSafe]]]

Creates a new session and returns its ID. By default the
interpreter created for the session is marked as save, but this
can be deactivated by specifying [const false] for [arg isSafe].

[nl]

The [arg type] determines what commands are available in the slave
interpreter for the session: All commands in the master interpreter
whose name begins with [const [var type]_] are made available as
aliases to the new slave. Inside of the slave the prefix

[const [var type]_] will be stripped off. Additional automatisms: If
the first argument of the command is [const interp] or [const session]
the alias command will automatically called with either the session
interp or the session id. Note that the latter allows determination of
the former.

[nl]

Standard commands available to the seesion interpreter are:

[list_begin definitions]
[lst_item [cmd session]]
Returns the seesion id.

[lst_item [cmd sequence]]
Returns an increasing sequence number which can be used to chain
together pages and detect bookmarks and "backs" that screw things up.

[lst_item [cmd group]]
Set or get the current session "group". In the session interp a group
is simply an array.

[lst_item [cmd value]]
Get a value from the current "group", or a default value.

[list_end]


[call [cmd Session_CreateWithID] [arg {type id}] [opt [arg isSafe]]]

Like [cmd Session_Create], except that the [arg id] is not randomly
chosen, but specified by the caller.

[call [cmd Session_Destroy] [arg id]]

This command destroys the specified session.

[call [cmd Session_Reap] [arg age] [opt [arg type]]]

This command destroys all sessions which have not been touched for at
least [arg age] seconds and are matching the [arg type]. The latter is
a regexp pattern and defaults to [const .*], i.e. everything matches.


[call [cmd Session_Match] [arg querylist] [opt [arg type]] [opt [arg error_name]] [opt [arg isSafe]]]

Finds a session based on the form data which is stored in the
dictionary [arg query]. Assumes the existence of a form variable named
[const session].

[nl]

If the value of that variable is [const new] a new session is
created. If it is [const "kill [var ID]"] the session with that id is
destroyed. Else the value is used to look for an existing session. If
a [arg type] is specified the found session has to be of that type or
an error will be thrown. If the session has a sequence number the
system expects a form variable [const sequence] and its value has
to match.

[nl]

[arg error_name] is the name of the variable where an error message
will be stored if something goes wrong. The last argument,

[arg isSafe] has the same meaning as for [cmd Sequence_Create].

[nl]

The command returns the session id for the session, or the empty
string if none could be found.
	  
[call [cmd Session_Authorized] [arg id]]

This command returns the interpreter for the session having the
specified [arg id] and installs privileged aliases. If the session
does not exist it will be created.

[nl]

An authorized interpreter has two additional commands available
to it:

[list_begin definitions]
[lst_item "[cmd require] [arg tag]"]
Loads and initializes packages based on the [arg tag]. Calls
a command "[arg tag]_Init" with the session array and returns
its result as the HTML generated by this command.

[lst_item [cmd exit]]
Destroys the session.

[list_end]


[call [cmd Session_Require] [arg {id tag}]]

See above, [cmd Session_Authorized]. This implements the [cmd require]
command to load and initialize special packages in the session
interpreter.


[call [cmd Session_Import] [arg {valid array}] [opt [arg interp]]]

Imports the valid components of the [arg array] in [arg interp] as
variables into the local scope. [arg valid] is the name of an array
whose keys are the valid components to import (prefix with a dash). If
valid is the empty string all components of the array are imported.

[nl]

If no [arg interp] was specified the main interp is used as source.


[call [cmd Session_Session] [arg arg]]

Returns the argument. This implements the [cmd session] command
for session interpreters.


[call [cmd Session_Sequence] [arg id]]

Generates a sequence value and returns it. This implements the
[cmd sequence] command for session interpreters.


[call [cmd Session_Variable] [arg {id var}] [opt [arg value]]]

Sets or gets data from the global state associated with the session
interpreter. This is used to implement the [cmd group] command for
session interpreters.


[call [cmd Session_Value] [arg {id var}] [opt [arg default]]]

Gets a value from the current group, or a default if the group does
not have a component called [arg var]. This implements the [cmd value]
command for session interpreters.

[list_end]

[see_also httpd httpd::utils]
[keywords {web server} sessions]
[manpage_end]
