[manpage_begin sha1 n 1.0.2]
[moddesc   {sha1 hash}]
[titledesc {Perform sha1 hashing}]
[require Tcl 8.2]
[require sha1 [opt 1.0.2]]
[description]
[para]

This package provides commands to compute a SHA1 digests of arbitrary
messages.

[section COMMANDS]
[list_begin definitions]
[call [cmd ::sha1::sha1] [arg msg]]

The command takes a message and returns the SHA1 digest of this message
as a hexadecimal string.

[call [cmd ::sha1::hmac] [arg key] [arg text]]

The command takes a key string and a text and returns the hmac of the

[list_end]

[section EXAMPLES]

[para]
[example {
% sha1::sha1 "hello world"
2aae6c35c94fcfb415dbe95f408b9ce91ee846ed
}]

[para]
[example {
% sha1::hmac "our little secret" "hello world"
a7ed9d62819b9788e22171d9108a00c370104526
}]

[keywords sha1 hashing security]
[manpage_end]
