'\"
'\" Copyright (c) 1998-2000 by Ajuba Solutions.
'\" All rights reserved.
'\" 
'\" RCS: @(#) $Id: ncgi.n,v 1.9 2002/01/18 20:51:16 andreas_kupries Exp $
'\" 
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2000/03/06 21:34:53 ericm Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH ncgi n 1.2.1 Ncgi "CGI Support"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
::ncgi \- Procedures to manipulate CGI values.
.SH SYNOPSIS
.BS
.sp
\fBpackage require Tcl 8.2\fR
.sp
\fBpackage require ncgi ?1.2.1?\fR
.sp
\fBncgi::cookie\fR \fIcookie\fR
.sp
\fBncgi::decode\fR \fIstr\fR
.sp
\fBncgi::empty\fR \fIname\fR
.sp
\fBncgi::encode\fR \fIstring\fR
.sp
\fBncgi::header\fR \fI{type text/html} args\fR
.sp
\fBncgi::import\fR \fIcginame {tclname {}}\fR
.sp
\fBncgi::importAll\fR \fIargs\fR
.sp
\fBncgi::input\fR \fI{fakeinput {}} {fakecookie {}}\fR
.sp
\fBncgi::multipart\fR \fItype query\fR
.sp
\fBncgi::nvlist\fR \fI\fR
.sp
\fBncgi::parse\fR \fI\fR
.sp
\fBncgi::parseMimeValue\fR \fIvalue\fR
.sp
\fBncgi::query\fR \fI\fR
.sp
\fBncgi::redirect\fR \fIurl\fR
.sp
\fBncgi::reset\fR \fIargs\fR
.sp
\fBncgi::setCookie\fR \fIargs\fR
.sp
\fBncgi::setDefaultValue\fR \fIkey defvalue\fR
.sp
\fBncgi::setDefaultValueList\fR \fIkey defvaluelist\fR
.sp
\fBncgi::setValue\fR \fIkey value\fR
.sp
\fBncgi::setValueList\fR \fIkey valuelist\fR
.sp
\fBncgi::type\fR \fI\fR
.sp
\fBncgi::urlStub\fR \fI{url {}}\fR
.sp
\fBncgi::value\fR \fIkey {default {}}\fR
.sp
\fBncgi::valueList\fR \fIkey {default {}}\fR
.BE
.SH DESCRIPTION
.PP
The \fB::ncgi\fR package provides commands that manipulate CGI
values.  These are values that come from Web forms and are
processed either by CGI scripts or web pages with embedded Tcl
code.  Use the \fB::ncgi\fP package to query these values,
set and get cookies, and encode and decode www-url-encoded values.

.PP
In the simplest case, a CGI script first calls
\fBncgi::parse\fP and then calls \fBncgi::value\fP to get different
form values.  If a CGI value is repeated, you should use
\fBncgi::valueList\fP to get back the complete list of values.

.PP
An alternative to \fBncgi::parse\fP is \fBncgi::input\fP,
which has semantics similar to Don Libes' \fBcgi_input\fP procedure.
\fBncgi::input\fP restricts repeated CGI values to have names
that end with "List".  In this case, \fBncgi::value\fP will return
the complete list of values, and \fBncgi::input\fP will raise
errors if it find repeated form elements without the right name.

.PP
The \fBncgi::reset\fP procedure can be used in test suites and
Web servers to initialize the source of the CGI values.
Otherwise the values are read in from the CGI environment.

.PP
The complete set of procedures is described below.

.TP
\fBncgi::cookie\fR \fIcookie\fR
Return a list of values for \fIcookie\fP, if any.
It is possible that more than one cookie with the same name can
be present, so this procedure returns a list.

.TP
\fBncgi::decode\fR \fIstr\fR
Decode strings in www-url-encoding, which represents special
characters with a %xx sequence, where xx is the character code in hex.

.TP
\fBncgi::empty\fR \fIname\fR
Returns 1 if the CGI variable \fIname\fP is not present or has
the empty string as its value.

.TP
\fBncgi::encode\fR \fIstring\fR
Encode \fBstring\fR into www-url-encoded format.

.TP
\fBncgi::header\fR \fI{type text/html} args\fR
Output the CGI header to standard output.
This emits a Content-Type: header and additional headers based
on \fIargs\fP, which is a list of
header names and header values.

.TP
\fBncgi::import\fR \fIcginame {tclname {}}\fR
This creates a variable in the current scope with the
value of the CGI variable \fIcginame\fP.
The name of the variable is \fItclname\fP, or
\fIcginame\fP if \fItclname\fP is empty.

.TP
\fBncgi::importAll\fR \fIargs\fR
This imports several CGI variables as Tcl variables.
If \fIargs\fP is empty, then every CGI vale is imported.
Otherwise each CGI variable listed in \fIargs\fP is imported.

.TP
\fBncgi::input\fR \fI{fakeinput {}} {fakecookie {}}\fR
This reads and decodes the CGI values from the environment.
It restricts repeated form values to have a trailing
"List" in their name.  The CGI values are obtained later with
the \fBncgi::value\fP procedure.

.TP
\fBncgi::multipart\fR \fItype query\fR
This procedure parses a multipart/form-data \fIquery\fP.
This is used by \fBncgi::nvlist\fP and not normally called directly.
It returns an alternating list of names and structured values.
Each structure value is in turn a list of two elements.
The first element is meta-data from the multipart/form-data structure.
The second element is the form value.  If you use
\fBncgi::value\fP you just get the form value.
If you use \fBncgi::valueList\fP you get the structured value
with meta data and the value.

The \fItype\fP is the whole Content-Type, including the
parameters like \fBboundary\fP.  This returns a list
of names and values
that describe the multipart data.
The values are a nested list structure that has some 
descriptive information first, and the actual form value second.
The descriptive information is list of header names and
values that describe the content.

.TP
\fBncgi::nvlist\fR \fI\fR
This returns all the query data as a name, value list.
In the case of multipart/form-data, the values are structured as
described in \fBncgi::multipart\fP.

.TP
\fBncgi::parse\fR \fI\fR
This reads and decodes the CGI values from the environment.
The CGI values are obtained later with
the \fBncgi::value\fP procedure.
IF a CGI value is repeated, then you should use
\fBncgi::valueList\fP to get the complete list of values.

.TP
\fBncgi::parseMimeValue\fR \fIvalue\fR
This decodes the Content-Type and other MIME headers that have
the form of "primary value; param=val; p2=v2"
It returns a list, where the first element is the primary value,
and the second element is a list of parameter names and values.

.TP
\fBncgi::query\fR \fI\fR
This returns the raw query data.

.TP
\fBncgi::redirect\fR \fIurl\fR
Generate a response that causes a 302 redirect by the Web server.
The \fIurl\fP is the new URL that is the target of the redirect.
The URL will be qualified with the current server and current
directory, if necessary, to convert it into a full URL.

.TP
\fBncgi::reset\fR \fIquery type\fR
Set the query data and Content-Type for the current CGI session.
This is used by the test suite and by Web servers to initialize
the ncgi module so it does not try to read standard input or
use environment variables to get its data.
If neither \fIquery\fP or \fItype\fP are specified, then 
the \fBncgi\fP module will look
in the standard CGI environment for its data.

.TP
\fBncgi::setCookie\fR \fIargs\fR
Set a cookie value that will be returned as part of the reply.
This must be done before \fBncgi::header\fP or
\fBncgi::redirect\fP is called in order for the cookie to
be returned properly.
The \fIargs\fP are a set of flags and values:

.DS
-name \fIname\fP
-value \fIvalue\fP
-expires \fIdate\fP
-path \fIpath restriction\fP
-domain \fIdomain restriction\fP
.DE

.TP
\fBncgi::setDefaultValue\fR \fIkey defvalue\fR
Set a CGI value if it does not already exists.
This affects future calls to \fBncgi::value\fR (but not future
calls to \fBncgi::nvlist\fR).
If the CGI value already is present, then this procedure has
no side effects.
.TP
\fBncgi::setDefaultValueList\fR \fIkey defvaluelist\fR
Like \fBncgi::setDefaultValue\fR except that the value already
has list structure to represent multiple checkboxes or a multi-selection.
.TP
\fBncgi::setValue\fR \fIkey value\fR
Set a CGI value, overriding whatever was present in the CGI environment already.
This affects future calls to \fBncgi::value\fR (but not future
calls to \fBncgi::nvlist\fR).
.TP
\fBncgi::setValueList\fR \fIkey valuelist\fR
Like \fBncgi::setValue\fR except that the value already
has list structure to represent multiple checkboxes or a multi-selection.

.TP
\fBncgi::type\fR \fI\fR
Returns the Content-Type of the current CGI values.

.TP
\fBncgi::urlStub\fR \fI{url {}}\fR
Returns the current URL, but without the protocol, server, and port.
If \fIurl\fP is specified, then it defines the URL for the
current session.  That value will be returned by future calls to
\fBncgi::urlStub\fR

.TP
\fBncgi::value\fR \fIkey {default {}}\fR
Return the CGI value identified by \fIkey\fP.
If the CGI value is not present, then the \fIdefault\fP value
is returned instead.
If the form value \fIkey\fP is repeated, then there are
two cases:  if \fBncgi::parse\fP was called, then 
\fBncgi::value\fR only returns the first value associated with \fIkey\fP.
If \fBncgi::input\fP was called, then \fBncgi::value\fR returns a
Tcl list value and \fIkey\fP must end in "List" (e.g., "skuList").
In the case of multipart/form-data, this procedure just returns the value
of the form element.  If you want the meta-data associated with
each form value, then use \fBncgi::valueList\fP.

.TP
\fBncgi::valueList\fR \fIkey {default {}}\fR
Like \fBncgi::value\fP, but this always returns a list of values
(even if there is only one value).
In the case of multipart/form-data, this procedure returns a list of
two elements.  The first element is meta-data in the form of a parameter, value
list.  The second element is the form value.


.SH SEE ALSO
html

.SH KEYWORDS
CGI, form, html, cookie
