'\"
'\" Generated from ../tcllib/modules/crc/cksum.man by mpexpand with fmt.nroff
'\"
.so man.macros
.TH "cksum" n 1.0 crc "cksum"
.BS
.SH NAME
cksum \- calculate a cksum(1) compatible checksum
.SH "SYNOPSIS"
package require \fBTcl 8.2\fR
.sp
package require \fBcksum ?1.0?\fR
.sp
\fB::crc::cksum\fR ?-format \fIformat\fR? \fImessage\fR\fR
.sp
\fB::crc::cksum\fR ?-format \fIformat\fR? -filename \fIfile\fR\fR
.sp
.BE
.SH "DESCRIPTION"
.PP
This package provides a Tcl-only implementation of the cksum(1)
algorithm based upon information provided at in the GNU implementation
of this program as part of the GNU Textutils 2.0 package.
.SH "COMMANDS"
.TP
\fB::crc::cksum\fR ?-format \fIformat\fR? \fImessage\fR\fR
.TP
\fB::crc::cksum\fR ?-format \fIformat\fR? -filename \fIfile\fR\fR
The command takes string data or a file name and returns a checksum
value calculated using the \fBcksum(1)\fR algorithm. The result is
formatted using the \fIformat\fR(n) specifier provided or as an
unsigned integer (%u) by default.
.SH "OPTIONS"
.TP
-filename \fIname\fR
Return a checksum for the file contents instead of for parameter data.
.TP
-format \fIstring\fR
Return the checksum using an alternative format template.
.SH "EXAMPLES"
.PP
.nf
% crc::cksum "Hello, World!"
2609532967
.fi
.PP
.nf
% crc::cksum -format 0x%X "Hello, World!"
0x9B8A5027
.fi
.PP
.nf
% crc::cksum -file cksum.tcl
1828321145
.fi
.SH "SEE ALSO"
sum(n), crc32(n)
.SH "AUTHORS"
Pat Thoyts
.SH "KEYWORDS"
cksum, checksum, crc, crc32, cyclic redundancy check, data integrity, security

